CREATE SEQUENCE conversation_attachment_seq
    START WITH 0
    MINVALUE 0
    INCREMENT BY 1
    NOCACHE
    NOCYCLE;

CREATE TABLE conversation_attachment (
    id number(19) NOT NULL,
    message_id number(19) NOT NULL,
    document_id varchar2(255 char) NOT NULL,
    document_version_id varchar2(255 char) NOT NULL,
    filename varchar2(255 char),
    file_size number(19) DEFAULT 0,
    content_type varchar2(255 char),
    version varchar2(255 char) NOT NULL,
    attachment_type varchar2(255 char) NOT NULL,
    image_height number(10),
    image_width number(10),
    create_date timestamp DEFAULT systimestamp NOT NULL,
    CONSTRAINT conv_attachment_pk PRIMARY KEY (id),
    CONSTRAINT conv_attachment_msg_fk FOREIGN KEY (message_id) REFERENCES conversation_message(id) ON DELETE CASCADE
);

CREATE TABLE sh_conversation_attachment (
    id number(19),
    message_id number(19),
    document_id varchar2(255 char),
    document_version_id varchar2(255 char),
    filename varchar2(255 char),
    file_size number(19),
    content_type varchar2(255 char),
    version varchar2(255 char),
    attachment_type varchar2(255 char),
    image_height number(10),
    image_width number(10),
    create_date timestamp,
    DELETE_ACTION_ID number(19, 0) NOT NULL,
    FOREIGN KEY (DELETE_ACTION_ID) REFERENCES DELETE_ACTION (ID),
    PRIMARY KEY(ID)
);

INSERT INTO shadow_table (TABLE_NAME,SHADOW_TABLE_NAME,DELETE_ACTION_MANDATORY) VALUES ('CONVERSATION_ATTACHMENT','SH_CONVERSATION_ATTACHMENT','f');

INSERT INTO conversation_attachment(id, message_id, document_id, document_version_id, version, attachment_type, image_height, image_width, create_date)
SELECT conversation_attachment_seq.nextval,
       id,
       REGEXP_SUBSTR(message, '"documentId":"([^"]*)"', 1, 1, 'c', 1),
       REGEXP_SUBSTR(message, '"documentVersionId":"([^"]*)"', 1, 1, 'c', 1),
       '1',
       'NEW_ATTACHMENT',
       CASE
         WHEN REGEXP_SUBSTR(message, '"imageHeight":([0-9]+)', 1, 1, 'c', 1) is not null
         THEN TO_NUMBER(REGEXP_SUBSTR(message, '"imageHeight":([0-9]+)', 1, 1, 'c', 1))
         ELSE null
       END,
       CASE
         WHEN REGEXP_SUBSTR(message, '"imageWidth":([0-9]+)', 1, 1, 'c', 1) is not null
         THEN TO_NUMBER(REGEXP_SUBSTR(message, '"imageWidth":([0-9]+)', 1, 1, 'c', 1))
         ELSE null
       END,
       create_date
FROM conversation_message
WHERE message_type = 'ATTACHMENT_CHAT_MESSAGE';

UPDATE conversation_attachment ca
SET (filename, file_size, content_type) = (
    SELECT ddi.name, ddi.file_size, ddi.mime_type
    FROM drive_document_item ddi
    WHERE ddi.id = ca.document_id AND ddi.publicity = 'PUBLIC'
);

UPDATE conversation_attachment ca
SET (filename, file_size, content_type) = (
    SELECT REGEXP_SUBSTR(message, '"filename":"([^"]*)"', 1, 1, 'c', 1),
    TO_NUMBER(COALESCE(dbms_lob.substr(REGEXP_SUBSTR(message, '"size":([0-9]+)', 1, 1, 'c', 1), 19, 1), '0')),
    COALESCE(dbms_lob.substr(REGEXP_SUBSTR(message, '"contentType":"([^"]*)"', 1, 1, 'c', 1), 255, 1), 'application/octet-stream')
    FROM conversation_message cm
    WHERE ca.message_id = cm.id
)
WHERE ca.filename IS NULL;

CREATE INDEX conv_attachment_msg_fk_idx ON conversation_attachment(message_id);

ALTER TABLE conversation_attachment
MODIFY (
    filename NOT NULL,
    file_size NOT NULL,
    content_type NOT NULL
);

ALTER TABLE conversation_message MODIFY message NULL;
ALTER TABLE conversation_message DROP COLUMN attachment_content_type;
ALTER TABLE sh_conversation_message DROP COLUMN attachment_content_type;

UPDATE conversation_message
SET message = null
WHERE message_type IN ('ATTACHMENT_CHAT_MESSAGE', 'DELETED_CHAT_MESSAGE');

COMMIT;
