CREATE TABLE newszoom_config (
    tenant_id RAW(16) NOT NULL PRIMARY KEY,
    cycle_automatically CHAR(1 CHAR) DEFAULT ('t') NOT NULL,
    open_on varchar2(255 char) DEFAULT ('LOGIN') NOT NULL,
    ctime timestamp DEFAULT systimestamp NOT NULL,
    mtime timestamp DEFAULT systimestamp NOT NULL
);

CREATE TABLE newszoom_section (
    id RAW(16) NOT NULL PRIMARY KEY,
    tenant_id RAW(16) NOT NULL,
    name varchar(100) NOT NULL,
    order_index integer NOT NULL,
    show_only_pinned CHAR(1 CHAR) DEFAULT ('t') NOT NULL,
    ctime timestamp DEFAULT systimestamp NOT NULL,
    mtime timestamp DEFAULT systimestamp NOT NULL,
    CONSTRAINT tenant_id_fk FOREIGN KEY (tenant_id) REFERENCES tenant(id) ON DELETE CASCADE
);

CREATE TABLE newszoom_section_channel (
    section_id RAW(16) NOT NULL,
    channel_id VARCHAR(255) NOT NULL,
    ctime timestamp DEFAULT systimestamp NOT NULL,
    mtime timestamp DEFAULT systimestamp NOT NULL,
    CONSTRAINT newszoom_section_channel_pk PRIMARY KEY (section_id, channel_id),
    CONSTRAINT section_id_fk FOREIGN KEY (section_id) REFERENCES newszoom_section(id) ON DELETE CASCADE
);

COMMIT;
