CREATE OR REPLACE PROCEDURE ctime_mtime_columns(tname VARCHAR2)
IS
BEGIN
    EXECUTE IMMEDIATE 'ALTER TABLE ' || tname || ' ADD (ctime TIMESTAMP DEFAULT SYSDATE NOT NULL,mtime TIMESTAMP DEFAULT SYSTIMESTAMP NOT NULL )';
    EXECUTE IMMEDIATE 'CREATE TRIGGER ' || tname || '_t BEFORE UPDATE ON ' || tname || ' FOR EACH ROW BEGIN :new.mtime := SYSTIMESTAMP; END;';
END ctime_mtime_columns;
/
COMMIT;
