CREATE TABLE app (
    id varchar2(32 char) NOT NULL PRIMARY KEY,
    name varchar2(100 char) NOT NULL,
    is_core_app CHAR(1 CHAR) NOT NULL,
    default_order number(10) NOT NULL,
    ctime timestamp DEFAULT systimestamp NOT NULL,
    mtime timestamp DEFAULT systimestamp NOT NULL
);

CREATE TABLE additional_app_info (
    app_id varchar2(32 char) NOT NULL PRIMARY KEY,
    url varchar2(255 char) NOT NULL,
    icon_url varchar2(255 char),
    color varchar2(16 char) NOT NULL,
    is_iframe_app CHAR(1 CHAR) NOT NULL,
    ctime timestamp DEFAULT systimestamp NOT NULL,
    mtime timestamp DEFAULT systimestamp NOT NULL,
    CONSTRAINT additional_app_info_app_id_fk FOREIGN KEY (app_id) REFERENCES app(id) ON DELETE CASCADE
);

CREATE TABLE tenant_app_visibility (
    app_id varchar2(32 char) NOT NULL,
    tenant_id RAW(16) NOT NULL,
    visible_for_role varchar2(100 char) NOT NULL,
    visibility varchar2(64 char) NOT NULL,
    ctime timestamp DEFAULT systimestamp NOT NULL,
    mtime timestamp DEFAULT systimestamp NOT NULL,
    CONSTRAINT tenant_app_visibility_pk PRIMARY KEY (app_id, tenant_id, visible_for_role),
    CONSTRAINT tenant_app_visibility_fk FOREIGN KEY (app_id) REFERENCES app(id) ON DELETE CASCADE
);

CREATE TABLE default_app_visibility (
    app_id varchar2(32 char) NOT NULL,
    visible_for_role varchar2(100 char) NOT NULL,
    visibility varchar2(64 char) NOT NULL,
    ctime timestamp DEFAULT systimestamp NOT NULL,
    mtime timestamp DEFAULT systimestamp NOT NULL,
    CONSTRAINT default_app_visibility_pk PRIMARY KEY (app_id, visible_for_role),
    CONSTRAINT default_app_visibility_fk FOREIGN KEY (app_id) REFERENCES app(id) ON DELETE CASCADE
);

-- insert default core apps and orders
INSERT INTO app(id, name, is_core_app, default_order) VALUES('chat', 'Connect', 't', 1);
INSERT INTO app(id, name, is_core_app, default_order) VALUES('drive', 'Drive', 't', 2);
INSERT INTO app(id, name, is_core_app, default_order) VALUES('tasks', 'Tasks', 't', 3);
INSERT INTO app(id, name, is_core_app, default_order) VALUES('connect', 'Social', 't', 4);
INSERT INTO app(id, name, is_core_app, default_order) VALUES('people', 'People', 't', 5);
INSERT INTO app(id, name, is_core_app, default_order) VALUES('news', 'News', 't', 6);

INSERT INTO default_app_visibility(app_id, visible_for_role, visibility) SELECT id, 'ALL', 'FORCED' FROM app;

COMMIT;
