
-- missing oracle_identity_7.2.0.sql script
create table ACT_ID_GROUP (
    ID_ NVARCHAR2(64),
    REV_ INTEGER,
    NAME_ NVARCHAR2(255),
    TYPE_ NVARCHAR2(255),
    primary key (ID_)
);

create table ACT_ID_MEMBERSHIP (
    USER_ID_ NVARCHAR2(64),
    GROUP_ID_ NVARCHAR2(64),
    primary key (USER_ID_, GROUP_ID_)
);

create table ACT_ID_USER (
    ID_ NVARCHAR2(64),
    REV_ INTEGER,
    FIRST_ NVARCHAR2(255),
    LAST_ NVARCHAR2(255),
    EMAIL_ NVARCHAR2(255),
    PWD_ NVARCHAR2(255),
    PICTURE_ID_ NVARCHAR2(64),
    primary key (ID_)
);

create table ACT_ID_INFO (
    ID_ NVARCHAR2(64),
    REV_ INTEGER,
    USER_ID_ NVARCHAR2(64),
    TYPE_ NVARCHAR2(64),
    KEY_ NVARCHAR2(255),
    VALUE_ NVARCHAR2(255),
    PASSWORD_ BLOB,
    PARENT_ID_ NVARCHAR2(255),
    primary key (ID_)
);

create index ACT_IDX_MEMB_GROUP on ACT_ID_MEMBERSHIP(GROUP_ID_);
alter table ACT_ID_MEMBERSHIP 
    add constraint ACT_FK_MEMB_GROUP 
    foreign key (GROUP_ID_) 
    references ACT_ID_GROUP (ID_);

create index ACT_IDX_MEMB_USER on ACT_ID_MEMBERSHIP(USER_ID_);
alter table ACT_ID_MEMBERSHIP 
    add constraint ACT_FK_MEMB_USER
    foreign key (USER_ID_) 
    references ACT_ID_USER (ID_);



--- scripts are extracted from the follwing scripts contained in https://app.camunda.com/nexus/content/groups/public/org/camunda/bpm/distro/camunda-sql-scripts/7.5.0/camunda-sql-scripts-7.5.0.zip

-- oracle_engine_7.2_patch_7.2.6_to_7.2.7.sql
-- oracle_engine_7.2_to_7.3.sql
-- oracle_engine_7.3_patch_7.3.0_to_7.3.1.sql
-- oracle_engine_7.3_patch_7.3.2_to_7.3.3_1.sql
-- oracle_engine_7.3_patch_7.3.2_to_7.3.3_2.sql -> not included as the same as postgres_engine_7.2_patch_7.2.6_to_7.2.7.sql
-- oracle_engine_7.3_patch_7.3.5_to_7.3.6_1.sql
-- oracle_engine_7.3_patch_7.3.5_to_7.3.6_2.sql
-- oracle_engine_7.3_to_7.4.sql
-- oracle_engine_7.4_patch_7.4.2_to_7.4.3_1.sql
-- oracle_engine_7.4_patch_7.4.2_to_7.4.3_2.sql
-- oracle_engine_7.4_patch_7.4.2_to_7.4.3_3.sql -> same as postgres_engine_7.3_patch_7.3.5_to_7.3.6_2.sql
-- oracle_engine_7.4_patch_7.4.5_to_7.4.6.sql
-- oracle_engine_7.4_to_7.5.sql

-- oracle_engine_7.2_patch_7.2.6_to_7.2.7.sql
-- indexes to improve deployment
create index ACT_IDX_BYTEARRAY_NAME on ACT_GE_BYTEARRAY(NAME_);
create index ACT_IDX_DEPLOYMENT_NAME on ACT_RE_DEPLOYMENT(NAME_);
create index ACT_IDX_JOBDEF_PROC_DEF_ID ON ACT_RU_JOBDEF(PROC_DEF_ID_);
create index ACT_IDX_JOB_HANDLER_TYPE ON ACT_RU_JOB(HANDLER_TYPE_);
create index ACT_IDX_EVENT_SUBSCR_EVT_NAME ON ACT_RU_EVENT_SUBSCR(EVENT_NAME_);
create index ACT_IDX_PROCDEF_DEPLOYMENT_ID ON ACT_RE_PROCDEF(DEPLOYMENT_ID_);

-- oracle_engine_7.2_to_7.3.sql
-- case management --

ALTER TABLE ACT_RU_CASE_EXECUTION
  ADD SUPER_EXEC_ NVARCHAR2(64);

ALTER TABLE ACT_RU_CASE_EXECUTION
  ADD REQUIRED_ NUMBER(1,0) CHECK (REQUIRED_ IN (1,0));

-- history --

ALTER TABLE ACT_HI_ACTINST
  ADD CALL_CASE_INST_ID_ NVARCHAR2(64);

ALTER TABLE ACT_HI_PROCINST
  ADD SUPER_CASE_INSTANCE_ID_ NVARCHAR2(64);

ALTER TABLE ACT_HI_CASEINST
  ADD SUPER_PROCESS_INSTANCE_ID_ NVARCHAR2(64);

ALTER TABLE ACT_HI_CASEACTINST
  ADD REQUIRED_ NUMBER(1,0) CHECK (REQUIRED_ IN (1,0));

ALTER TABLE ACT_HI_OP_LOG
  ADD JOB_ID_ NVARCHAR2(64);

ALTER TABLE ACT_HI_OP_LOG
  ADD JOB_DEF_ID_ NVARCHAR2(64);


create table ACT_HI_JOB_LOG (
    ID_ NVARCHAR2(64) not null,
    TIMESTAMP_ TIMESTAMP(6) not null,
    JOB_ID_ NVARCHAR2(64) not null,
    JOB_DUEDATE_ TIMESTAMP(6),
    JOB_RETRIES_ INTEGER,
    JOB_EXCEPTION_MSG_ NVARCHAR2(2000),
    JOB_EXCEPTION_STACK_ID_ NVARCHAR2(64),
    JOB_STATE_ INTEGER,
    JOB_DEF_ID_ NVARCHAR2(64),
    JOB_DEF_TYPE_ NVARCHAR2(255),
    JOB_DEF_CONFIGURATION_ NVARCHAR2(255),
    ACT_ID_ NVARCHAR2(64),
    EXECUTION_ID_ NVARCHAR2(64),
    PROCESS_INSTANCE_ID_ NVARCHAR2(64),
    PROCESS_DEF_ID_ NVARCHAR2(64),
    PROCESS_DEF_KEY_ NVARCHAR2(255),
    DEPLOYMENT_ID_ NVARCHAR2(64),
    SEQUENCE_COUNTER_ NUMBER(19,0),
    primary key (ID_)
);

create index ACT_IDX_HI_JOB_LOG_PROCINST on ACT_HI_JOB_LOG(PROCESS_INSTANCE_ID_);
create index ACT_IDX_HI_JOB_LOG_PROCDEF on ACT_HI_JOB_LOG(PROCESS_DEF_ID_);

-- history: add columns PROC_DEF_KEY_, PROC_DEF_ID_, CASE_DEF_KEY_, CASE_DEF_ID_ --

ALTER TABLE ACT_HI_PROCINST
  ADD PROC_DEF_KEY_ NVARCHAR2(255);

ALTER TABLE ACT_HI_ACTINST
  ADD PROC_DEF_KEY_ NVARCHAR2(255);

ALTER TABLE ACT_HI_TASKINST
  ADD PROC_DEF_KEY_ NVARCHAR2(255);

ALTER TABLE ACT_HI_TASKINST
  ADD CASE_DEF_KEY_ NVARCHAR2(255);

ALTER TABLE ACT_HI_VARINST
  ADD PROC_DEF_KEY_ NVARCHAR2(255);

ALTER TABLE ACT_HI_VARINST
  ADD PROC_DEF_ID_ NVARCHAR2(64);

ALTER TABLE ACT_HI_VARINST
  ADD CASE_DEF_KEY_ NVARCHAR2(255);

ALTER TABLE ACT_HI_VARINST
  ADD CASE_DEF_ID_ NVARCHAR2(64);

ALTER TABLE ACT_HI_DETAIL
  ADD PROC_DEF_KEY_ NVARCHAR2(255);

ALTER TABLE ACT_HI_DETAIL
  ADD PROC_DEF_ID_ NVARCHAR2(64);

ALTER TABLE ACT_HI_DETAIL
  ADD CASE_DEF_KEY_ NVARCHAR2(255);

ALTER TABLE ACT_HI_DETAIL
  ADD CASE_DEF_ID_ NVARCHAR2(64);

ALTER TABLE ACT_HI_INCIDENT
  ADD PROC_DEF_KEY_ NVARCHAR2(255);

-- sequence counter

ALTER TABLE ACT_RU_EXECUTION
  ADD SEQUENCE_COUNTER_ NUMBER(19,0);

ALTER TABLE ACT_HI_ACTINST
  ADD SEQUENCE_COUNTER_ NUMBER(19,0);

ALTER TABLE ACT_RU_VARIABLE
  ADD SEQUENCE_COUNTER_ NUMBER(19,0);

ALTER TABLE ACT_HI_DETAIL
  ADD SEQUENCE_COUNTER_ NUMBER(19,0);

ALTER TABLE ACT_RU_JOB
  ADD SEQUENCE_COUNTER_ NUMBER(19,0);

-- unused columns
-- columns are not present in our schema -> no need to drop (cewers)
--ALTER TABLE ACT_RU_VARIABLE 
--  DROP COLUMN DATA_FORMAT_ID_;

--ALTER TABLE ACT_HI_VARINST
--  DROP COLUMN DATA_FORMAT_ID_;

--ALTER TABLE ACT_HI_DETAIL
--  DROP COLUMN DATA_FORMAT_ID_;

-- AUTHORIZATION --

-- add grant authorizations for group camunda-admin:
INSERT ALL
  INTO ACT_RU_AUTHORIZATION (ID_, TYPE_, GROUP_ID_, RESOURCE_TYPE_, RESOURCE_ID_, PERMS_, REV_) VALUES ('camunda-admin-grant-process-definition', 1, 'camunda-admin', 6, '*', 2147483647, 1)
  INTO ACT_RU_AUTHORIZATION (ID_, TYPE_, GROUP_ID_, RESOURCE_TYPE_, RESOURCE_ID_, PERMS_, REV_) VALUES ('camunda-admin-grant-task', 1, 'camunda-admin', 7, '*', 2147483647, 1)
  INTO ACT_RU_AUTHORIZATION (ID_, TYPE_, GROUP_ID_, RESOURCE_TYPE_, RESOURCE_ID_, PERMS_, REV_) VALUES ('camunda-admin-grant-process-instance', 1, 'camunda-admin', 8, '*', 2147483647, 1)
  INTO ACT_RU_AUTHORIZATION (ID_, TYPE_, GROUP_ID_, RESOURCE_TYPE_, RESOURCE_ID_, PERMS_, REV_) VALUES ('camunda-admin-grant-deployment', 1, 'camunda-admin', 9, '*', 2147483647, 1)
SELECT * FROM dual;

-- add global grant authorizations for new authorization resources:
-- DEPLOYMENT
-- PROCESS_DEFINITION
-- PROCESS_INSTANCE
-- TASK
-- with ALL permissions

INSERT ALL
  INTO ACT_RU_AUTHORIZATION (ID_, TYPE_, USER_ID_, RESOURCE_TYPE_, RESOURCE_ID_, PERMS_, REV_) VALUES ('global-grant-process-definition', 0, '*', 6, '*', 2147483647, 1)
  INTO ACT_RU_AUTHORIZATION (ID_, TYPE_, USER_ID_, RESOURCE_TYPE_, RESOURCE_ID_, PERMS_, REV_) VALUES ('global-grant-task', 0, '*', 7, '*', 2147483647, 1)
  INTO ACT_RU_AUTHORIZATION (ID_, TYPE_, USER_ID_, RESOURCE_TYPE_, RESOURCE_ID_, PERMS_, REV_) VALUES ('global-grant-process-instance', 0, '*', 8, '*', 2147483647, 1)
  INTO ACT_RU_AUTHORIZATION (ID_, TYPE_, USER_ID_, RESOURCE_TYPE_, RESOURCE_ID_, PERMS_, REV_) VALUES ('global-grant-deployment', 0, '*', 9, '*', 2147483647, 1)
SELECT * FROM dual;

-- variables --

ALTER TABLE ACT_RU_VARIABLE
  ADD IS_CONCURRENT_LOCAL_ NUMBER(1,0) CHECK (IS_CONCURRENT_LOCAL_ IN (1,0));

-- metrics --

create table ACT_RU_METER_LOG (
  ID_ NVARCHAR2(64) not null,
  NAME_ NVARCHAR2(64) not null,
  VALUE_ NUMBER(19,0),
  TIMESTAMP_ TIMESTAMP(6) not null,
  primary key (ID_)
);

create index ACT_IDX_METER_LOG on ACT_RU_METER_LOG(NAME_,TIMESTAMP_);

-- oracle_engine_7.3_patch_7.3.0_to_7.3.1.sql
alter table ACT_HI_JOB_LOG
  modify ACT_ID_ NVARCHAR2(255);
  
-- oracle_engine_7.3_patch_7.3.2_to_7.3.3_1.sql
-- index for deadlock problem - https://app.camunda.com/jira/browse/CAM-4440 --
create index ACT_IDX_AUTH_RESOURCE_ID on ACT_RU_AUTHORIZATION(RESOURCE_ID_);

-- oracle_engine_7.3_patch_7.3.2_to_7.3.3_2.sql -> not included as the same as postgres_engine_7.2_patch_7.2.6_to_7.2.7.sql

-- oracle_engine_7.3_patch_7.3.5_to_7.3.6_1.sql
-- INCREASE process def key column size https://app.camunda.com/jira/browse/CAM-4328 --
alter table ACT_RU_JOB
  modify PROCESS_DEF_KEY_ NVARCHAR2(255);
-- oracle_engine_7.3_patch_7.3.5_to_7.3.6_2.sql
-- https://app.camunda.com/jira/browse/CAM-5364 --
create index ACT_IDX_AUTH_GROUP_ID on ACT_RU_AUTHORIZATION(GROUP_ID_);

-- oracle_engine_7.3_to_7.4.sql
-- metrics --

ALTER TABLE ACT_RU_METER_LOG
  ADD REPORTER_ NVARCHAR2(255);

-- job prioritization --
  
ALTER TABLE ACT_RU_JOB
  ADD PRIORITY_ NUMBER(19,0) DEFAULT 0 NOT NULL;

ALTER TABLE ACT_RU_JOBDEF
  ADD JOB_PRIORITY_ NUMBER(19,0);
  
ALTER TABLE ACT_HI_JOB_LOG
  ADD JOB_PRIORITY_ NUMBER(19,0) DEFAULT 0 NOT NULL;

-- create decision definition table --
create table ACT_RE_DECISION_DEF (
    ID_ NVARCHAR2(64) NOT NULL,
    REV_ INTEGER,
    CATEGORY_ NVARCHAR2(255),
    NAME_ NVARCHAR2(255),
    KEY_ NVARCHAR2(255) NOT NULL,
    VERSION_ INTEGER NOT NULL,
    DEPLOYMENT_ID_ NVARCHAR2(64),
    RESOURCE_NAME_ NVARCHAR2(2000),
    DGRM_RESOURCE_NAME_ NVARCHAR2(2000),
    primary key (ID_)
);

-- create unique constraint on ACT_RE_DECISION_DEF --
alter table ACT_RE_DECISION_DEF
    add constraint ACT_UNIQ_DECISION_DEF
    unique (KEY_,VERSION_);

-- case sentry part source --

ALTER TABLE ACT_RU_CASE_SENTRY_PART
  ADD SOURCE_ NVARCHAR2(255);

-- create history decision instance table --
create table ACT_HI_DECINST (
    ID_ NVARCHAR2(64) NOT NULL,
    DEC_DEF_ID_ NVARCHAR2(64) NOT NULL,
    DEC_DEF_KEY_ NVARCHAR2(255) NOT NULL,
    DEC_DEF_NAME_ NVARCHAR2(255),
    PROC_DEF_KEY_ NVARCHAR2(255),
    PROC_DEF_ID_ NVARCHAR2(64),
    PROC_INST_ID_ NVARCHAR2(64),
    CASE_DEF_KEY_ NVARCHAR2(255),
    CASE_DEF_ID_ NVARCHAR2(64),
    CASE_INST_ID_ NVARCHAR2(64),
    ACT_INST_ID_ NVARCHAR2(64),
    ACT_ID_ NVARCHAR2(255),
    EVAL_TIME_ TIMESTAMP(6) not null,
    COLLECT_VALUE_ NUMBER(*,10),
    primary key (ID_)
);

-- create history decision input table --
create table ACT_HI_DEC_IN (
    ID_ NVARCHAR2(64) NOT NULL,
    DEC_INST_ID_ NVARCHAR2(64) NOT NULL,      
    CLAUSE_ID_ NVARCHAR2(64) NOT NULL,
    CLAUSE_NAME_ NVARCHAR2(255),
    VAR_TYPE_ NVARCHAR2(100),               
    BYTEARRAY_ID_ NVARCHAR2(64),
    DOUBLE_ NUMBER(*,10),
    LONG_ NUMBER(19,0),
    TEXT_ NVARCHAR2(2000),
    TEXT2_ NVARCHAR2(2000),    
    primary key (ID_)
);

-- create history decision output table --
create table ACT_HI_DEC_OUT (
    ID_ NVARCHAR2(64) NOT NULL,
    DEC_INST_ID_ NVARCHAR2(64) NOT NULL,         
    CLAUSE_ID_ NVARCHAR2(64) NOT NULL,
    CLAUSE_NAME_ NVARCHAR2(255),
    RULE_ID_ NVARCHAR2(64) NOT NULL,
    RULE_ORDER_ INTEGER,
    VAR_NAME_ NVARCHAR2(255),
    VAR_TYPE_ NVARCHAR2(100),               
    BYTEARRAY_ID_ NVARCHAR2(64),
    DOUBLE_ NUMBER(*,10),
    LONG_ NUMBER(19,0),
    TEXT_ NVARCHAR2(2000),
    TEXT2_ NVARCHAR2(2000),
    primary key (ID_)
);

-- create indexes for historic decision tables
create index ACT_IDX_HI_DEC_INST_ID on ACT_HI_DECINST(DEC_DEF_ID_);
create index ACT_IDX_HI_DEC_INST_KEY on ACT_HI_DECINST(DEC_DEF_KEY_);
create index ACT_IDX_HI_DEC_INST_PI on ACT_HI_DECINST(PROC_INST_ID_);
create index ACT_IDX_HI_DEC_INST_CI on ACT_HI_DECINST(CASE_INST_ID_);
create index ACT_IDX_HI_DEC_INST_ACT on ACT_HI_DECINST(ACT_ID_);
create index ACT_IDX_HI_DEC_INST_ACT_INST on ACT_HI_DECINST(ACT_INST_ID_);
create index ACT_IDX_HI_DEC_INST_TIME on ACT_HI_DECINST(EVAL_TIME_);

create index ACT_IDX_HI_DEC_IN_INST on ACT_HI_DEC_IN(DEC_INST_ID_);
create index ACT_IDX_HI_DEC_IN_CLAUSE on ACT_HI_DEC_IN(DEC_INST_ID_, CLAUSE_ID_);

create index ACT_IDX_HI_DEC_OUT_INST on ACT_HI_DEC_OUT(DEC_INST_ID_);
create index ACT_IDX_HI_DEC_OUT_RULE on ACT_HI_DEC_OUT(RULE_ORDER_, CLAUSE_ID_);

-- add grant authorization for group camunda-admin:
INSERT INTO ACT_RU_AUTHORIZATION (ID_, TYPE_, GROUP_ID_, RESOURCE_TYPE_, RESOURCE_ID_, PERMS_, REV_) 
  VALUES ('camunda-admin-grant-decision-definition', 1, 'camunda-admin', 10, '*', 2147483647, 1);

-- external tasks --

create table ACT_RU_EXT_TASK (
  ID_ NVARCHAR2(64) not null,
  REV_ integer not null,
  WORKER_ID_ NVARCHAR2(255),
  TOPIC_NAME_ NVARCHAR2(255),
  RETRIES_ INTEGER,
  ERROR_MSG_ NVARCHAR2(2000),
  LOCK_EXP_TIME_ TIMESTAMP(6),
  SUSPENSION_STATE_ integer,
  EXECUTION_ID_ NVARCHAR2(64),
  PROC_INST_ID_ NVARCHAR2(64),
  PROC_DEF_ID_ NVARCHAR2(64),
  PROC_DEF_KEY_ NVARCHAR2(255),
  ACT_ID_ NVARCHAR2(255),
  ACT_INST_ID_ NVARCHAR2(64),
  primary key (ID_)
);

alter table ACT_RU_EXT_TASK
  add constraint ACT_FK_EXT_TASK_EXE 
  foreign key (EXECUTION_ID_) 
  references ACT_RU_EXECUTION (ID_);
  
create index ACT_IDX_EXT_TASK_TOPIC on ACT_RU_EXT_TASK(TOPIC_NAME_);

-- deployment --

ALTER TABLE ACT_RE_DEPLOYMENT 
  ADD SOURCE_ NVARCHAR2(255);

ALTER TABLE ACT_HI_OP_LOG
  ADD DEPLOYMENT_ID_ NVARCHAR2(64);
  
-- job suspension state

ALTER TABLE ACT_RU_JOB
  MODIFY ( SUSPENSION_STATE_ DEFAULT 1 );

  -- relevant for jobs created in Camunda 7.0
UPDATE ACT_RU_JOB
  SET SUSPENSION_STATE_ = 1
  WHERE SUSPENSION_STATE_ IS NULL;
  
ALTER TABLE ACT_RU_JOB
  MODIFY ( SUSPENSION_STATE_ NOT NULL );

-- oracle_engine_7.4_patch_7.4.2_to_7.4.3_1.sql
-- index to improve historic activity instance query - https://app.camunda.com/jira/browse/CAM-5257 --
create index ACT_IDX_HI_ACT_INST_STATS on ACT_HI_ACTINST(PROC_DEF_ID_, ACT_ID_, END_TIME_, ACT_INST_STATE_);

-- oracle_engine_7.4_patch_7.4.2_to_7.4.3_2.sql
-- index to prevent deadlock on fk constraint - https://app.camunda.com/jira/browse/CAM-5440 --
create index ACT_IDX_EXT_TASK_EXEC on ACT_RU_EXT_TASK(EXECUTION_ID_);

-- oracle_engine_7.4_patch_7.4.2_to_7.4.3_3.sql -> same as postgres_engine_7.3_patch_7.3.5_to_7.3.6_2.sql

-- oracle_engine_7.4_patch_7.4.5_to_7.4.6.sql
-- INCREASE process def key column size https://app.camunda.com/jira/browse/CAM-4328 --
alter table ACT_RU_JOB
  modify PROCESS_DEF_KEY_ NVARCHAR2(255);

-- oracle_engine_7.4_to_7.5.sql
-- semantic version --

ALTER TABLE ACT_RE_PROCDEF
  ADD VERSION_TAG_ NVARCHAR2(64);

create index ACT_IDX_PROCDEF_VER_TAG on ACT_RE_PROCDEF(VERSION_TAG_);

-- AUTHORIZATION --

-- add grant authorizations for group camunda-admin:
INSERT ALL
  INTO ACT_RU_AUTHORIZATION (ID_, TYPE_, GROUP_ID_, RESOURCE_TYPE_, RESOURCE_ID_, PERMS_, REV_) VALUES ('camunda-admin-grant-tenant', 1, 'camunda-admin', 11, '*', 2147483647, 1)
  INTO ACT_RU_AUTHORIZATION (ID_, TYPE_, GROUP_ID_, RESOURCE_TYPE_, RESOURCE_ID_, PERMS_, REV_) VALUES ('camunda-admin-grant-tenant-membership', 1, 'camunda-admin', 12, '*', 2147483647, 1)
  INTO ACT_RU_AUTHORIZATION (ID_, TYPE_, GROUP_ID_, RESOURCE_TYPE_, RESOURCE_ID_, PERMS_, REV_) VALUES ('camunda-admin-grant-batch', 1, 'camunda-admin', 13, '*', 2147483647, 1)
SELECT * FROM dual;
  
-- tenant id --

ALTER TABLE ACT_RE_DEPLOYMENT
  ADD TENANT_ID_ NVARCHAR2(64);

create index ACT_IDX_DEPLOYMENT_TENANT_ID on ACT_RE_DEPLOYMENT(TENANT_ID_);

ALTER TABLE ACT_RE_PROCDEF
  ADD TENANT_ID_ NVARCHAR2(64);

ALTER TABLE ACT_RE_PROCDEF
  DROP CONSTRAINT ACT_UNIQ_PROCDEF;

create index ACT_IDX_PROCDEF_TENANT_ID ON ACT_RE_PROCDEF(TENANT_ID_);

ALTER TABLE ACT_RU_EXECUTION
  ADD TENANT_ID_ NVARCHAR2(64);

create index ACT_IDX_EXEC_TENANT_ID on ACT_RU_EXECUTION(TENANT_ID_);

ALTER TABLE ACT_RU_TASK
  ADD TENANT_ID_ NVARCHAR2(64);

create index ACT_IDX_TASK_TENANT_ID on ACT_RU_TASK(TENANT_ID_);

ALTER TABLE ACT_RU_VARIABLE
  ADD TENANT_ID_ NVARCHAR2(64);

create index ACT_IDX_VARIABLE_TENANT_ID on ACT_RU_VARIABLE(TENANT_ID_);

ALTER TABLE ACT_RU_EVENT_SUBSCR
  ADD TENANT_ID_ NVARCHAR2(64);

create index ACT_IDX_EVENT_SUBSCR_TENANT_ID on ACT_RU_EVENT_SUBSCR(TENANT_ID_);

ALTER TABLE ACT_RU_JOB
  ADD TENANT_ID_ NVARCHAR2(64);

create index ACT_IDX_JOB_TENANT_ID on ACT_RU_JOB(TENANT_ID_);

ALTER TABLE ACT_RU_JOBDEF
  ADD TENANT_ID_ NVARCHAR2(64);

create index ACT_IDX_JOBDEF_TENANT_ID on ACT_RU_JOBDEF(TENANT_ID_);

ALTER TABLE ACT_RU_INCIDENT
  ADD TENANT_ID_ NVARCHAR2(64);

ALTER TABLE ACT_RU_IDENTITYLINK
  ADD TENANT_ID_ NVARCHAR2(64);

create index ACT_IDX_INC_TENANT_ID on ACT_RU_INCIDENT(TENANT_ID_);

ALTER TABLE ACT_RU_EXT_TASK
  ADD TENANT_ID_ NVARCHAR2(64);

create index ACT_IDX_EXT_TASK_TENANT_ID on ACT_RU_EXT_TASK(TENANT_ID_);

ALTER TABLE ACT_RE_DECISION_DEF
       DROP CONSTRAINT ACT_UNIQ_DECISION_DEF;

ALTER TABLE ACT_RE_DECISION_DEF
  ADD TENANT_ID_ NVARCHAR2(64);

create index ACT_IDX_DEC_DEF_TENANT_ID on ACT_RE_DECISION_DEF(TENANT_ID_);

ALTER TABLE ACT_RE_CASE_DEF
       DROP CONSTRAINT ACT_UNIQ_CASE_DEF;

ALTER TABLE ACT_RE_CASE_DEF
  ADD TENANT_ID_ NVARCHAR2(64);

create index ACT_IDX_CASE_DEF_TENANT_ID on ACT_RE_CASE_DEF(TENANT_ID_);

ALTER TABLE ACT_GE_BYTEARRAY
  ADD TENANT_ID_ NVARCHAR2(64);

ALTER TABLE ACT_RU_CASE_EXECUTION
  ADD TENANT_ID_ NVARCHAR2(64);

create index ACT_IDX_CASE_EXEC_TENANT_ID on ACT_RU_CASE_EXECUTION(TENANT_ID_);

ALTER TABLE ACT_RU_CASE_SENTRY_PART
  ADD TENANT_ID_ NVARCHAR2(64);

-- user on historic decision instance --

ALTER TABLE ACT_HI_DECINST
  ADD USER_ID_ NVARCHAR2(255);

-- tenant id on history --

ALTER TABLE ACT_HI_PROCINST
  ADD TENANT_ID_ NVARCHAR2(64);

create index ACT_IDX_HI_PRO_INST_TENANT_ID on ACT_HI_PROCINST(TENANT_ID_);

ALTER TABLE ACT_HI_ACTINST
  ADD TENANT_ID_ NVARCHAR2(64);

create index ACT_IDX_HI_ACT_INST_TENANT_ID on ACT_HI_ACTINST(TENANT_ID_);

ALTER TABLE ACT_HI_TASKINST
  ADD TENANT_ID_ NVARCHAR2(64);

create index ACT_IDX_HI_TASK_INST_TENANT_ID on ACT_HI_TASKINST(TENANT_ID_);

ALTER TABLE ACT_HI_VARINST
  ADD TENANT_ID_ NVARCHAR2(64);

create index ACT_IDX_HI_VAR_INST_TENANT_ID on ACT_HI_VARINST(TENANT_ID_);

ALTER TABLE ACT_HI_DETAIL
  ADD TENANT_ID_ NVARCHAR2(64);

create index ACT_IDX_HI_DETAIL_TENANT_ID on ACT_HI_DETAIL(TENANT_ID_);

ALTER TABLE ACT_HI_INCIDENT
  ADD TENANT_ID_ NVARCHAR2(64);

create index ACT_IDX_HI_INCIDENT_TENANT_ID on ACT_HI_INCIDENT(TENANT_ID_);

ALTER TABLE ACT_HI_JOB_LOG
  ADD TENANT_ID_ NVARCHAR2(64);

create index ACT_IDX_HI_JOB_LOG_TENANT_ID on ACT_HI_JOB_LOG(TENANT_ID_);

ALTER TABLE ACT_HI_COMMENT
  ADD TENANT_ID_ NVARCHAR2(64);

ALTER TABLE ACT_HI_ATTACHMENT
  ADD TENANT_ID_ NVARCHAR2(64);

ALTER TABLE ACT_HI_OP_LOG
  ADD TENANT_ID_ NVARCHAR2(64);

ALTER TABLE ACT_HI_DEC_IN
  ADD TENANT_ID_ NVARCHAR2(64);

ALTER TABLE ACT_HI_DEC_OUT
  ADD TENANT_ID_ NVARCHAR2(64);

ALTER TABLE ACT_HI_DECINST
  ADD TENANT_ID_ NVARCHAR2(64);

create index ACT_IDX_HI_DEC_INST_TENANT_ID on ACT_HI_DECINST(TENANT_ID_);

ALTER TABLE ACT_HI_CASEINST
  ADD TENANT_ID_ NVARCHAR2(64);

create index ACT_IDX_HI_CAS_I_TENANT_ID on ACT_HI_CASEINST(TENANT_ID_);

ALTER TABLE ACT_HI_CASEACTINST
  ADD TENANT_ID_ NVARCHAR2(64);

create index ACT_IDX_HI_CAS_A_I_TENANT_ID on ACT_HI_CASEACTINST(TENANT_ID_);

-- add tenant table

create table ACT_ID_TENANT (
    ID_ NVARCHAR2(64),
    REV_ INTEGER,
    NAME_ NVARCHAR2(255),
    primary key (ID_)
);

create table ACT_ID_TENANT_MEMBER (
    ID_ NVARCHAR2(64) not null,
    TENANT_ID_ NVARCHAR2(64) not null,
    USER_ID_ NVARCHAR2(64),
    GROUP_ID_ NVARCHAR2(64),
    primary key (ID_)
);

create index ACT_IDX_TENANT_MEMB on ACT_ID_TENANT_MEMBER(TENANT_ID_);
alter table ACT_ID_TENANT_MEMBER
    add constraint ACT_FK_TENANT_MEMB
    foreign key (TENANT_ID_)
    references ACT_ID_TENANT (ID_);  

create index ACT_IDX_TENANT_MEMB_USER on ACT_ID_TENANT_MEMBER(USER_ID_);    
alter table ACT_ID_TENANT_MEMBER
    add constraint ACT_FK_TENANT_MEMB_USER
    foreign key (USER_ID_)
    references ACT_ID_USER (ID_);    
    
create index ACT_IDX_TENANT_MEMB_GROUP on ACT_ID_TENANT_MEMBER(GROUP_ID_);      
alter table ACT_ID_TENANT_MEMBER
    add constraint ACT_FK_TENANT_MEMB_GROUP
    foreign key (GROUP_ID_)
    references ACT_ID_GROUP (ID_);    
    
create unique index ACT_UNIQ_TENANT_MEMB_USER on ACT_ID_TENANT_MEMBER
   (case when USER_ID_ is null then null else TENANT_ID_ end,
    case when USER_ID_ is null then null else USER_ID_ end); 
    
create unique index ACT_UNIQ_TENANT_MEMB_GROUP on ACT_ID_TENANT_MEMBER
   (case when GROUP_ID_ is null then null else TENANT_ID_ end,
    case when GROUP_ID_ is null then null else GROUP_ID_ end);

--- BATCH ---

-- remove not null from job definition table --
alter table ACT_RU_JOBDEF
    modify (
        PROC_DEF_ID_ null,
        PROC_DEF_KEY_ null,
        ACT_ID_ null
    );

create table ACT_RU_BATCH (
  ID_ NVARCHAR2(64) NOT NULL,
  REV_ INTEGER NOT NULL,
  TYPE_ NVARCHAR2(255),
  TOTAL_JOBS_ INTEGER,
  JOBS_CREATED_ INTEGER,
  JOBS_PER_SEED_ INTEGER,
  INVOCATIONS_PER_JOB_ INTEGER,
  SEED_JOB_DEF_ID_ NVARCHAR2(64),
  BATCH_JOB_DEF_ID_ NVARCHAR2(64),
  MONITOR_JOB_DEF_ID_ NVARCHAR2(64),
  SUSPENSION_STATE_ INTEGER,
  CONFIGURATION_ NVARCHAR2(255),
  TENANT_ID_ NVARCHAR2(64),
  primary key (ID_)
);

create table ACT_HI_BATCH (
    ID_ NVARCHAR2(64) not null,
    TYPE_ NVARCHAR2(255),
    TOTAL_JOBS_ INTEGER,
    JOBS_PER_SEED_ INTEGER,
    INVOCATIONS_PER_JOB_ INTEGER,
    SEED_JOB_DEF_ID_ NVARCHAR2(64),
    MONITOR_JOB_DEF_ID_ NVARCHAR2(64),
    BATCH_JOB_DEF_ID_ NVARCHAR2(64),
    TENANT_ID_  NVARCHAR2(64),
    START_TIME_ TIMESTAMP(6) NOT NULL,
    END_TIME_ TIMESTAMP(6),
    primary key (ID_)
);

create table ACT_HI_IDENTITYLINK (
    ID_ NVARCHAR2(64) not null,
    TIMESTAMP_ TIMESTAMP(6) not null,
    TYPE_ NVARCHAR2(255),
    USER_ID_ NVARCHAR2(255),
    GROUP_ID_ NVARCHAR2(255),
    TASK_ID_ NVARCHAR2(64),
    PROC_DEF_ID_ NVARCHAR2(64),
    OPERATION_TYPE_ NVARCHAR2(64),
    ASSIGNER_ID_ NVARCHAR2(64),
    PROC_DEF_KEY_ NVARCHAR2(255),
    TENANT_ID_ NVARCHAR2(64),
    primary key (ID_)
);

create index ACT_IDX_HI_IDENT_LNK_USER on ACT_HI_IDENTITYLINK(USER_ID_);
create index ACT_IDX_HI_IDENT_LNK_GROUP on ACT_HI_IDENTITYLINK(GROUP_ID_);
create index ACT_IDX_HI_IDENT_LNK_TENANT_ID on ACT_HI_IDENTITYLINK(TENANT_ID_);

create index ACT_IDX_JOB_JOB_DEF_ID on ACT_RU_JOB(JOB_DEF_ID_);
create index ACT_IDX_HI_JOB_LOG_JOB_DEF_ID on ACT_HI_JOB_LOG(JOB_DEF_ID_);

create index ACT_IDX_BATCH_SEED_JOB_DEF ON ACT_RU_BATCH(SEED_JOB_DEF_ID_);
alter table ACT_RU_BATCH
    add constraint ACT_FK_BATCH_SEED_JOB_DEF
    foreign key (SEED_JOB_DEF_ID_)
    references ACT_RU_JOBDEF (ID_);

create index ACT_IDX_BATCH_MONITOR_JOB_DEF ON ACT_RU_BATCH(MONITOR_JOB_DEF_ID_);
alter table ACT_RU_BATCH
    add constraint ACT_FK_BATCH_MONITOR_JOB_DEF
    foreign key (MONITOR_JOB_DEF_ID_)
    references ACT_RU_JOBDEF (ID_);

create index ACT_IDX_BATCH_JOB_DEF ON ACT_RU_BATCH(BATCH_JOB_DEF_ID_);
alter table ACT_RU_BATCH
    add constraint ACT_FK_BATCH_JOB_DEF
    foreign key (BATCH_JOB_DEF_ID_)
    references ACT_RU_JOBDEF (ID_);

-- TASK PRIORITY --

ALTER TABLE ACT_RU_EXT_TASK
  ADD PRIORITY_ NUMBER(19,0) DEFAULT 0 NOT NULL;
    
create index ACT_IDX_EXT_TASK_PRIORITY ON ACT_RU_EXT_TASK(PRIORITY_);

-- HI OP PROC INDECIES --

create index ACT_IDX_HI_OP_LOG_PROCINST on ACT_HI_OP_LOG(PROC_INST_ID_);
create index ACT_IDX_HI_OP_LOG_PROCDEF on ACT_HI_OP_LOG(PROC_DEF_ID_);

-- JOB_DEF_ID_ on INCIDENTS --
ALTER TABLE ACT_RU_INCIDENT
  ADD JOB_DEF_ID_ NVARCHAR2(64);

create index ACT_IDX_INC_JOB_DEF on ACT_RU_INCIDENT(JOB_DEF_ID_);
alter table ACT_RU_INCIDENT
    add constraint ACT_FK_INC_JOB_DEF
    foreign key (JOB_DEF_ID_)
    references ACT_RU_JOBDEF (ID_);

ALTER TABLE ACT_HI_INCIDENT
  ADD JOB_DEF_ID_ NVARCHAR2(64);

-- BATCH_ID_ on ACT_HI_OP_LOG --
ALTER TABLE ACT_HI_OP_LOG
  ADD BATCH_ID_ NVARCHAR2(64);


COMMIT;
