CREATE SEQUENCE profile_cfg_section_seq
    MINVALUE 0
    START WITH 0
    INCREMENT BY 1
    NOCACHE;
    
CREATE SEQUENCE profile_cfg_section_attr_seq
    MINVALUE 0
    START WITH 0
    INCREMENT BY 1
    NOCACHE;

CREATE TABLE profile_cfg_section (
    id number(19) NOT NULL,
    type varchar2(255 char) NOT NULL,
    name varchar2(255 char) NOT NULL,
    order_index number(10) NOT NULL,
    create_date timestamp DEFAULT systimestamp NOT NULL,
    CONSTRAINT prfl_cfg_sec_pk PRIMARY KEY (id)
);

CREATE TABLE profile_cfg_section_attribute (
    id number(19) NOT NULL,
    section_id number(19) NOT NULL,
    type varchar2(255 char) NOT NULL,
    name varchar2(255 char) NOT NULL,
    order_index number(10) NOT NULL,
    create_date timestamp DEFAULT systimestamp NOT NULL,
    CONSTRAINT prfl_cfg_sec_attr_pk PRIMARY KEY (id),
    CONSTRAINT prfl_cfg_sec_attr_sec_fk FOREIGN KEY (section_id) REFERENCES profile_cfg_section (id) ON DELETE CASCADE
);

COMMIT;
