-- add additional constraint to entity_version_components for faster queries
ALTER TABLE entity_version_components ADD CONSTRAINT evc_mwv_uq UNIQUE(multi_wiki_version_id);
-- add index to entity_version_entity_id for faster access
CREATE INDEX entity_version_entity_id_index ON entity_version (entity_id);


-- insert entity_versions for currently unversioned entities.
INSERT INTO entity_version (id,entity_id, person_id,entity_status_id, version_status, major_version, minor_version, draft_version,version_type)

SELECT entity_version_seq.nextval, entity_id, person_id,  status_id, version_status, major_version, minor_version, draft_version,version_type from
(
    SELECT v.id, e.id as entity_id, COALESCE(emr.person_id,-1) as person_id, s.id as status_id, s.status_name as version_status ,0 AS major_version, 0 AS minor_version,1 AS draft_version,'MINOR' as version_type
    FROM entity e LEFT JOIN entity_version v ON e.id=v.entity_id 
    INNER JOIN entity_status s ON s.default_status='t' AND s.entity_type=e.entity_type
    LEFT JOIN entity_member_role emr ON e.id = emr.entity_id AND role='ADMIN'
    WHERE v.id IS NULL
);

-- attach the newest multi-wiki-versions to the newly created entity_versions


INSERT INTO entity_version_components (multi_wiki_version_id, entity_version_id)

select MAX(mwv.id) AS multi_wiki_version_id,MAX(ev.id) AS entity_version_id 
FROM multi_wiki_version mwv 
INNER JOIN multi_wiki mw ON mw.id=mwv.wiki_id
INNER JOIN entity_version ev ON mw.entity_id=ev.entity_id
LEFT JOIN entity_version_components evc ON evc.multi_wiki_version_id=mwv.id OR evc.entity_version_id=ev.id
WHERE evc.entity_version_id IS NULL
GROUP BY mw.entity_id;

COMMIT;

