-- add new column to rolenames, roles and roles shadow table
ALTER TABLE entity_member_role_name ADD workflow varchar2(16);

UPDATE entity_member_role_name
SET   workflow = 'ADMINISTRATION'
WHERE name = 'ADMIN'
OR    name = 'CO_ADMIN';

UPDATE entity_member_role_name
SET   workflow = 'MEMBERSHIP'
WHERE name = 'MEMBER'
OR    name = 'HAS_REJECTED'
OR    name = 'HAS_SENT_JOINREQUEST'
OR    name = 'HAS_INVITATION'
OR    name = 'IS_UNDECIDED';

UPDATE entity_member_role_name
SET   workflow = 'EVENT'
WHERE name = 'EVENT_IS_INVITED'
OR    name = 'EVENT_IS_ATTENDING'
OR    name = 'EVENT_IS_NOT_ATTENDING'
OR    name = 'EVENT_IS_MAYBE_ATTENDING'
OR    name = 'EVENT_IS_ON_WAITINGLIST'
OR    name = 'EVENT_HAS_REJECTED_INVITATION';

-- set default workflow bindings
ALTER TABLE entity_member_role      ADD workflow varchar2(16);
UPDATE entity_member_role
SET workflow = (
        SELECT workflow
        FROM entity_member_role_name
        WHERE entity_member_role_name.name = entity_member_role.role
);

ALTER TABLE sh_entity_member_role   ADD workflow varchar2(16);
UPDATE sh_entity_member_role
SET workflow = (
        SELECT workflow
        FROM entity_member_role_name
        WHERE entity_member_role_name.name = sh_entity_member_role.role
);


-- make workflow mandatory
ALTER TABLE entity_member_role_name MODIFY workflow NOT NULL;
ALTER TABLE entity_member_role_name ADD CONSTRAINT e_m_r_n_workflow_uq UNIQUE (name, workflow);

ALTER TABLE entity_member_role      MODIFY workflow NOT NULL;

-- drop constraints and recreate them
ALTER TABLE entity_member_role DROP CONSTRAINT e_m_pk;
ALTER TABLE entity_member_role ADD  CONSTRAINT e_m_r_pk PRIMARY KEY (entity_id, person_id, role);

ALTER TABLE entity_member_role DROP CONSTRAINT e_m_role_fk;
ALTER TABLE entity_member_role ADD  CONSTRAINT e_m_r_role_fk FOREIGN KEY (role, workflow) REFERENCES entity_member_role_name (name, workflow);

-- make sure only a single role for each workflow remains:

-- invited requesting a join get assigned the member role
UPDATE entity_member_role
SET role = 'MEMBER'
WHERE
    role = 'HAS_INVITATION'
AND (entity_id, person_id) IN (
    SELECT emr.entity_id, emr.person_id
    FROM entity_member_role emr
    WHERE emr.role = 'HAS_SENT_JOINREQUEST'
);

-- remove all membership roles, if member role is assigned
DELETE FROM entity_member_role
WHERE (entity_id, person_id) IN (
    SELECT emr.entity_id, emr.person_id
    FROM entity_member_role emr
    WHERE emr.role = 'MEMBER'
)
AND role in ('HAS_INVITATION', 'HAS_SENT_JOINREQUEST', 'HAS_REJECTED', 'IS_UNDECIDED');

-- assume all those having both rejected and undecided, are in fact just undecided
DELETE FROM entity_member_role
WHERE (entity_id, person_id) IN (
   SELECT emr.entity_id, emr.person_id
    FROM entity_member_role emr
    WHERE emr.role = 'IS_UNDECIDED'
)
AND role in ('HAS_REJECTED');

-- remove all co-admins that are also admins, because those are just the same
DELETE FROM entity_member_role
WHERE (entity_id, person_id) IN (
  SELECT emr.entity_id, emr.person_id
    FROM entity_member_role emr
    WHERE emr.role = 'ADMIN'
)
AND role in ('CO_ADMIN');

-- finally make all those cleanups obsolete by introducing a constraint:
ALTER TABLE entity_member_role ADD CONSTRAINT e_m_r_workflow_uq UNIQUE (entity_id, person_id, workflow);

-- done
COMMIT;
