ALTER TABLE entity_member_role_name 
MODIFY name VARCHAR2(50);

ALTER TABLE entity_member_role 
MODIFY role VARCHAR2(50);

UPDATE entity_member_role_name SET name = 'EVENT_REJECTED_INVITATION' WHERE name = 'E_HAS_REJECTED';
UPDATE entity_member_role_name SET name = 'EVENT_ATTEND' WHERE name = 'E_ATTEND';
UPDATE entity_member_role_name SET name = 'EVENT_DONT_ATTEND' WHERE name = 'E_DONT_ATTEND';
UPDATE entity_member_role_name SET name = 'EVENT_MAYBE_ATTEND' WHERE name = 'E_MAYBE_ATTEND';
UPDATE entity_member_role_name SET name = 'EVENT_ON_WAITINGLIST' WHERE name = 'E_ON_WAITINGLIST';
UPDATE entity_member_role_name SET name = 'EVENT_IS_INVITED' WHERE name = 'E_IS_INVITED';

CREATE SEQUENCE entity_waitlist_order_seq
    START WITH 1
    MINVALUE 1
    INCREMENT BY 1
    NOCACHE
    NOCYCLE;

CREATE TABLE entity_waitlist (
    entity_id number(19) NOT NULL,
    person_id number(19) NOT NULL,
    waitlist_order number(19) NOT NULL,
    CONSTRAINT entity_waitlist_pk PRIMARY KEY (entity_id, person_id),
    CONSTRAINT entity_waitlist_entity_fk FOREIGN KEY (entity_id) REFERENCES entity(id) ON DELETE CASCADE,
    CONSTRAINT entity_waitlist_person_fk FOREIGN KEY (person_id) REFERENCES person(id) ON DELETE CASCADE
);

CREATE TABLE SH_ENTITY_WAITLIST (
    "ENTITY_ID" number(19, 0),
    "PERSON_ID" number(19, 0),
    "WAITLIST_ORDER" number(19, 0),
    DELETE_ACTION_ID number(19, 0),
    FOREIGN KEY (DELETE_ACTION_ID) REFERENCES DELETE_ACTION (ID)
);

INSERT INTO SHADOW_TABLE (TABLE_NAME,SHADOW_TABLE_NAME,DELETE_ACTION_MANDATORY) VALUES ('ENTITY_WAITLIST','SH_ENTITY_WAITLIST','f');

COMMIT;
