
CREATE SEQUENCE theme_seq
    START WITH 0
    MINVALUE 0
    INCREMENT BY 1
    NOCACHE
    NOCYCLE;
    
CREATE TABLE theme (
    id number(19) NOT NULL,
    name varchar2(255) NULL,
    shared char(1) DEFAULT ('f') NOT NULL,
    default_theme char(1) DEFAULT ('f') NOT NULL,
    create_date timestamp DEFAULT systimestamp NOT NULL,
    modify_date timestamp DEFAULT systimestamp,
    CONSTRAINT theme_pk PRIMARY KEY (id)
);


CREATE TABLE theme_attribute (
   theme_id number(19) NOT NULL,
   entity_type VARCHAR2(255 CHAR) NULL,
   attribute_type VARCHAR2(255 CHAR) NOT NULL,
   attribute_value VARCHAR2(255 CHAR) NULL,
   CONSTRAINT theme_element_pkey UNIQUE(theme_id, entity_type, attribute_type),
   CONSTRAINT theme_element_theme_fk FOREIGN KEY (theme_id) REFERENCES theme(id) ON DELETE CASCADE,
   CONSTRAINT theme_velement_type_fk FOREIGN KEY (entity_type) REFERENCES entity_type_name(name) ON DELETE CASCADE
);


CREATE TABLE entity_theme (
    theme_id number(19) NOT NULL,
    entity_id number(19) NOT NULL,
    CONSTRAINT entity_theme_pk PRIMARY KEY (entity_id),
    CONSTRAINT entity_theme_theme_fk FOREIGN KEY (theme_id) REFERENCES theme(id) ON DELETE CASCADE,
    CONSTRAINT entity_theme_entity_id_fk FOREIGN KEY (entity_id) REFERENCES entity(id) ON DELETE CASCADE
);

COMMIT;
