INSERT INTO version (id, release, name, type, description, "date")
VALUES (00002, '8.0', '00002_#patch_startpage_tokens', 'FEATURE', '#9726 Bestimmung der Seiten, die für eingeloggte und nicht eingeloggte Nutzer beim Aufrufen der Domain angezeigt werden', now());

-- delete possible target property if it already exists, so the rename statement can run --
DELETE FROM base_property WHERE property_name = 'Settings/Startpage/startpage for logged in' AND container_name = 'systemSettings';
-- rename the property for logged in users if it exist --
UPDATE base_property SET property_name='Settings/Startpage/startpage for logged in' WHERE property_name = 'Settings/Startpage/page shown after login' AND container_name = 'systemSettings';

-- create a new property for not logged in users and fill it with migrated value, if it not exist and the migration source exist --
INSERT INTO base_property (id, property_name, converter_class, default_value, inheritance_type, container_name, last_changed, description)
SELECT seq_base_property.nextval, 'Settings/Startpage/startpage for not logged in', 'com.freiheit.superoperty.converter.SimpleStringConverter', '!entity.' || default_value , 'F', 'systemSettings', now(), '...'
 FROM base_property WHERE property_name = 'Settings/Default Entity Id' AND container_name = 'systemSettings' AND dbms_lob.substr(default_value, 20, 1 ) NOT IN ('-1','')
 AND NOT EXISTS (SELECT 1 FROM base_property WHERE property_name='Settings/Startpage/startpage for not logged in' AND container_name = 'systemSettings');

COMMIT;
