INSERT INTO version (id, release, name, type, description, "date")
VALUES (00003, '7.8', '00003_#patch_add_passive_subscription_to_own_profile', 'FEATURE', '#8188 Zwangsabo auf eigenes Profil', now());

-- even though there shouldn't be any profile subscriptions yet: if there are, make sure they are passive
update like_subscribe
set passive = 't'
where subscriber_id = item_id and item_type = 'PROFILE' and passive = 'f';

insert into like_subscribe(subscriber_id, item_id, item_type, passive)
select p.id, p.id, 'PROFILE', 't'
from person p
where p.deleted = 'f' and p.account_active = 't'
and not exists (
    select 1
    from like_subscribe
    where subscriber_id = p.id
    and item_id = p.id
    and item_type = 'PROFILE'
);

COMMIT;
