INSERT INTO version (id, release, name, type, description, "date")
VALUES (00002, '7.0', '00002_#patch_add_subnavigation_sequence.sql', 'BUFIX', '#5543 add missing sequence for sub-navigation', now());

-- generic max('pTableField') of table 'pTableName'
CREATE OR REPLACE FUNCTION max_id(pTableName VARCHAR2, pTableField VARCHAR2)
    RETURN NUMBER
AS
      vCursorId      INTEGER := 0;
      vDummy         INTEGER := 0;
      vResult        NUMBER  := 0;
BEGIN
    vCursorId := DBMS_SQL.OPEN_CURSOR;
    DBMS_SQL.PARSE(vCursorId, 'SELECT MAX(' || pTableField || ') FROM ' || pTableName, DBMS_SQL.Native);
    DBMS_SQL.DEFINE_COLUMN(vCursorId, 1, vResult);
    vDummy := DBMS_SQL.EXECUTE(vCursorId);
    IF DBMS_SQL.FETCH_ROWS(vCursorId) > 0 THEN
        DBMS_SQL.COLUMN_VALUE(vCursorId, 1, vResult);
    END IF;
    DBMS_SQL.CLOSE_CURSOR(vCursorId);

    RETURN vResult;
END;
/

-- same syntax as postgresql's nextval, although the existing function nextval (existing per table) can't be overidden
-- also parsing and compiling within this function is not very performant
CREATE OR REPLACE FUNCTION next_val(pSequenceName VARCHAR2)
    RETURN NUMBER
AS
      vCursorId      INTEGER := 0;
      vDummy         INTEGER := 0;
      vResult        NUMBER := 0;
BEGIN
    vCursorId := DBMS_SQL.OPEN_CURSOR;
    DBMS_SQL.PARSE(vCursorId, 'SELECT ' || pSequenceName || '.nextVal FROM DUAL', DBMS_SQL.Native);
    DBMS_SQL.DEFINE_COLUMN(vCursorId, 1, vResult);
    vDummy := DBMS_SQL.EXECUTE(vCursorId);
    IF DBMS_SQL.FETCH_ROWS(vCursorId) > 0 THEN
        DBMS_SQL.COLUMN_VALUE(vCursorId, 1, vResult);
    END IF;
    DBMS_SQL.CLOSE_CURSOR(vCursorId);
    
    RETURN vResult;
END;
/

-- create function to create sequence with parameter for start
CREATE OR REPLACE FUNCTION update_sequence (table_name varchar2, id_column varchar2, sequence_name varchar2)
    RETURN NUMBER
AS
    maxValue NUMBER;
    curValue NUMBER;
BEGIN
    maxValue := max_id(table_name, id_column);
    curValue := next_val(sequence_name);
    --increase sequence while there are still higher id's found in the table
    WHILE curValue < maxValue
    LOOP
       curValue := next_val(sequence_name);
    END LOOP;

    RETURN curValue;
END;
/

CREATE SEQUENCE entity_nav_sublink_seq
    START WITH 1
    INCREMENT BY 1
    MINVALUE 1
    NOCACHE
    NOCYCLE;

SELECT update_sequence('entity_nav_sublink', 'id', 'entity_nav_sublink_seq') FROM dual;

DROP FUNCTION update_sequence;
DROP FUNCTION next_val;
DROP FUNCTION max_id;

COMMIT;

