INSERT INTO version (id, release, name, type, description, "date")
VALUES (01294, '6.11', 'migrate_entity_type_name', 'FEATURE', 'creates a new table to sync entity type names', systimestamp);

CREATE TABLE entity_type_name (
    name varchar2(255 CHAR) NOT NULL,
    old_id number(8) NOT NULL,
    CONSTRAINT entity_type_name_pk PRIMARY KEY (name)
);

INSERT INTO entity_type_name VALUES ('NETWORK', 0);
INSERT INTO entity_type_name VALUES ('GROUP', 1);
INSERT INTO entity_type_name VALUES ('WIKI', 2);
INSERT INTO entity_type_name VALUES ('APPOINTMENT', 3);
INSERT INTO entity_type_name VALUES ('PUBLICATION', 4);
INSERT INTO entity_type_name VALUES ('TOPIC', 5);
INSERT INTO entity_type_name VALUES ('PARTNERSITE',6);
INSERT INTO entity_type_name VALUES ('ARTICLE', 7);

ALTER TABLE entity_category DROP CONSTRAINT e_cat__e_t__entity_t_fk;
ALTER TABLE entity_category DROP CONSTRAINT entity_category_pk;

ALTER TABLE entity_category RENAME COLUMN entity_type TO old_entity_type;
ALTER TABLE entity_category ADD entity_type varchar2(255 CHAR);

UPDATE entity_category SET entity_type = (SELECT name FROM entity_type_name etn WHERE old_id = old_entity_type);
ALTER TABLE entity_category DROP COLUMN old_entity_type;

ALTER TABLE entity_category MODIFY (entity_type NOT NULL);

ALTER TABLE entity_category ADD CONSTRAINT entity_category_pk PRIMARY KEY (entity_type, category);
ALTER TABLE entity_category ADD CONSTRAINT e_cat__e_t__entity_t_fk FOREIGN KEY (entity_type) REFERENCES entity_type_name (name);

ALTER TABLE entity RENAME COLUMN entity_type TO old_entity_type;
ALTER TABLE entity ADD entity_type varchar2(255 CHAR);

UPDATE entity SET entity_type = (SELECT name FROM entity_type_name etn WHERE old_id = old_entity_type);
ALTER TABLE entity MODIFY (entity_type NOT NULL);
ALTER TABLE entity DROP COLUMN old_entity_type;
ALTER TABLE entity ADD CONSTRAINT ent__e_t__name_fk FOREIGN KEY (entity_type) REFERENCES entity_type_name (name);

CREATE INDEX idx__ent__e_t ON entity (entity_type);

ALTER TABLE entity_to_entity_type_privacy MODIFY (entity_type varchar2(255 CHAR));
ALTER TABLE entity_to_entity_type_privacy ADD CONSTRAINT e_t_e_t_p__e_t__name_fk FOREIGN KEY (entity_type) REFERENCES entity_type_name (name);

ALTER TABLE entity_type_name DROP COLUMN old_id;

COMMIT;