/*
 * Decompiled with CFR 0.152.
 */
package thirdparty.org.apache.commons.dbutils;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Arrays;
import javax.sql.DataSource;
import thirdparty.org.apache.commons.dbutils.DbUtils;
import thirdparty.org.apache.commons.dbutils.ResultSetHandler;

public class QueryRunner {
    protected DataSource ds = null;

    public QueryRunner() {
    }

    public QueryRunner(DataSource ds) {
        this.setDataSource(ds);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int[] batch(Connection conn, String sql, Object[][] params) throws SQLException {
        PreparedStatement stmt = null;
        int[] rows = null;
        try {
            stmt = this.prepareStatement(conn, sql);
            for (int i = 0; i < params.length; ++i) {
                this.fillStatement(stmt, params[i]);
                stmt.addBatch();
            }
            rows = stmt.executeBatch();
        }
        catch (SQLException e) {
            this.rethrow(e, sql, (Object[])params);
        }
        finally {
            this.close(stmt);
        }
        return rows;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int[] batch(String sql, Object[][] params) throws SQLException {
        Connection conn = this.prepareConnection();
        try {
            int[] nArray = this.batch(conn, sql, params);
            return nArray;
        }
        finally {
            this.close(conn);
        }
    }

    protected void fillStatement(PreparedStatement stmt, Object[] params) throws SQLException {
        if (params == null) {
            return;
        }
        for (int i = 0; i < params.length; ++i) {
            if (params[i] != null) {
                stmt.setObject(i + 1, params[i]);
                continue;
            }
            stmt.setNull(i + 1, 12);
        }
    }

    public DataSource getDataSource() {
        return this.ds;
    }

    protected PreparedStatement prepareStatement(Connection conn, String sql) throws SQLException {
        return conn.prepareStatement(sql);
    }

    protected Connection prepareConnection() throws SQLException {
        if (this.getDataSource() == null) {
            throw new SQLException("QueryRunner requires a DataSource to be invoked in this way, or a Connection should be passed in");
        }
        return this.getDataSource().getConnection();
    }

    public Object query(Connection conn, String sql, Object param, ResultSetHandler rsh) throws SQLException {
        return this.query(conn, sql, new Object[]{param}, rsh);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public Object query(Connection conn, String sql, Object[] params, ResultSetHandler rsh) throws SQLException {
        PreparedStatement stmt = null;
        ResultSet rs = null;
        Object result = null;
        stmt = this.prepareStatement(conn, sql);
        this.fillStatement(stmt, params);
        rs = this.wrap(stmt.executeQuery());
        result = rsh.handle(rs);
        Object var10_8 = null;
        try {
            this.close(rs);
        }
        finally {
            this.close(stmt);
        }
        {
            catch (SQLException e) {
                this.rethrow(e, sql, params);
                Object var10_9 = null;
                try {
                    this.close(rs);
                }
                finally {
                    this.close(stmt);
                }
            }
        }
        catch (Throwable throwable) {
            Object var10_10 = null;
            try {
                this.close(rs);
            }
            finally {
                this.close(stmt);
            }
            throw throwable;
        }
        return result;
    }

    public Object query(Connection conn, String sql, ResultSetHandler rsh) throws SQLException {
        return this.query(conn, sql, null, rsh);
    }

    public Object query(String sql, Object param, ResultSetHandler rsh) throws SQLException {
        return this.query(sql, new Object[]{param}, rsh);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object query(String sql, Object[] params, ResultSetHandler rsh) throws SQLException {
        Connection conn = this.prepareConnection();
        try {
            Object object = this.query(conn, sql, params, rsh);
            return object;
        }
        finally {
            this.close(conn);
        }
    }

    public Object query(String sql, ResultSetHandler rsh) throws SQLException {
        return this.query(sql, (Object[])null, rsh);
    }

    protected void rethrow(SQLException cause, String sql, Object[] params) throws SQLException {
        StringBuffer msg = new StringBuffer(cause.getMessage());
        msg.append(" Query: ");
        msg.append(sql);
        msg.append(" Parameters: ");
        if (params == null) {
            msg.append("[]");
        } else {
            msg.append(Arrays.asList(params));
        }
        SQLException e = new SQLException(msg.toString(), cause.getSQLState(), cause.getErrorCode());
        e.setNextException(cause);
        throw e;
    }

    public void setDataSource(DataSource dataSource) {
        this.ds = dataSource;
    }

    public int update(Connection conn, String sql) throws SQLException {
        return this.update(conn, sql, null);
    }

    public int update(Connection conn, String sql, Object param) throws SQLException {
        return this.update(conn, sql, new Object[]{param});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int update(Connection conn, String sql, Object[] params) throws SQLException {
        PreparedStatement stmt = null;
        int rows = 0;
        try {
            stmt = this.prepareStatement(conn, sql);
            this.fillStatement(stmt, params);
            rows = stmt.executeUpdate();
        }
        catch (SQLException e) {
            this.rethrow(e, sql, params);
        }
        finally {
            this.close(stmt);
        }
        return rows;
    }

    public int update(String sql) throws SQLException {
        return this.update(sql, (Object[])null);
    }

    public int update(String sql, Object param) throws SQLException {
        return this.update(sql, new Object[]{param});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int update(String sql, Object[] params) throws SQLException {
        Connection conn = this.prepareConnection();
        try {
            int n = this.update(conn, sql, params);
            return n;
        }
        finally {
            this.close(conn);
        }
    }

    protected ResultSet wrap(ResultSet rs) {
        return rs;
    }

    protected void close(Connection conn) throws SQLException {
        DbUtils.close(conn);
    }

    protected void close(Statement stmt) throws SQLException {
        DbUtils.close(stmt);
    }

    protected void close(ResultSet rs) throws SQLException {
        DbUtils.close(rs);
    }
}

