/*
 * Decompiled with CFR 0.152.
 */
package org.dbmaintain.script.repository.impl;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.util.Collection;
import java.util.Enumeration;
import java.util.Properties;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.jar.JarOutputStream;
import java.util.zip.ZipEntry;
import org.dbmaintain.script.Script;
import org.dbmaintain.script.ScriptContentHandle;
import org.dbmaintain.script.executedscriptinfo.ScriptIndexes;
import org.dbmaintain.script.qualifier.Qualifier;
import org.dbmaintain.script.repository.ScriptLocation;
import org.dbmaintain.util.DbMaintainException;
import org.dbmaintain.util.ReaderInputStream;
import org.dbmaintain.util.WriterOutputStream;
import thirdparty.org.apache.commons.io.IOUtils;
import thirdparty.org.apache.commons.lang.StringUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ArchiveScriptLocation
extends ScriptLocation {
    public ArchiveScriptLocation(SortedSet<Script> scripts, String scriptEncoding, String postProcessingScriptDirName, Set<Qualifier> registeredQualifiers, Set<Qualifier> patchQualifiers, String scriptIndexRegexp, String qualifierRegexp, String targetDatabaseRegexp, Set<String> scriptFileExtensions, ScriptIndexes baseLineRevision, boolean ignoreCarriageReturnsWhenCalculatingCheckSum) {
        super(scripts, scriptEncoding, postProcessingScriptDirName, registeredQualifiers, patchQualifiers, scriptIndexRegexp, qualifierRegexp, targetDatabaseRegexp, scriptFileExtensions, baseLineRevision, ignoreCarriageReturnsWhenCalculatingCheckSum);
    }

    public ArchiveScriptLocation(File jarLocation, String defaultScriptEncoding, String defaultPostProcessingScriptDirName, Set<Qualifier> defaultRegisteredQualifiers, Set<Qualifier> defaultPatchQualifiers, String defaultScriptIndexRegexp, String defaultQualifierRegexp, String defaultTargetDatabaseRegexp, Set<String> defaultScriptFileExtensions, ScriptIndexes baseLineRevision, boolean ignoreCarriageReturnsWhenCalculatingCheckSum) {
        super(jarLocation, defaultScriptEncoding, defaultPostProcessingScriptDirName, defaultRegisteredQualifiers, defaultPatchQualifiers, defaultScriptIndexRegexp, defaultQualifierRegexp, defaultTargetDatabaseRegexp, defaultScriptFileExtensions, baseLineRevision, ignoreCarriageReturnsWhenCalculatingCheckSum);
    }

    @Override
    protected void assertValidScriptLocation(File jarFile) {
        File jarFileWithoutSubPath = this.getJarFileWithoutSubPath(jarFile);
        if (jarFileWithoutSubPath == null || !jarFileWithoutSubPath.exists()) {
            throw new DbMaintainException("Script jar " + jarFileWithoutSubPath + " does not exist.");
        }
    }

    @Override
    protected SortedSet<Script> loadScripts(File scriptLocation) {
        String subPath = this.getJarSubPath(scriptLocation);
        JarFile jarFile = this.createJarFile(scriptLocation);
        return this.loadScriptsFromJar(jarFile, subPath);
    }

    protected SortedSet<Script> loadScriptsFromJar(final JarFile jarFile, String subPath) {
        TreeSet<Script> scripts = new TreeSet<Script>();
        Enumeration<JarEntry> jarEntries = jarFile.entries();
        while (jarEntries.hasMoreElements()) {
            final JarEntry jarEntry = jarEntries.nextElement();
            String fileName = jarEntry.getName();
            if ("META-INF/dbmaintain.properties".equals(fileName) || !this.isScriptFileName(fileName)) continue;
            String relativeScriptName = jarEntry.getName();
            if (subPath != null) {
                if (!fileName.startsWith(subPath)) continue;
                relativeScriptName = relativeScriptName.substring(subPath.length());
            }
            ScriptContentHandle scriptContentHandle = new ScriptContentHandle(this.scriptEncoding, this.ignoreCarriageReturnsWhenCalculatingCheckSum){

                protected InputStream getScriptInputStream() {
                    try {
                        return jarFile.getInputStream(jarEntry);
                    }
                    catch (IOException e) {
                        throw new DbMaintainException("Error while reading jar entry " + jarEntry, e);
                    }
                }
            };
            Long fileLastModifiedAt = jarEntry.getTime();
            Script script = this.scriptFactory.createScriptWithContent(relativeScriptName, fileLastModifiedAt, scriptContentHandle);
            scripts.add(script);
        }
        return scripts;
    }

    protected String toQualifiersPropertyValue(Set<Qualifier> qualifiers) {
        StringBuilder propertyValue = new StringBuilder();
        String separator = "";
        for (Qualifier qualifier : qualifiers) {
            propertyValue.append(separator).append(qualifier.getQualifierName());
            separator = ",";
        }
        return propertyValue.toString();
    }

    @Override
    protected Properties getCustomProperties(File scriptLocation) {
        InputStream configurationInputStream = null;
        try {
            JarFile jarFile = this.createJarFile(scriptLocation);
            ZipEntry configurationEntry = jarFile.getEntry("META-INF/dbmaintain.properties");
            if (configurationEntry == null) {
                Properties properties = null;
                return properties;
            }
            Properties configuration = new Properties();
            configurationInputStream = jarFile.getInputStream(configurationEntry);
            configuration.load(configurationInputStream);
            Properties properties = configuration;
            IOUtils.closeQuietly(configurationInputStream);
            return properties;
        }
        catch (IOException e) {
            throw new DbMaintainException("Error while reading configuration file META-INF/dbmaintain.properties from jar file " + scriptLocation, e);
        }
        finally {
            IOUtils.closeQuietly(configurationInputStream);
        }
    }

    protected Reader getPropertiesAsFile(Properties properties) throws IOException {
        StringWriter propertiesFileWriter = new StringWriter();
        properties.store(new WriterOutputStream(propertiesFileWriter), null);
        return new StringReader(((Object)propertiesFileWriter).toString());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeToJarFile(File jarFile) {
        JarOutputStream jarOutputStream = null;
        try {
            jarOutputStream = new JarOutputStream(new FileOutputStream(jarFile));
            Reader propertiesAsFile = this.getPropertiesAsFile(this.getJarProperties());
            this.writeJarEntry(jarOutputStream, "META-INF/dbmaintain.properties", System.currentTimeMillis(), propertiesAsFile);
            propertiesAsFile.close();
            for (Script script : this.getScripts()) {
                Reader scriptContentReader = null;
                try {
                    scriptContentReader = script.getScriptContentHandle().openScriptContentReader();
                    this.writeJarEntry(jarOutputStream, script.getFileName(), script.getFileLastModifiedAt(), scriptContentReader);
                }
                finally {
                    IOUtils.closeQuietly(scriptContentReader);
                }
            }
        }
        catch (IOException e) {
            try {
                throw new DbMaintainException("Error while writing archive file " + jarFile, e);
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(jarOutputStream);
                throw throwable;
            }
        }
        IOUtils.closeQuietly(jarOutputStream);
    }

    protected Properties getJarProperties() {
        Properties configuration = new Properties();
        configuration.put("dbMaintainer.script.encoding", this.scriptEncoding);
        configuration.put("dbMaintainer.postProcessingScript.directoryName", this.postProcessingScriptDirName);
        configuration.put("dbMaintainer.qualifiers", this.toQualifiersPropertyValue(this.registeredQualifiers));
        configuration.put("dbMaintainer.script.patch.qualifiers", this.toQualifiersPropertyValue(this.patchQualifiers));
        configuration.put("dbMaintainer.script.index.regexp", this.scriptIndexRegexp);
        configuration.put("dbMaintainer.script.qualifier.regexp", this.qualifierRegexp);
        configuration.put("dbMaintainer.script.targetDatabase.regexp", this.targetDatabaseRegexp);
        configuration.put("dbMaintainer.script.fileExtensions", StringUtils.join((Collection)this.scriptFileExtensions, ","));
        if (this.baseLineRevision != null) {
            configuration.put("dbMaintainer.baseline.revision", this.baseLineRevision.getIndexesString());
        }
        configuration.put("dbMaintainer.script.ignoreCarriageReturnsWhenCalculatingCheckSum", Boolean.toString(this.ignoreCarriageReturnsWhenCalculatingCheckSum));
        return configuration;
    }

    protected void writeJarEntry(JarOutputStream jarOutputStream, String name, long timestamp, Reader entryContentReader) throws IOException {
        int len;
        JarEntry jarEntry = new JarEntry(name);
        jarEntry.setTime(timestamp);
        jarOutputStream.putNextEntry(jarEntry);
        ReaderInputStream scriptInputStream = new ReaderInputStream(entryContentReader);
        byte[] buffer = new byte[1024];
        while ((len = scriptInputStream.read(buffer, 0, buffer.length)) > -1) {
            jarOutputStream.write(buffer, 0, len);
        }
        scriptInputStream.close();
        jarOutputStream.closeEntry();
    }

    protected JarFile createJarFile(File jarFile) {
        try {
            File jarFileWithoutSubPath = this.getJarFileWithoutSubPath(jarFile);
            return new JarFile(jarFileWithoutSubPath);
        }
        catch (IOException e) {
            throw new DbMaintainException("Error opening jar file " + jarFile, e);
        }
    }

    protected String getJarSubPath(File jarFile) {
        String jarFilePath = jarFile.getPath();
        int index = jarFilePath.lastIndexOf(33);
        if (index < 0 || index + 1 == jarFilePath.length()) {
            return null;
        }
        String subPath = jarFilePath.substring(index + 1);
        if (!subPath.endsWith("/")) {
            subPath = subPath + "/";
        }
        return subPath;
    }

    protected File getJarFileWithoutSubPath(File jarFile) {
        String jarFilePath = jarFile.getPath();
        int index = jarFilePath.lastIndexOf(33);
        if (index < 0) {
            return jarFile;
        }
        return new File(jarFilePath.substring(0, index));
    }
}

