/*
 * Decompiled with CFR 0.152.
 */
package org.dbmaintain.script.executedscriptinfo.impl;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.text.DateFormat;
import java.text.ParseException;
import java.util.Date;
import java.util.Iterator;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import org.dbmaintain.database.Database;
import org.dbmaintain.database.SQLHandler;
import org.dbmaintain.script.ExecutedScript;
import org.dbmaintain.script.Script;
import org.dbmaintain.script.ScriptFactory;
import org.dbmaintain.script.executedscriptinfo.ExecutedScriptInfoSource;
import org.dbmaintain.util.DbMaintainException;
import thirdparty.org.apache.commons.dbutils.DbUtils;
import thirdparty.org.apache.commons.logging.Log;
import thirdparty.org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultExecutedScriptInfoSource
implements ExecutedScriptInfoSource {
    private static Log logger = LogFactory.getLog(DefaultExecutedScriptInfoSource.class);
    protected SortedSet<ExecutedScript> cachedExecutedScripts;
    protected Database defaultDatabase;
    protected SQLHandler sqlHandler;
    protected String executedScriptsTableName;
    protected String fileNameColumnName;
    protected int fileNameColumnSize;
    protected String fileLastModifiedAtColumnName;
    protected String checksumColumnName;
    protected int checksumColumnSize;
    protected String executedAtColumnName;
    protected int executedAtColumnSize;
    protected String succeededColumnName;
    protected boolean autoCreateExecutedScriptsTable;
    protected DateFormat timestampFormat;
    protected boolean validExecutedScriptsTable = false;
    protected ScriptFactory scriptFactory;

    public DefaultExecutedScriptInfoSource(boolean autoCreateExecutedScriptsTable, String executedScriptsTableName, String fileNameColumnName, int fileNameColumnSize, String fileLastModifiedAtColumnName, String checksumColumnName, int checksumColumnSize, String executedAtColumnName, int executedAtColumnSize, String succeededColumnName, DateFormat timestampFormat, Database defaultSupport, SQLHandler sqlHandler, ScriptFactory scriptFactory) {
        this.defaultDatabase = defaultSupport;
        this.sqlHandler = sqlHandler;
        this.autoCreateExecutedScriptsTable = autoCreateExecutedScriptsTable;
        this.executedScriptsTableName = this.defaultDatabase.toCorrectCaseIdentifier(executedScriptsTableName);
        this.fileNameColumnName = this.defaultDatabase.toCorrectCaseIdentifier(fileNameColumnName);
        this.fileNameColumnSize = fileNameColumnSize;
        this.fileLastModifiedAtColumnName = this.defaultDatabase.toCorrectCaseIdentifier(fileLastModifiedAtColumnName);
        this.checksumColumnName = this.defaultDatabase.toCorrectCaseIdentifier(checksumColumnName);
        this.checksumColumnSize = checksumColumnSize;
        this.executedAtColumnName = this.defaultDatabase.toCorrectCaseIdentifier(executedAtColumnName);
        this.executedAtColumnSize = executedAtColumnSize;
        this.succeededColumnName = this.defaultDatabase.toCorrectCaseIdentifier(succeededColumnName);
        this.timestampFormat = timestampFormat;
        this.scriptFactory = scriptFactory;
    }

    public SortedSet<ExecutedScript> getExecutedScripts() {
        if (this.cachedExecutedScripts != null) {
            return this.cachedExecutedScripts;
        }
        this.checkExecutedScriptsTable();
        this.cachedExecutedScripts = this.doGetExecutedScripts();
        return this.cachedExecutedScripts;
    }

    protected synchronized SortedSet<ExecutedScript> doGetExecutedScripts() {
        TreeSet<ExecutedScript> executedScripts = new TreeSet<ExecutedScript>();
        Connection connection = null;
        Statement statement = null;
        ResultSet resultSet = null;
        try {
            connection = this.defaultDatabase.getDataSource().getConnection();
            statement = connection.createStatement();
            resultSet = statement.executeQuery("select " + this.fileNameColumnName + ", " + this.fileLastModifiedAtColumnName + ", " + this.checksumColumnName + ", " + this.executedAtColumnName + ", " + this.succeededColumnName + " from " + this.getQualifiedExecutedScriptsTableName());
            while (resultSet.next()) {
                boolean succeeded;
                String fileName = resultSet.getString(this.fileNameColumnName);
                String checkSum = resultSet.getString(this.checksumColumnName);
                Long fileLastModifiedAt = resultSet.getLong(this.fileLastModifiedAtColumnName);
                Date executedAt = null;
                try {
                    String executedAtStr = resultSet.getString(this.executedAtColumnName);
                    if (executedAtStr != null) {
                        executedAt = this.timestampFormat.parse(executedAtStr);
                    }
                }
                catch (ParseException e) {
                    throw new DbMaintainException("Error when parsing date " + executedAt + " using format " + this.timestampFormat, e);
                }
                boolean bl = succeeded = resultSet.getInt(this.succeededColumnName) == 1;
                Script script = this.scriptFactory.createScriptWithoutContent(fileName, fileLastModifiedAt, checkSum);
                if (script.isIgnored()) continue;
                ExecutedScript executedScript = new ExecutedScript(script, executedAt, succeeded);
                executedScripts.add(executedScript);
            }
        }
        catch (SQLException e) {
            try {
                throw new DbMaintainException("Error while retrieving database version", e);
            }
            catch (Throwable throwable) {
                DbUtils.closeQuietly(connection, statement, resultSet);
                throw throwable;
            }
        }
        DbUtils.closeQuietly(connection, statement, resultSet);
        return executedScripts;
    }

    @Override
    public void registerExecutedScript(ExecutedScript executedScript) {
        this.checkExecutedScriptsTable();
        if (this.getExecutedScripts().contains(executedScript)) {
            this.updateExecutedScript(executedScript);
        } else {
            this.insertExecutedScript(executedScript);
        }
    }

    protected void insertExecutedScript(ExecutedScript executedScript) {
        this.getExecutedScripts().add(executedScript);
        String executedAt = this.timestampFormat.format(executedScript.getExecutedAt());
        String insertSql = "insert into " + this.getQualifiedExecutedScriptsTableName() + " (" + this.fileNameColumnName + ", " + this.fileLastModifiedAtColumnName + ", " + this.checksumColumnName + ", " + this.executedAtColumnName + ", " + this.succeededColumnName + ") values ('" + executedScript.getScript().getFileName() + "', " + executedScript.getScript().getFileLastModifiedAt() + ", '" + executedScript.getScript().getCheckSum() + "', '" + executedAt + "', " + (executedScript.isSuccessful() != false ? "1" : "0") + ")";
        this.sqlHandler.executeUpdateAndCommit(insertSql, this.defaultDatabase.getDataSource());
    }

    @Override
    public void updateExecutedScript(ExecutedScript executedScript) {
        this.checkExecutedScriptsTable();
        this.getExecutedScripts().add(executedScript);
        String executedAt = this.timestampFormat.format(executedScript.getExecutedAt());
        String updateSql = "update " + this.getQualifiedExecutedScriptsTableName() + " set " + this.checksumColumnName + " = '" + executedScript.getScript().getCheckSum() + "', " + this.fileLastModifiedAtColumnName + " = " + executedScript.getScript().getFileLastModifiedAt() + ", " + this.executedAtColumnName + " = '" + executedAt + "', " + this.succeededColumnName + " = " + (executedScript.isSuccessful() != false ? "1" : "0") + " where " + this.fileNameColumnName + " = '" + executedScript.getScript().getFileName() + "'";
        this.sqlHandler.executeUpdateAndCommit(updateSql, this.defaultDatabase.getDataSource());
    }

    @Override
    public void deleteExecutedScript(ExecutedScript executedScript) {
        this.checkExecutedScriptsTable();
        this.getExecutedScripts().remove(executedScript);
        String deleteSql = "delete from " + this.getQualifiedExecutedScriptsTableName() + " where " + this.fileNameColumnName + " = '" + executedScript.getScript().getFileName() + "'";
        this.sqlHandler.executeUpdateAndCommit(deleteSql, this.defaultDatabase.getDataSource());
    }

    @Override
    public void renameExecutedScript(ExecutedScript executedScript, Script renamedToScript) {
        this.checkExecutedScriptsTable();
        String renameSql = "update " + this.getQualifiedExecutedScriptsTableName() + " set " + this.fileNameColumnName + " = '" + renamedToScript.getFileName() + "', " + this.checksumColumnName + " = '" + renamedToScript.getCheckSum() + "', " + this.fileLastModifiedAtColumnName + " = " + renamedToScript.getFileLastModifiedAt() + " where " + this.fileNameColumnName + " = '" + executedScript.getScript().getFileName() + "'";
        this.sqlHandler.executeUpdateAndCommit(renameSql, this.defaultDatabase.getDataSource());
        executedScript.renameTo(renamedToScript);
    }

    @Override
    public void deleteAllExecutedPostprocessingScripts() {
        this.checkExecutedScriptsTable();
        Iterator executedScriptsIterator = this.getExecutedScripts().iterator();
        while (executedScriptsIterator.hasNext()) {
            ExecutedScript executedScript = (ExecutedScript)executedScriptsIterator.next();
            if (!executedScript.getScript().isPostProcessingScript()) continue;
            executedScriptsIterator.remove();
            String deleteSql = "delete from " + this.getQualifiedExecutedScriptsTableName() + " where " + this.fileNameColumnName + " = '" + executedScript.getScript().getFileName() + "'";
            this.sqlHandler.executeUpdateAndCommit(deleteSql, this.defaultDatabase.getDataSource());
        }
    }

    @Override
    public void clearAllExecutedScripts() {
        this.checkExecutedScriptsTable();
        String deleteSql = "delete from " + this.getQualifiedExecutedScriptsTableName();
        this.sqlHandler.executeUpdateAndCommit(deleteSql, this.defaultDatabase.getDataSource());
        this.resetCachedState();
    }

    @Override
    public void markErrorScriptsAsSuccessful() {
        this.checkExecutedScriptsTable();
        String deleteSql = "update " + this.getQualifiedExecutedScriptsTableName() + " set " + this.succeededColumnName + "=1 where " + this.succeededColumnName + "=0";
        this.sqlHandler.executeUpdateAndCommit(deleteSql, this.defaultDatabase.getDataSource());
        this.resetCachedState();
    }

    @Override
    public void removeErrorScripts() {
        this.checkExecutedScriptsTable();
        String deleteSql = "delete from " + this.getQualifiedExecutedScriptsTableName() + " where " + this.succeededColumnName + "=0";
        this.sqlHandler.executeUpdateAndCommit(deleteSql, this.defaultDatabase.getDataSource());
        this.resetCachedState();
    }

    protected boolean checkExecutedScriptsTable() {
        if (this.validExecutedScriptsTable) {
            return true;
        }
        if (this.isExecutedScriptsTableValid()) {
            this.validExecutedScriptsTable = true;
            return true;
        }
        if (this.autoCreateExecutedScriptsTable) {
            logger.warn("Executed scripts table " + this.getQualifiedExecutedScriptsTableName() + " doesn't exist yet or is invalid. A new one is created automatically.");
            this.createExecutedScriptsTable();
            return false;
        }
        String message = "Executed scripts table " + this.getQualifiedExecutedScriptsTableName() + " doesn't exist yet or is invalid.\n";
        message = message + "Please create it manually or let DbMaintain create it automatically by setting the property autoCreateDbMaintainScriptsTable to true.\n";
        message = message + "The table can be created manually by executing following statement:\n";
        message = message + this.getCreateExecutedScriptTableStatement();
        throw new DbMaintainException(message);
    }

    protected boolean isExecutedScriptsTableValid() {
        Set<String> columnNames;
        Set<String> tableNames = this.defaultDatabase.getTableNames(this.defaultDatabase.getDefaultSchemaName());
        return tableNames.contains(this.executedScriptsTableName) && (columnNames = this.defaultDatabase.getColumnNames(this.defaultDatabase.getDefaultSchemaName(), this.executedScriptsTableName)).contains(this.fileNameColumnName) && columnNames.contains(this.fileLastModifiedAtColumnName) && columnNames.contains(this.checksumColumnName) && columnNames.contains(this.executedAtColumnName) && columnNames.contains(this.succeededColumnName);
    }

    protected void createExecutedScriptsTable() {
        try {
            this.defaultDatabase.dropTable(this.defaultDatabase.getDefaultSchemaName(), this.executedScriptsTableName);
        }
        catch (DbMaintainException dbMaintainException) {
            // empty catch block
        }
        this.sqlHandler.executeUpdateAndCommit(this.getCreateExecutedScriptTableStatement(), this.defaultDatabase.getDataSource());
    }

    protected String getCreateExecutedScriptTableStatement() {
        String longDataType = this.defaultDatabase.getLongDataType();
        return "create table " + this.getQualifiedExecutedScriptsTableName() + " ( " + this.fileNameColumnName + " " + this.defaultDatabase.getTextDataType(this.fileNameColumnSize) + ", " + this.fileLastModifiedAtColumnName + " " + this.defaultDatabase.getLongDataType() + ", " + this.checksumColumnName + " " + this.defaultDatabase.getTextDataType(this.checksumColumnSize) + ", " + this.executedAtColumnName + " " + this.defaultDatabase.getTextDataType(this.executedAtColumnSize) + ", " + this.succeededColumnName + " " + longDataType + " )";
    }

    protected String getQualifiedExecutedScriptsTableName() {
        return this.defaultDatabase.qualified(this.defaultDatabase.getDefaultSchemaName(), this.executedScriptsTableName);
    }

    @Override
    public void resetCachedState() {
        this.cachedExecutedScripts = null;
    }
}

