/*
 * Decompiled with CFR 0.152.
 */
package org.dbmaintain.script.analyzer;

import java.util.SortedSet;
import org.dbmaintain.script.analyzer.ScriptUpdate;
import thirdparty.org.apache.commons.lang.StringUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ScriptUpdatesFormatter {
    public String formatScriptUpdates(SortedSet<ScriptUpdate> scriptUpdates) {
        StringBuilder formattedUpdates = new StringBuilder();
        int index = 0;
        for (ScriptUpdate scriptUpdate : scriptUpdates) {
            formattedUpdates.append("  ").append(++index).append(". ").append(StringUtils.capitalize(this.formatScriptUpdate(scriptUpdate))).append("\n");
        }
        return formattedUpdates.toString();
    }

    public String formatScriptUpdate(ScriptUpdate scriptUpdate) {
        switch (scriptUpdate.getType()) {
            case HIGHER_INDEX_SCRIPT_ADDED: {
                return "newly added indexed script: " + scriptUpdate.getScript().getFileName();
            }
            case REPEATABLE_SCRIPT_ADDED: {
                return "newly added repeatable script: " + scriptUpdate.getScript().getFileName();
            }
            case REPEATABLE_SCRIPT_UPDATED: {
                return "updated repeatable script: " + scriptUpdate.getScript().getFileName();
            }
            case REPEATABLE_SCRIPT_DELETED: {
                return "deleted repeatable script: " + scriptUpdate.getScript().getFileName();
            }
            case POSTPROCESSING_SCRIPT_ADDED: {
                return "newly added postprocessing script: " + scriptUpdate.getScript().getFileName();
            }
            case POSTPROCESSING_SCRIPT_UPDATED: {
                return "updated postprocessing script: " + scriptUpdate.getScript().getFileName();
            }
            case POSTPROCESSING_SCRIPT_DELETED: {
                return "deleted postprocessing script: " + scriptUpdate.getScript().getFileName();
            }
            case POSTPROCESSING_SCRIPT_FAILURE_RERUN: {
                return "re-run of failed postprocessing script: " + scriptUpdate.getScript().getFileName();
            }
            case INDEXED_SCRIPT_UPDATED: {
                return "updated indexed script: " + scriptUpdate.getScript().getFileName();
            }
            case INDEXED_SCRIPT_DELETED: {
                return "deleted indexed script: " + scriptUpdate.getScript().getFileName();
            }
            case LOWER_INDEX_NON_PATCH_SCRIPT_ADDED: {
                return "newly added script with a lower index: " + scriptUpdate.getScript().getFileName();
            }
            case LOWER_INDEX_PATCH_SCRIPT_ADDED: {
                return "newly added patch script with a lower index: " + scriptUpdate.getScript().getFileName();
            }
            case INDEXED_SCRIPT_RENAMED: {
                return "renamed indexed script " + scriptUpdate.getScript() + " into " + scriptUpdate.getRenamedToScript() + ", without changing the sequence of the scripts";
            }
            case INDEXED_SCRIPT_RENAMED_SCRIPT_SEQUENCE_CHANGED: {
                return "renamed indexed script " + scriptUpdate.getScript() + " into " + scriptUpdate.getRenamedToScript() + ", which changes the sequence of the scripts";
            }
            case REPEATABLE_SCRIPT_RENAMED: {
                return "renamed repeatable script " + scriptUpdate.getScript() + " into " + scriptUpdate.getRenamedToScript();
            }
            case POSTPROCESSING_SCRIPT_RENAMED: {
                return "renamed postprocessing script " + scriptUpdate.getScript() + " into " + scriptUpdate.getRenamedToScript();
            }
        }
        throw new IllegalArgumentException("Invalid script update type " + (Object)((Object)scriptUpdate.getType()));
    }
}

