/*
 * Decompiled with CFR 0.152.
 */
package org.dbmaintain.database.impl;

import java.util.HashSet;
import java.util.Set;
import org.dbmaintain.database.Database;
import org.dbmaintain.database.DatabaseConnection;
import org.dbmaintain.database.IdentifierProcessor;
import org.dbmaintain.database.SQLHandler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PostgreSqlDatabase
extends Database {
    public PostgreSqlDatabase(DatabaseConnection databaseConnection, IdentifierProcessor identifierProcessor) {
        super(databaseConnection, identifierProcessor);
    }

    @Override
    public String getSupportedDatabaseDialect() {
        return "postgresql";
    }

    @Override
    public Set<String> getTableNames(String schemaName) {
        return this.getSQLHandler().getItemsAsStringSet("select table_name from information_schema.tables where table_type = 'BASE TABLE' and table_schema = '" + schemaName + "'", this.getDataSource());
    }

    @Override
    public Set<String> getColumnNames(String schemaName, String tableName) {
        return this.getSQLHandler().getItemsAsStringSet("select column_name from information_schema.columns where table_name = '" + tableName + "' and table_schema = '" + schemaName + "'", this.getDataSource());
    }

    @Override
    public Set<String> getViewNames(String schemaName) {
        return this.getSQLHandler().getItemsAsStringSet("select table_name from information_schema.tables where table_type = 'VIEW' and table_schema = '" + schemaName + "'", this.getDataSource());
    }

    @Override
    public Set<String> getSequenceNames(String schemaName) {
        return this.getSQLHandler().getItemsAsStringSet("select c.relname from pg_class c join pg_namespace n on (c.relnamespace = n.oid) where c.relkind = 'S' and n.nspname = '" + schemaName + "'", this.getDataSource());
    }

    @Override
    public Set<String> getTriggerNames(String schemaName) {
        HashSet<String> result = new HashSet<String>();
        Set<String> triggerAndTableNames = this.getSQLHandler().getItemsAsStringSet("select trigger_name || ',' || event_object_table from information_schema.triggers where trigger_schema = '" + schemaName + "'", this.getDataSource());
        for (String triggerAndTableName : triggerAndTableNames) {
            String[] parts = triggerAndTableName.split(",");
            String triggerName = this.quoted(parts[0]);
            String tableName = this.qualified(schemaName, parts[1]);
            result.add(triggerName + " ON " + tableName);
        }
        return result;
    }

    @Override
    public void dropSequence(String schemaName, String sequenceName) {
        this.getSQLHandler().execute("drop sequence " + this.qualified(schemaName, sequenceName) + " cascade", this.getDataSource());
    }

    @Override
    public void dropTrigger(String schemaName, String triggerName) {
        this.getSQLHandler().execute("drop trigger " + triggerName + " cascade", this.getDataSource());
    }

    @Override
    public Set<String> getTypeNames(String schemaName) {
        return this.getSQLHandler().getItemsAsStringSet("select object_name from information_schema.data_type_privileges where object_type = 'USER-DEFINED TYPE' and object_schema = '" + schemaName + "'", this.getDataSource());
    }

    @Override
    public void disableReferentialConstraints(String schemaName) {
        Set<String> tableNames = this.getTableNames(schemaName);
        for (String tableName : tableNames) {
            this.disableReferentialConstraints(schemaName, tableName);
        }
    }

    protected void disableReferentialConstraints(String schemaName, String tableName) {
        SQLHandler sqlHandler = this.getSQLHandler();
        Set<String> constraintNames = sqlHandler.getItemsAsStringSet("select constraint_name from information_schema.table_constraints con where con.table_name = '" + tableName + "' and constraint_type = 'FOREIGN KEY' and constraint_schema = '" + schemaName + "'", this.getDataSource());
        for (String constraintName : constraintNames) {
            sqlHandler.execute("alter table " + this.qualified(schemaName, tableName) + " drop constraint " + this.quoted(constraintName), this.getDataSource());
        }
    }

    @Override
    public void disableValueConstraints(String schemaName) {
        Set<String> tableNames = this.getTableNames(schemaName);
        for (String tableName : tableNames) {
            this.disableValueConstraints(schemaName, tableName);
        }
    }

    protected void disableValueConstraints(String schemaName, String tableName) {
        SQLHandler sqlHandler = this.getSQLHandler();
        Set<String> constraintNames = sqlHandler.getItemsAsStringSet("select constraint_name from information_schema.table_constraints con, pg_constraint pg_con where pg_con.conname = con.constraint_name and con.table_name = '" + tableName + "' and constraint_type in ('CHECK', 'UNIQUE') and constraint_schema = '" + schemaName + "'", this.getDataSource());
        for (String constraintName : constraintNames) {
            sqlHandler.execute("alter table " + this.qualified(schemaName, tableName) + " drop constraint " + this.quoted(constraintName), this.getDataSource());
        }
        Set<String> primaryKeyColumnNames = sqlHandler.getItemsAsStringSet("select column_name from information_schema.table_constraints con, information_schema.key_column_usage key where con.table_name = '" + tableName + "' and con.table_schema = '" + schemaName + "' and key.table_name = con.table_name and key.table_schema = con.table_schema and key.constraint_name = con.constraint_name and con.constraint_type = 'PRIMARY KEY'", this.getDataSource());
        Set<String> notNullColumnNames = sqlHandler.getItemsAsStringSet("select column_name from information_schema.columns where is_nullable = 'NO' and table_name = '" + tableName + "' and table_schema = '" + schemaName + "'", this.getDataSource());
        for (String notNullColumnName : notNullColumnNames) {
            if (primaryKeyColumnNames.contains(notNullColumnName)) continue;
            sqlHandler.execute("alter table " + this.qualified(schemaName, tableName) + " alter column " + notNullColumnName + " drop not null", this.getDataSource());
        }
    }

    @Override
    public long getSequenceValue(String schemaName, String sequenceName) {
        return this.getSQLHandler().getItemAsLong("select last_value from " + this.qualified(schemaName, sequenceName), this.getDataSource());
    }

    @Override
    public void incrementSequenceToValue(String schemaName, String sequenceName, long newSequenceValue) {
        this.getSQLHandler().getItemAsLong("select setval('" + this.qualified(schemaName, sequenceName) + "', " + newSequenceValue + ")", this.getDataSource());
    }

    @Override
    public void setDatabaseDefaultSchema() {
        this.getSQLHandler().execute("SET search_path TO " + this.getDefaultSchemaName(), this.getDataSource());
    }

    @Override
    public boolean supportsSequences() {
        return true;
    }

    @Override
    public boolean supportsTriggers() {
        return true;
    }

    @Override
    public boolean supportsTypes() {
        return true;
    }

    @Override
    public boolean supportsCascade() {
        return true;
    }

    @Override
    public boolean supportsSetDatabaseDefaultSchema() {
        return true;
    }
}

