/*
 * Decompiled with CFR 0.152.
 */
package org.dbmaintain.database;

import java.util.ArrayList;
import java.util.Properties;
import javax.sql.DataSource;
import org.dbmaintain.config.ConfigUtils;
import org.dbmaintain.database.Database;
import org.dbmaintain.database.DatabaseConnection;
import org.dbmaintain.database.DatabaseConnectionManager;
import org.dbmaintain.database.DatabaseDialectDetector;
import org.dbmaintain.database.DatabaseInfo;
import org.dbmaintain.database.Databases;
import org.dbmaintain.database.IdentifierProcessor;
import org.dbmaintain.database.IdentifierProcessorFactory;
import org.dbmaintain.util.DbMaintainException;
import org.dbmaintain.util.ReflectionUtils;
import thirdparty.org.apache.commons.lang.StringUtils;

public class DatabasesFactory {
    protected Properties configuration;
    protected DatabaseConnectionManager databaseConnectionManager;
    protected IdentifierProcessorFactory identifierProcessorFactory;

    public DatabasesFactory(Properties configuration, DatabaseConnectionManager databaseConnectionManager) {
        this.configuration = configuration;
        this.databaseConnectionManager = databaseConnectionManager;
        this.identifierProcessorFactory = new IdentifierProcessorFactory(configuration);
    }

    public Databases createDatabases() {
        ArrayList<Database> databases = new ArrayList<Database>();
        ArrayList<String> disabledDatabaseNames = new ArrayList<String>();
        Database defaultDatabase = null;
        for (DatabaseConnection databaseConnection : this.databaseConnectionManager.getDatabaseConnections()) {
            DatabaseInfo databaseInfo = databaseConnection.getDatabaseInfo();
            boolean disabled = databaseInfo.isDisabled();
            if (disabled) {
                disabledDatabaseNames.add(databaseInfo.getName());
            }
            if (databaseInfo.isDefaultDatabase()) {
                defaultDatabase = this.createDatabase(databaseConnection);
                if (disabled) continue;
                databases.add(defaultDatabase);
                continue;
            }
            if (disabled) continue;
            databases.add(this.createDatabase(databaseConnection));
        }
        return new Databases(defaultDatabase, databases, disabledDatabaseNames);
    }

    protected Database createDatabase(DatabaseConnection databaseConnection) {
        String databaseDialect = this.getDatabaseDialect(databaseConnection);
        DataSource dataSource = databaseConnection.getDataSource();
        String defaultSchemaName = databaseConnection.getDatabaseInfo().getDefaultSchemaName();
        IdentifierProcessor identifierProcessor = this.identifierProcessorFactory.createIdentifierProcessor(databaseDialect, defaultSchemaName, dataSource);
        Class<Database> clazz = ConfigUtils.getConfiguredClass(Database.class, this.configuration, databaseDialect);
        return ReflectionUtils.createInstanceOfType(clazz, false, new Class[]{DatabaseConnection.class, IdentifierProcessor.class}, new Object[]{databaseConnection, identifierProcessor});
    }

    protected String getDatabaseDialect(DatabaseConnection databaseConnection) {
        DatabaseInfo databaseInfo = databaseConnection.getDatabaseInfo();
        String dialect = databaseInfo.getDialect();
        if (StringUtils.isBlank(dialect) && (dialect = DatabaseDialectDetector.autoDetectDatabaseDialect(databaseInfo.getUrl())) == null) {
            throw new DbMaintainException("Unable to determine dialect from jdbc url. Please specify the dialect explicitly. E.g oracle, hsqldb, mysql, db2, postgresql, derby or mssql.");
        }
        return dialect;
    }
}

