/*
 * Decompiled with CFR 0.152.
 */
package org.dbmaintain.config;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Map;
import java.util.Properties;
import org.dbmaintain.util.DbMaintainException;
import thirdparty.org.apache.commons.io.IOUtils;

public class DbMaintainConfigurationLoader {
    public static final String DEFAULT_PROPERTIES_FILE_NAME = "dbmaintain-default.properties";

    public Properties loadConfiguration() {
        return this.loadConfiguration((Properties)null);
    }

    public Properties loadConfiguration(URL customConfigurationUrl) {
        return this.loadConfiguration(this.loadPropertiesFromURL(customConfigurationUrl));
    }

    public Properties loadConfiguration(File customConfigurationFile) {
        return this.loadConfiguration(this.loadPropertiesFromFile(customConfigurationFile));
    }

    public Properties loadConfiguration(Properties customConfiguration) {
        Properties properties = new Properties();
        properties.putAll((Map<?, ?>)this.loadDefaultConfiguration());
        if (customConfiguration != null) {
            properties.putAll((Map<?, ?>)customConfiguration);
        }
        return properties;
    }

    public Properties loadDefaultConfiguration() {
        Properties defaultConfiguration = this.loadPropertiesFromClasspath(DEFAULT_PROPERTIES_FILE_NAME);
        if (defaultConfiguration == null) {
            throw new DbMaintainException("Configuration file: dbmaintain-default.properties not found in classpath.");
        }
        return defaultConfiguration;
    }

    protected Properties loadPropertiesFromClasspath(String propertiesFileName) {
        Properties properties;
        InputStream inputStream;
        block5: {
            inputStream = null;
            inputStream = this.getClass().getClassLoader().getResourceAsStream(propertiesFileName);
            if (inputStream != null) break block5;
            Properties properties2 = null;
            IOUtils.closeQuietly(inputStream);
            return properties2;
        }
        try {
            properties = this.loadPropertiesFromStream(inputStream);
        }
        catch (IOException e) {
            try {
                throw new DbMaintainException("Unable to load configuration file: " + propertiesFileName, e);
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(inputStream);
                throw throwable;
            }
        }
        IOUtils.closeQuietly(inputStream);
        return properties;
    }

    protected Properties loadPropertiesFromURL(URL propertiesFileUrl) {
        if (propertiesFileUrl == null) {
            return null;
        }
        InputStream urlStream = null;
        try {
            urlStream = propertiesFileUrl.openStream();
            Properties properties = this.loadPropertiesFromStream(urlStream);
            return properties;
        }
        catch (IOException e) {
            throw new DbMaintainException("Unable to load configuration file " + propertiesFileUrl, e);
        }
        finally {
            IOUtils.closeQuietly(urlStream);
        }
    }

    protected Properties loadPropertiesFromFile(File propertiesFile) {
        Properties properties;
        if (propertiesFile == null) {
            return null;
        }
        FileInputStream inputStream = null;
        try {
            inputStream = new FileInputStream(propertiesFile);
            properties = this.loadPropertiesFromStream(inputStream);
        }
        catch (IOException e) {
            try {
                throw new DbMaintainException("Unable to load configuration file " + propertiesFile, e);
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(inputStream);
                throw throwable;
            }
        }
        IOUtils.closeQuietly(inputStream);
        return properties;
    }

    protected Properties loadPropertiesFromStream(InputStream inputStream) throws IOException {
        Properties properties = new Properties();
        properties.load(inputStream);
        return properties;
    }
}

