/*
 * Decompiled with CFR 0.152.
 */
package net.thisptr.jackson.jq.internal.tree;

import com.fasterxml.jackson.databind.JsonNode;
import java.util.ArrayList;
import java.util.List;
import java.util.Stack;
import net.thisptr.jackson.jq.JsonQuery;
import net.thisptr.jackson.jq.Scope;
import net.thisptr.jackson.jq.exception.JsonQueryException;
import net.thisptr.jackson.jq.internal.misc.Pair;
import net.thisptr.jackson.jq.internal.tree.matcher.PatternMatcher;

public class PipedQuery
extends JsonQuery {
    private List<Pair<JsonQuery, PatternMatcher>> qs;

    public PipedQuery(List<Pair<JsonQuery, PatternMatcher>> qs) {
        this.qs = qs;
    }

    @Override
    public List<JsonNode> apply(Scope scope, JsonNode in) throws JsonQueryException {
        ArrayList<JsonNode> out = new ArrayList<JsonNode>();
        PipedQuery.applyRecursive(scope, in, out, this.qs);
        return out;
    }

    private static void applyRecursive(Scope scope, JsonNode in, List<JsonNode> out, List<Pair<JsonQuery, PatternMatcher>> qs) throws JsonQueryException {
        if (qs.isEmpty()) {
            out.add(in);
            return;
        }
        Pair<JsonQuery, PatternMatcher> head = qs.get(0);
        JsonQuery q = (JsonQuery)head._1;
        PatternMatcher matcher = (PatternMatcher)head._2;
        Scope scope2 = matcher != null ? new Scope(scope) : scope;
        for (JsonNode o : q.apply(scope, in)) {
            if (matcher != null) {
                Stack<Pair<String, JsonNode>> accumulate = new Stack<Pair<String, JsonNode>>();
                matcher.match(scope, o, vars -> {
                    for (int i = vars.size() - 1; i >= 0; --i) {
                        Pair var = (Pair)vars.get(i);
                        scope2.setValue((String)var._1, (JsonNode)var._2);
                    }
                    PipedQuery.applyRecursive(scope2, in, out, qs.subList(1, qs.size()));
                }, accumulate, true);
                continue;
            }
            PipedQuery.applyRecursive(scope2, o, out, qs.subList(1, qs.size()));
        }
    }

    public String toString() {
        StringBuilder builder = new StringBuilder("(");
        String sep = "";
        for (Pair<JsonQuery, PatternMatcher> q : this.qs) {
            builder.append(sep);
            builder.append(((JsonQuery)q._1).toString());
            if (q._2 != null) {
                builder.append(" as ");
                builder.append(q._2);
            }
            sep = " | ";
        }
        builder.append(")");
        return builder.toString();
    }
}

