/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.people.monitoring;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.apache.solr.client.solrj.SolrClient;
import org.apache.solr.client.solrj.response.SolrPingResponse;
import org.jetbrains.annotations.NotNull;
import org.springframework.boot.actuate.health.AbstractHealthIndicator;
import org.springframework.boot.actuate.health.Health;
import org.springframework.boot.actuate.health.Status;
import org.springframework.stereotype.Component;

@Component
@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0017\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0014R\u000e\u0010\u0002\u001a\u00020\u0003X\u0092\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\t"}, d2={"Lde/justsoftware/people/monitoring/SolrPingHealthIndicator;", "Lorg/springframework/boot/actuate/health/AbstractHealthIndicator;", "solrClient", "Lorg/apache/solr/client/solrj/SolrClient;", "(Lorg/apache/solr/client/solrj/SolrClient;)V", "doHealthCheck", "", "builder", "Lorg/springframework/boot/actuate/health/Health$Builder;", "people-api"})
public class SolrPingHealthIndicator
extends AbstractHealthIndicator {
    @NotNull
    private final SolrClient solrClient;

    public SolrPingHealthIndicator(@NotNull SolrClient solrClient) {
        Intrinsics.checkNotNullParameter((Object)solrClient, (String)"solrClient");
        super("Solr ping health check failed");
        this.solrClient = solrClient;
    }

    protected void doHealthCheck(@NotNull Health.Builder builder) {
        Intrinsics.checkNotNullParameter((Object)builder, (String)"builder");
        SolrPingResponse response = this.solrClient.ping();
        int statusCode = response.getStatus();
        Status status = statusCode != 0 ? Status.DOWN : Status.UP;
        builder.status(status).withDetail("status", (Object)statusCode);
    }
}

