/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.people.kafka;

import de.justsoftware.people.kafka.KafkaConfigurationProvider;
import java.util.Map;
import java.util.Properties;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.apache.kafka.clients.consumer.Consumer;
import org.apache.kafka.clients.consumer.KafkaConsumer;
import org.apache.kafka.common.serialization.Deserializer;
import org.apache.kafka.common.serialization.StringDeserializer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.DependsOn;
import org.springframework.stereotype.Service;

@Service
@DependsOn(value={"liquibase"})
@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0017\u0018\u0000 \u00142\u00020\u0001:\u0001\u0014B\u0019\u0012\b\b\u0001\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0001\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006JN\u0010\u0007\u001a\u000e\u0012\u0004\u0012\u0002H\t\u0012\u0004\u0012\u0002H\n0\b\"\u0004\b\u0000\u0010\t\"\u0004\b\u0001\u0010\n2\b\u0010\u000b\u001a\u0004\u0018\u00010\u00032\f\u0010\f\u001a\b\u0012\u0004\u0012\u0002H\t0\r2\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u0002H\n0\r2\u0006\u0010\u0004\u001a\u00020\u0005H\u0012J\u0012\u0010\u000f\u001a\u00020\u00102\b\u0010\u000b\u001a\u0004\u0018\u00010\u0003H\u0016J\u001a\u0010\u0011\u001a\u00020\u00102\b\u0010\u000b\u001a\u0004\u0018\u00010\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0012J2\u0010\u0012\u001a\u0010\u0012\u0006\u0012\u0004\u0018\u00010\u0003\u0012\u0004\u0012\u0002H\n0\b\"\u0004\b\u0000\u0010\n2\u0006\u0010\u000b\u001a\u00020\u00032\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u0002H\n0\rH\u0016J\b\u0010\u0013\u001a\u00020\u0010H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0092\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lde/justsoftware/people/kafka/KafkaConfigurationProvider;", "", "bootstrapServers", "", "maxChunkSize", "", "(Ljava/lang/String;I)V", "consumer", "Lorg/apache/kafka/clients/consumer/Consumer;", "K", "V", "groupId", "keyDeserializer", "Lorg/apache/kafka/common/serialization/Deserializer;", "valueDeserializer", "consumerConfig", "Ljava/util/Properties;", "defaultConsumerConfig", "modelConsumer", "producerConfig", "Companion", "people-api"})
@SourceDebugExtension(value={"SMAP\nKafkaConfigurationProvider.kt\nKotlin\n*S Kotlin\n*F\n+ 1 KafkaConfigurationProvider.kt\nde/justsoftware/people/kafka/KafkaConfigurationProvider\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,79:1\n1#2:80\n*E\n"})
public class KafkaConfigurationProvider {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final String bootstrapServers;
    private final int maxChunkSize;
    private static final Integer KAFKA_PRODUCER_BUFFER_MEMORY = 0x2000000;
    private static final Integer KAFKA_PRODUCER_BATCH_SIZE = 16384;
    @NotNull
    public static final String GROUP_TOPIC = "just.people.userGroup";
    @NotNull
    public static final String MEMBERSHIP_TOPIC = "just.people.userGroupMembers";
    @NotNull
    public static final String GROUP_IMPORT_TOPIC = "just.people.import.userGroup";
    @NotNull
    public static final String MEMBERSHIP_IMPORT_TOPIC = "just.people.import.userGroupMembers";
    @NotNull
    public static final String KAFKA_STRING_PRODUCER = "KAFKA_STRING_PRODUCER";

    public KafkaConfigurationProvider(@Value(value="${kafka.bootstrapServers:}") @NotNull String bootstrapServers, @Value(value="${kafka.consumerMaxChunkSize:100}") int maxChunkSize) {
        Intrinsics.checkNotNullParameter((Object)bootstrapServers, (String)"bootstrapServers");
        this.bootstrapServers = bootstrapServers;
        this.maxChunkSize = maxChunkSize;
    }

    @NotNull
    public Properties producerConfig() {
        Properties properties;
        Properties $this$producerConfig_u24lambda_u240 = properties = new Properties();
        boolean bl = false;
        ((Map)$this$producerConfig_u24lambda_u240).put("bootstrap.servers", this.bootstrapServers);
        ((Map)$this$producerConfig_u24lambda_u240).put("acks", "all");
        ((Map)$this$producerConfig_u24lambda_u240).put("retries", 0);
        ((Map)$this$producerConfig_u24lambda_u240).put("batch.size", KAFKA_PRODUCER_BATCH_SIZE);
        ((Map)$this$producerConfig_u24lambda_u240).put("linger.ms", 1);
        ((Map)$this$producerConfig_u24lambda_u240).put("buffer.memory", KAFKA_PRODUCER_BUFFER_MEMORY);
        return properties;
    }

    @NotNull
    public <V> Consumer<String, V> modelConsumer(@NotNull String groupId, @NotNull Deserializer<V> valueDeserializer) {
        Intrinsics.checkNotNullParameter((Object)groupId, (String)"groupId");
        Intrinsics.checkNotNullParameter(valueDeserializer, (String)"valueDeserializer");
        return this.consumer(groupId, (Deserializer)new StringDeserializer(), valueDeserializer, this.maxChunkSize);
    }

    @NotNull
    public Properties consumerConfig(@Nullable String groupId) {
        return this.defaultConsumerConfig(groupId, this.maxChunkSize);
    }

    private Properties defaultConsumerConfig(String groupId, int maxChunkSize) {
        Properties properties;
        block0: {
            String string;
            Properties $this$defaultConsumerConfig_u24lambda_u242 = properties = new Properties();
            boolean bl = false;
            ((Map)$this$defaultConsumerConfig_u24lambda_u242).put("bootstrap.servers", this.bootstrapServers);
            ((Map)$this$defaultConsumerConfig_u24lambda_u242).put("enable.auto.commit", "false");
            ((Map)$this$defaultConsumerConfig_u24lambda_u242).put("auto.offset.reset", "earliest");
            Integer n = maxChunkSize;
            ((Map)$this$defaultConsumerConfig_u24lambda_u242).put("max.poll.records", n);
            String string2 = groupId;
            if (string2 == null) break block0;
            String $this$defaultConsumerConfig_u24lambda_u242_u24lambda_u241 = string = string2;
            boolean bl2 = false;
            $this$defaultConsumerConfig_u24lambda_u242.put("group.id", groupId);
        }
        return properties;
    }

    private <K, V> Consumer<K, V> consumer(String groupId, Deserializer<K> keyDeserializer, Deserializer<V> valueDeserializer, int maxChunkSize) {
        return (Consumer)new KafkaConsumer(this.defaultConsumerConfig(groupId, maxChunkSize), keyDeserializer, valueDeserializer);
    }
}

