/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.people.kafka;

import com.google.common.collect.ImmutableMap;
import de.justsoftware.kafka.client.KafkaCleaningProducer;
import de.justsoftware.kafka.client.KafkaCleaningProducerImpl;
import de.justsoftware.people.kafka.KafkaConfiguration;
import de.justsoftware.people.kafka.KafkaConfigurationProvider;
import java.util.Map;
import java.util.Properties;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import org.apache.kafka.clients.admin.NewTopic;
import org.apache.kafka.clients.consumer.Consumer;
import org.apache.kafka.clients.producer.Producer;
import org.apache.kafka.common.TopicPartition;
import org.jetbrains.annotations.NotNull;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.kafka.core.KafkaAdmin;

@Configuration
@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\b\b\u0017\u0018\u0000 \u00162\u00020\u0001:\u0002\u0015\u0016B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0012\u0010\u0003\u001a\u00020\u00042\b\b\u0001\u0010\u0005\u001a\u00020\u0006H\u0017J\u001c\u0010\u0007\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00060\b2\u0006\u0010\t\u001a\u00020\nH\u0017J\u0018\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u00062\u0006\u0010\u000e\u001a\u00020\u000fH\u0012J\b\u0010\u0010\u001a\u00020\fH\u0017J\b\u0010\u0011\u001a\u00020\fH\u0017J\b\u0010\u0012\u001a\u00020\fH\u0017J\b\u0010\u0013\u001a\u00020\fH\u0017J\b\u0010\u0014\u001a\u00020\fH\u0017\u00a8\u0006\u0017"}, d2={"Lde/justsoftware/people/kafka/KafkaConfiguration;", "", "()V", "admin", "Lorg/springframework/kafka/core/KafkaAdmin;", "bootstrapServers", "", "createStringProducer", "Lde/justsoftware/kafka/client/KafkaCleaningProducer;", "kafkaConfigurationProvider", "Lde/justsoftware/people/kafka/KafkaConfigurationProvider;", "defaultTopicFactory", "Lorg/apache/kafka/clients/admin/NewTopic;", "name", "partitions", "", "searchIndexTopic", "userGroupImportTopic", "userGroupMembersImportTopic", "userGroupMembersTopic", "userGroupTopic", "ClosingKafkaProducer", "Companion", "people-api"})
public class KafkaConfiguration {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final String SEVEN_DAYS_IN_MS = "604800000";

    @Bean(name={"KAFKA_STRING_PRODUCER"}, destroyMethod="close")
    @NotNull
    public KafkaCleaningProducer<String, String> createStringProducer(@NotNull KafkaConfigurationProvider kafkaConfigurationProvider) {
        Intrinsics.checkNotNullParameter((Object)kafkaConfigurationProvider, (String)"kafkaConfigurationProvider");
        Properties props = kafkaConfigurationProvider.producerConfig();
        return (KafkaCleaningProducer)new KafkaCleaningProducerImpl((Producer)new ClosingKafkaProducer(props), arg_0 -> KafkaConfiguration.createStringProducer$lambda$0(kafkaConfigurationProvider, arg_0));
    }

    @Bean
    @NotNull
    public KafkaAdmin admin(@Value(value="${kafka.bootstrapServers}") @NotNull String bootstrapServers) {
        Intrinsics.checkNotNullParameter((Object)bootstrapServers, (String)"bootstrapServers");
        ImmutableMap immutableMap = ImmutableMap.of((Object)"bootstrap.servers", (Object)bootstrapServers);
        Intrinsics.checkNotNullExpressionValue((Object)immutableMap, (String)"of<String, Any>(AdminCli\u2026CONFIG, bootstrapServers)");
        Map configs = (Map)immutableMap;
        KafkaAdmin admin = new KafkaAdmin(configs);
        admin.setFatalIfBrokerNotAvailable(true);
        return admin;
    }

    @Bean
    @NotNull
    public NewTopic userGroupImportTopic() {
        return this.defaultTopicFactory("just.people.import.userGroup", 1);
    }

    @Bean
    @NotNull
    public NewTopic userGroupMembersImportTopic() {
        return this.defaultTopicFactory("just.people.import.userGroupMembers", 1);
    }

    @Bean
    @NotNull
    public NewTopic searchIndexTopic() {
        NewTopic topic = new NewTopic("just.people.search.index", 1, 1);
        Pair[] pairArray = new Pair[]{TuplesKt.to((Object)"delete.retention.ms", (Object)SEVEN_DAYS_IN_MS), TuplesKt.to((Object)"segment.ms", (Object)SEVEN_DAYS_IN_MS), TuplesKt.to((Object)"cleanup.policy", (Object)"delete")};
        Map config = MapsKt.mapOf((Pair[])pairArray);
        NewTopic newTopic = topic.configs(config);
        Intrinsics.checkNotNullExpressionValue((Object)newTopic, (String)"topic.configs(config)");
        return newTopic;
    }

    @Bean
    @NotNull
    public NewTopic userGroupTopic() {
        return this.defaultTopicFactory("just.people.userGroup", 5);
    }

    @Bean
    @NotNull
    public NewTopic userGroupMembersTopic() {
        return this.defaultTopicFactory("just.people.userGroupMembers", 5);
    }

    private NewTopic defaultTopicFactory(String name, int partitions) {
        ImmutableMap immutableMap = ImmutableMap.of((Object)"delete.retention.ms", (Object)SEVEN_DAYS_IN_MS, (Object)"segment.ms", (Object)SEVEN_DAYS_IN_MS, (Object)"cleanup.policy", (Object)"compact");
        Intrinsics.checkNotNullExpressionValue((Object)immutableMap, (String)"of(\n            TopicCon\u2026_POLICY_COMPACT\n        )");
        ImmutableMap defaultTopicConfig = immutableMap;
        NewTopic topic = new NewTopic(name, partitions, 1);
        NewTopic newTopic = topic.configs((Map)defaultTopicConfig);
        Intrinsics.checkNotNullExpressionValue((Object)newTopic, (String)"topic.configs(defaultTopicConfig)");
        return newTopic;
    }

    private static final Consumer createStringProducer$lambda$0(KafkaConfigurationProvider $kafkaConfigurationProvider, TopicPartition tp) {
        Intrinsics.checkNotNullParameter((Object)$kafkaConfigurationProvider, (String)"$kafkaConfigurationProvider");
        Intrinsics.checkNotNullParameter((Object)tp, (String)"tp");
        return KafkaCleaningProducerImpl.createStringConsumer((TopicPartition)tp, (Properties)$kafkaConfigurationProvider.consumerConfig(null));
    }
}

