/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.people.controller;

import de.justsoftware.people.business.search.SearchService;
import de.justsoftware.people.business.usergroup.UserGroupPublisher;
import de.justsoftware.people.business.usergroup.UserGroupService;
import de.justsoftware.people.model.TenantId;
import de.justsoftware.people.model.UserGroupId;
import io.swagger.v3.oas.annotations.Hidden;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/internal"})
@Hidden
@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\b\u0017\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u0012\u0010\t\u001a\u00020\n2\b\b\u0001\u0010\u000b\u001a\u00020\fH\u0017J\b\u0010\r\u001a\u00020\u000eH\u0017J\b\u0010\u000f\u001a\u00020\u000eH\u0017J\b\u0010\u0010\u001a\u00020\u000eH\u0017J\b\u0010\u0011\u001a\u00020\u0012H\u0017R\u000e\u0010\u0006\u001a\u00020\u0007X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0092\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lde/justsoftware/people/controller/InternalPeopleController;", "", "userGroupService", "Lde/justsoftware/people/business/usergroup/UserGroupService;", "userGroupPublisher", "Lde/justsoftware/people/business/usergroup/UserGroupPublisher;", "searchService", "Lde/justsoftware/people/business/search/SearchService;", "(Lde/justsoftware/people/business/usergroup/UserGroupService;Lde/justsoftware/people/business/usergroup/UserGroupPublisher;Lde/justsoftware/people/business/search/SearchService;)V", "getAllTenantUsersGroup", "Lde/justsoftware/people/model/UserGroupId;", "tenantId", "Lde/justsoftware/people/model/TenantId;", "publishUserGroups", "", "reindexUserGroups", "status", "version", "", "people-api"})
public class InternalPeopleController {
    @NotNull
    private final UserGroupService userGroupService;
    @NotNull
    private final UserGroupPublisher userGroupPublisher;
    @NotNull
    private final SearchService searchService;

    public InternalPeopleController(@NotNull UserGroupService userGroupService, @NotNull UserGroupPublisher userGroupPublisher, @NotNull SearchService searchService) {
        Intrinsics.checkNotNullParameter((Object)userGroupService, (String)"userGroupService");
        Intrinsics.checkNotNullParameter((Object)userGroupPublisher, (String)"userGroupPublisher");
        Intrinsics.checkNotNullParameter((Object)searchService, (String)"searchService");
        this.userGroupService = userGroupService;
        this.userGroupPublisher = userGroupPublisher;
        this.searchService = searchService;
    }

    @PostMapping(value={"publish/groups"})
    public void publishUserGroups() {
        this.userGroupPublisher.publishAllUserGroups();
    }

    @PostMapping(value={"reindex/groups"})
    public void reindexUserGroups() {
        this.searchService.reindexAllGroups();
    }

    @PostMapping(value={"status"})
    public void status() {
    }

    @GetMapping(value={"version"}, produces={"text/plain"})
    @NotNull
    public String version() {
        return "13.11.5-3690";
    }

    @GetMapping(value={"/{tenantId}/allUsersGroup"})
    @NotNull
    public UserGroupId getAllTenantUsersGroup(@PathVariable @NotNull TenantId tenantId) {
        Intrinsics.checkNotNullParameter((Object)tenantId, (String)"tenantId");
        return this.userGroupService.createOrGetAllTenantUsersGroup(tenantId);
    }
}

