/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.people.config;

import com.google.common.collect.ImmutableList;
import java.util.Collection;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import org.springframework.security.core.GrantedAuthority;
import org.springframework.security.core.authority.SimpleGrantedAuthority;
import org.springframework.security.oauth2.core.DefaultOAuth2AuthenticatedPrincipal;
import org.springframework.security.oauth2.core.OAuth2AuthenticatedPrincipal;
import org.springframework.security.oauth2.server.resource.introspection.NimbusOpaqueTokenIntrospector;
import org.springframework.security.oauth2.server.resource.introspection.OpaqueTokenIntrospector;

@ParametersAreNonnullByDefault
public class JustOpaqueTokenIntrospector
implements OpaqueTokenIntrospector {
    private final OpaqueTokenIntrospector _delegate;

    public JustOpaqueTokenIntrospector(String introspectionUri, String clientId, String clientSecret) {
        this._delegate = new NimbusOpaqueTokenIntrospector(introspectionUri, clientId, clientSecret);
    }

    public OAuth2AuthenticatedPrincipal introspect(String token) {
        OAuth2AuthenticatedPrincipal principal = this._delegate.introspect(token);
        String profileId = (String)principal.getAttribute("profileId");
        return new DefaultOAuth2AuthenticatedPrincipal(profileId, principal.getAttributes(), (Collection)this.extractAuthorities(principal));
    }

    @Nonnull
    private List<GrantedAuthority> extractAuthorities(OAuth2AuthenticatedPrincipal principal) {
        List scopes = (List)principal.getAttribute("scope");
        if (scopes == null) {
            return ImmutableList.of();
        }
        return (List)scopes.stream().map(scope -> new SimpleGrantedAuthority("SCOPE_" + scope)).collect(ImmutableList.toImmutableList());
    }
}

