/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.people.business.usergroup;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableMap;
import de.justsoftware.people.business.usergroup.UserGroupImportService;
import de.justsoftware.people.business.usergroup.UserGroupService;
import de.justsoftware.people.business.usergroup.model.IsMember;
import de.justsoftware.people.business.usergroup.model.Membership;
import de.justsoftware.people.business.usergroup.model.UserGroupImportModel;
import de.justsoftware.people.business.usergroup.model.UserGroupKafkaModel;
import de.justsoftware.people.model.UserGroupId;
import de.justsoftware.people.model.UserGroupRole;
import de.justsoftware.people.persistence.UserGroupRepository;
import de.justsoftware.people.persistence.model.DbUserGroup;
import de.justsoftware.people.utils.CollectionUtilsKt;
import de.justsoftware.permission.client.model.Role;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import org.apache.kafka.clients.consumer.ConsumerRecord;
import org.apache.kafka.clients.consumer.ConsumerRecords;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.kafka.annotation.KafkaListener;
import org.springframework.stereotype.Service;

/*
 * Exception performing whole class analysis ignored.
 */
@Service
@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0017\u0018\u0000 \u00162\u00020\u0001:\u0001\u0016B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0015\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0011\u00a2\u0006\u0002\b\u000bJ#\u0010\f\u001a\u00020\b2\u0014\u0010\r\u001a\u0010\u0012\u0004\u0012\u00020\u000f\u0012\u0006\u0012\u0004\u0018\u00010\u00100\u000eH\u0011\u00a2\u0006\u0002\b\u0011J#\u0010\u0012\u001a\u00020\b2\u0014\u0010\r\u001a\u0010\u0012\u0004\u0012\u00020\u0013\u0012\u0006\u0012\u0004\u0018\u00010\u00140\u000eH\u0011\u00a2\u0006\u0002\b\u0015R\u000e\u0010\u0004\u001a\u00020\u0005X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0092\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Lde/justsoftware/people/business/usergroup/UserGroupImportService;", "", "userGroupService", "Lde/justsoftware/people/business/usergroup/UserGroupService;", "userGroupRepository", "Lde/justsoftware/people/persistence/UserGroupRepository;", "(Lde/justsoftware/people/business/usergroup/UserGroupService;Lde/justsoftware/people/persistence/UserGroupRepository;)V", "importUserGroup", "", "userGroupImportModel", "Lde/justsoftware/people/business/usergroup/model/UserGroupImportModel;", "importUserGroup$people_api", "onUserGroupImported", "records", "Lorg/apache/kafka/clients/consumer/ConsumerRecords;", "Lde/justsoftware/people/model/UserGroupId;", "Lde/justsoftware/people/business/usergroup/model/UserGroupKafkaModel;", "onUserGroupImported$people_api", "onUserGroupMemberImported", "Lde/justsoftware/people/business/usergroup/model/Membership;", "Lde/justsoftware/people/business/usergroup/model/IsMember;", "onUserGroupMemberImported$people_api", "Companion", "people-api"})
@SourceDebugExtension(value={"SMAP\nUserGroupImportService.kt\nKotlin\n*S Kotlin\n*F\n+ 1 UserGroupImportService.kt\nde/justsoftware/people/business/usergroup/UserGroupImportService\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 CollectionUtils.kt\nde/justsoftware/people/utils/CollectionUtilsKt\n*L\n1#1,141:1\n1194#2,2:142\n1222#2,4:144\n1855#2:151\n1856#2:155\n1549#2:157\n1620#2,3:158\n1549#2:161\n1620#2,3:162\n1620#2,3:166\n1855#2,2:169\n7#3,3:148\n10#3,3:152\n13#3:156\n17#3:165\n*S KotlinDebug\n*F\n+ 1 UserGroupImportService.kt\nde/justsoftware/people/business/usergroup/UserGroupImportService\n*L\n64#1:142,2\n64#1:144,4\n66#1:151\n66#1:155\n72#1:157\n72#1:158,3\n73#1:161\n73#1:162,3\n79#1:166,3\n79#1:169,2\n66#1:148,3\n66#1:152,3\n66#1:156\n79#1:165\n*E\n"})
public class UserGroupImportService {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final UserGroupService userGroupService;
    @NotNull
    private final UserGroupRepository userGroupRepository;
    @NotNull
    public static final String USER_GROUP_TOPIC = "just.people.import.userGroup";
    @NotNull
    public static final String USER_GROUP_MEMBER_TOPIC = "just.people.import.userGroupMembers";
    @NotNull
    private static final String USER_GROUP_LISTENER_ID = "userGroupImportConsumer";
    @NotNull
    private static final String USER_GROUP_MEMBER_LISTENER_ID = "userGroupMemberImportConsumer";
    private static final Logger LOG = LoggerFactory.getLogger(UserGroupImportService.class);

    public UserGroupImportService(@NotNull UserGroupService userGroupService, @NotNull UserGroupRepository userGroupRepository) {
        Intrinsics.checkNotNullParameter((Object)userGroupService, (String)"userGroupService");
        Intrinsics.checkNotNullParameter((Object)userGroupRepository, (String)"userGroupRepository");
        this.userGroupService = userGroupService;
        this.userGroupRepository = userGroupRepository;
    }

    @KafkaListener(id="userGroupImportConsumer", containerFactory="userGroupImportConsumerFactory", topics={"just.people.import.userGroup"}, idIsGroup=false)
    public void onUserGroupImported$people_api(@NotNull ConsumerRecords<UserGroupId, UserGroupKafkaModel> records) {
        Intrinsics.checkNotNullParameter(records, (String)"records");
        for (ConsumerRecord record : records) {
            UserGroupId userGroupId = (UserGroupId)record.key();
            UserGroupKafkaModel userGroup = (UserGroupKafkaModel)record.value();
            if (userGroup != null) {
                LOG.info("Importing user groups");
                this.importUserGroup$people_api(new UserGroupImportModel(userGroupId, userGroup.getName(), userGroup.getTenantId()));
                continue;
            }
            LOG.info("Deleting user groups");
            Intrinsics.checkNotNullExpressionValue((Object)userGroupId, (String)"userGroupId");
            this.userGroupService.deleteUserGroup(userGroupId);
        }
    }

    /*
     * WARNING - void declaration
     */
    @KafkaListener(id="userGroupMemberImportConsumer", containerFactory="userGroupMemberImportConsumerFactory", topics={"just.people.import.userGroupMembers"}, idIsGroup=false)
    public void onUserGroupMemberImported$people_api(@NotNull ConsumerRecords<Membership, IsMember> records) {
        void $this$forEach$iv;
        Collection<String> collection;
        Collection collection2;
        Iterable $this$mapTo$iv$iv;
        Iterable $this$map$iv;
        Object object;
        void $this$associateByTo$iv$iv;
        Intrinsics.checkNotNullParameter(records, (String)"records");
        Iterable $this$associateBy$iv = (Iterable)records;
        boolean $i$f$associateBy = false;
        int capacity$iv = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associateBy$iv, (int)10)), (int)16);
        Iterable iterable = $this$associateBy$iv;
        Map destination$iv$iv = new LinkedHashMap(capacity$iv);
        boolean $i$f$associateByTo = false;
        for (Object element$iv$iv : $this$associateByTo$iv$iv) {
            void it;
            ConsumerRecord consumerRecord = (ConsumerRecord)element$iv$iv;
            object = destination$iv$iv;
            boolean bl = false;
            object.put(((Membership)it.key()).getMembership(), element$iv$iv);
        }
        Iterable $this$partition$iv = destination$iv$iv.values();
        boolean $i$f$partition = false;
        Iterable first$iv = new ArrayList();
        ArrayList second$iv = new ArrayList();
        Iterable $this$forEach$iv$iv = $this$partition$iv;
        boolean $i$f$forEach = false;
        for (Object element$iv$iv : $this$forEach$iv$iv) {
            void p0;
            Object element$iv = element$iv$iv;
            boolean bl = false;
            ConsumerRecord record = (ConsumerRecord)element$iv;
            boolean $i$a$-partition-UserGroupImportService$onUserGroupMemberImported$42 = false;
            Iterable target$iv = record.value() != null ? first$iv : second$iv;
            ConsumerRecord $i$a$-partition-UserGroupImportService$onUserGroupMemberImported$42 = (ConsumerRecord)element$iv;
            object = target$iv;
            boolean bl2 = false;
            ((ArrayList)object).add((Membership)p0.key());
        }
        Pair pair = TuplesKt.to(first$iv, second$iv);
        List membersToSave = (List)pair.component1();
        List membersToDelete = (List)pair.component2();
        first$iv = membersToSave;
        object = LOG;
        boolean $i$f$map = false;
        $this$forEach$iv$iv = $this$map$iv;
        Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void p0;
            Membership bl = (Membership)item$iv$iv;
            collection2 = destination$iv$iv2;
            boolean bl3 = false;
            collection2.add(p0.getMembership());
        }
        $this$map$iv = membersToDelete;
        collection2 = (List)destination$iv$iv2;
        $i$f$map = false;
        $this$mapTo$iv$iv = $this$map$iv;
        destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            Membership p0 = (Membership)item$iv$iv;
            collection = destination$iv$iv2;
            boolean bl = false;
            collection.add(p0.getMembership());
        }
        collection = (List)destination$iv$iv2;
        object.info("Importing user groups members: addMembers " + (List)collection2 + ", deleteMembers " + (List)collection);
        Iterable $this$mapToSet$iv = membersToSave;
        boolean $i$f$mapToSet = false;
        $this$mapTo$iv$iv = $this$mapToSet$iv;
        destination$iv$iv2 = new LinkedHashSet(CollectionUtilsKt.getDefaultSize((Iterable)$this$mapToSet$iv));
        $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            Membership p0 = (Membership)item$iv$iv;
            object = destination$iv$iv2;
            boolean bl = false;
            object.add(it.getUserGroupId());
        }
        $this$mapToSet$iv = (Set)destination$iv$iv2;
        boolean $i$f$forEach2 = false;
        for (Object element$iv : $this$forEach$iv) {
            UserGroupId it = (UserGroupId)element$iv;
            boolean bl = false;
            if (this.userGroupService.findUserGroup(it).isPresent()) continue;
            UserGroupImportModel userGroupImportModel = UserGroupImportModel.createNotYetImported((UserGroupId)it);
            Intrinsics.checkNotNullExpressionValue((Object)userGroupImportModel, (String)"createNotYetImported(it)");
            this.importUserGroup$people_api(userGroupImportModel);
        }
        this.userGroupService.updateMembers(membersToSave, membersToDelete);
        LOG.info("Import done");
    }

    @VisibleForTesting
    public void importUserGroup$people_api(@NotNull UserGroupImportModel userGroupImportModel) {
        Intrinsics.checkNotNullParameter((Object)userGroupImportModel, (String)"userGroupImportModel");
        UserGroupId userGroupId = userGroupImportModel.getUserGroupId();
        Intrinsics.checkNotNullExpressionValue((Object)userGroupId, (String)"userGroupImportModel.userGroupId");
        UserGroupId userGroupId2 = userGroupId;
        ImmutableMap immutableMap = ImmutableMap.of((Object)Role.userGroupRole((UUID)((UUID)userGroupId2.getId())), (Object)UserGroupRole.READER);
        Intrinsics.checkNotNullExpressionValue((Object)immutableMap, (String)"of(\n            Role.use\u2026roupRole.READER\n        )");
        ImmutableMap defaultPermissions = immutableMap;
        DbUserGroup userGroup = this.userGroupRepository.findById(userGroupId2.getId()).orElse(null);
        if (userGroup == null) {
            this.userGroupRepository.save((Object)Companion.access$toDbUserGroup((Companion)Companion, (UserGroupImportModel)userGroupImportModel));
            if (!Intrinsics.areEqual((Object)userGroupImportModel.getName(), (Object)"notYetImported")) {
                this.userGroupService.publishUserGroup(userGroupId2, (Map)defaultPermissions);
            }
        } else if (Intrinsics.areEqual((Object)userGroup.getName(), (Object)"notYetImported")) {
            String string = userGroupImportModel.getName();
            UUID uUID = (UUID)userGroupImportModel.getTenantId().getId();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"name");
            this.userGroupRepository.save((Object)DbUserGroup.copy$default((DbUserGroup)userGroup, null, (UUID)uUID, (String)string, null, (boolean)false, (boolean)false, (int)57, null));
            this.userGroupService.publishUserGroup(userGroupId2, (Map)defaultPermissions);
        } else {
            String string = userGroupImportModel.getName();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"userGroupImportModel.name");
            this.userGroupService.renameUserGroup(userGroupId2, string);
        }
    }
}

