/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.people.business.search.solr.model;

import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import de.justsoftware.people.business.search.solr.model.SearchModel;
import de.justsoftware.people.model.DynamicProfileFields;
import de.justsoftware.people.model.ProfileId;
import de.justsoftware.people.model.StaticProfileFields;
import de.justsoftware.people.model.UserGroupId;
import java.util.Collection;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;

@ParametersAreNonnullByDefault
public class ProfileSearchReadModel
implements SearchModel {
    public static final String PROFILE = "PROFILE";
    private final StaticProfileFields _staticProfileFields;
    private final DynamicProfileFields _fields;
    private final ImmutableSet<UserGroupId> _userGroupIds;

    public ProfileSearchReadModel(StaticProfileFields staticProfileFields, @Nullable DynamicProfileFields fields, ImmutableSet<UserGroupId> userGroupIds) {
        this._staticProfileFields = staticProfileFields;
        this._fields = fields == null ? new DynamicProfileFields((Map)ImmutableMap.of()) : fields;
        this._userGroupIds = userGroupIds;
    }

    @Nonnull
    public ProfileId getId() {
        return this._staticProfileFields.getId();
    }

    @Nonnull
    public String getFirstName() {
        return this._staticProfileFields.getFirstName();
    }

    @Nonnull
    public String getLastName() {
        return this._staticProfileFields.getLastName();
    }

    @Nonnull
    public String getTitle() {
        return this._staticProfileFields.getTitle();
    }

    @Nonnull
    public String getAdditionalTitle() {
        return this._staticProfileFields.getAdditionalTitle();
    }

    @Nonnull
    public String getProfileHash() {
        return this._staticProfileFields.getProfileHash();
    }

    @Nonnull
    public String getImageUrl() {
        return this._staticProfileFields.getImageUrl();
    }

    public boolean isBlocked() {
        return this._staticProfileFields.getBlocked();
    }

    public boolean isActive() {
        return this._staticProfileFields.getActive();
    }

    @Nonnull
    public Map<String, Collection<String>> getFields() {
        return this._fields.getFields();
    }

    @Nonnull
    public ImmutableSet<UserGroupId> getUserGroupIds() {
        return this._userGroupIds;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("id", (Object)this.getId()).add("firstName", (Object)this.getFirstName()).add("lastName", (Object)this.getLastName()).add("title", (Object)this.getTitle()).add("additionalTitle", (Object)this.getAdditionalTitle()).add("profileHash", (Object)this.getProfileHash()).add("imageUrl", (Object)this.getImageUrl()).add("blocked", this.isBlocked()).add("active", this.isActive()).add("fields", (Object)this._fields).add("userGroupIds", (Object)this._userGroupIds).toString();
    }

    public String getType() {
        return PROFILE;
    }
}

