/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.people.business.search.solr;

import de.justsoftware.people.business.search.solr.SolrQueryHelper;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.apache.solr.client.solrj.SolrQuery;
import org.apache.solr.client.solrj.util.ClientUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\b\u0003\n\u0002\u0010\u001c\n\u0002\b\u0007\n\u0002\u0010\u0007\n\u0002\b\u0005\n\u0002\u0010\b\n\u0002\b\u0003\b\u00c0\u0002\u0018\u00002\u00020\u0001:\u0002\u001e\u001fB\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J9\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\b\u0010\t\u001a\u0004\u0018\u00010\b2\u0012\u0010\n\u001a\n\u0012\u0006\b\u0001\u0012\u00020\b0\u000b\"\u00020\b\u00a2\u0006\u0002\u0010\fJ=\u0010\r\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\b0\u000f2\u0012\u0010\u0010\u001a\n\u0012\u0006\b\u0001\u0012\u00020\b0\u000b\"\u00020\b\u00a2\u0006\u0002\u0010\u0011J\u0010\u0010\u0012\u001a\u00020\b2\u0006\u0010\u0013\u001a\u00020\bH\u0002J\u0016\u0010\u0014\u001a\u00020\b2\u0006\u0010\u0015\u001a\u00020\b2\u0006\u0010\u0016\u001a\u00020\u0017J\u0010\u0010\u0018\u001a\u00020\b2\u0006\u0010\u0013\u001a\u00020\bH\u0002J\u001e\u0010\u0019\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\u001a\u001a\u00020\bJ\u001e\u0010\u001b\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\u001c\u001a\u00020\u001d\u00a8\u0006 "}, d2={"Lde/justsoftware/people/business/search/solr/SolrQueryHelper;", "", "()V", "addFacetFieldWithExclusion", "", "query", "Lorg/apache/solr/client/solrj/SolrQuery;", "field", "", "facetKey", "exclusionFilter", "", "(Lorg/apache/solr/client/solrj/SolrQuery;Ljava/lang/String;Ljava/lang/String;[Ljava/lang/String;)V", "addFilterQuery", "values", "", "tags", "(Lorg/apache/solr/client/solrj/SolrQuery;Ljava/lang/String;Ljava/lang/Iterable;[Ljava/lang/String;)V", "escapeQueryChars", "input", "queryFieldWithBoost", "name", "boostFactor", "", "quote", "setFacetContains", "value", "setFacetFieldLimit", "limit", "", "LocalParam", "LocalParams", "people-api"})
@SourceDebugExtension(value={"SMAP\nSolrQueryHelper.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SolrQueryHelper.kt\nde/justsoftware/people/business/search/solr/SolrQueryHelper\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,118:1\n1549#2:119\n1620#2,3:120\n1549#2:123\n1620#2,3:124\n*S KotlinDebug\n*F\n+ 1 SolrQueryHelper.kt\nde/justsoftware/people/business/search/solr/SolrQueryHelper\n*L\n18#1:119\n18#1:120,3\n19#1:123\n19#1:124,3\n*E\n"})
public final class SolrQueryHelper {
    @NotNull
    public static final SolrQueryHelper INSTANCE = new SolrQueryHelper();

    private SolrQueryHelper() {
    }

    public final void addFilterQuery(@NotNull SolrQuery query, @NotNull String field, @NotNull Iterable<String> values, String ... tags) {
        String p0;
        Collection collection;
        Iterable $this$mapTo$iv$iv;
        Iterable $this$map$iv;
        Intrinsics.checkNotNullParameter((Object)query, (String)"query");
        Intrinsics.checkNotNullParameter((Object)field, (String)"field");
        Intrinsics.checkNotNullParameter(values, (String)"values");
        Intrinsics.checkNotNullParameter((Object)tags, (String)"tags");
        Iterable<String> iterable = values;
        Object[] objectArray = INSTANCE;
        boolean $i$f$map = false;
        void var9_8 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            String string = (String)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            collection.add(objectArray.escapeQueryChars(p0));
        }
        $this$map$iv = (List)destination$iv$iv;
        objectArray = INSTANCE;
        $i$f$map = false;
        $this$mapTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            p0 = (String)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            collection.add(super.quote(p0));
        }
        List escapedValues = (List)destination$iv$iv;
        objectArray = new LocalParam[]{new LocalParam("tag", Arrays.copyOf(tags, tags.length))};
        LocalParams localParams = new LocalParams(objectArray);
        objectArray = new String[]{localParams.toSolrQuery() + field + ":(" + CollectionsKt.joinToString$default((Iterable)escapedValues, (CharSequence)" OR ", null, null, (int)0, null, null, (int)62, null) + ")"};
        query.addFilterQuery((String[])objectArray);
    }

    public final void setFacetFieldLimit(@NotNull SolrQuery query, @NotNull String field, int limit) {
        Intrinsics.checkNotNullParameter((Object)query, (String)"query");
        Intrinsics.checkNotNullParameter((Object)field, (String)"field");
        query.set("f." + field + ".facet.limit", limit);
    }

    public final void setFacetContains(@NotNull SolrQuery query, @NotNull String field, @NotNull String value) {
        Intrinsics.checkNotNullParameter((Object)query, (String)"query");
        Intrinsics.checkNotNullParameter((Object)field, (String)"field");
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        String[] stringArray = new String[]{value};
        query.set("f." + field + ".facet.contains", stringArray);
    }

    @NotNull
    public final String queryFieldWithBoost(@NotNull String name, float boostFactor) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        return name + "^" + boostFactor;
    }

    public final void addFacetFieldWithExclusion(@NotNull SolrQuery query, @NotNull String field, @Nullable String facetKey, String ... exclusionFilter) {
        Intrinsics.checkNotNullParameter((Object)query, (String)"query");
        Intrinsics.checkNotNullParameter((Object)field, (String)"field");
        Intrinsics.checkNotNullParameter((Object)exclusionFilter, (String)"exclusionFilter");
        Object object = new LocalParam[]{new LocalParam("ex", Arrays.copyOf(exclusionFilter, exclusionFilter.length))};
        LocalParams localParams = new LocalParams((LocalParam[])object);
        object = facetKey;
        if (!(object == null || object.length() == 0)) {
            object = new String[]{facetKey};
            localParams.add(new LocalParam("key", (String[])object));
        }
        object = new String[]{localParams.toSolrQuery() + field};
        query.addFacetField((String[])object);
    }

    private final String escapeQueryChars(String input) {
        String string = ClientUtils.escapeQueryChars((String)input);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"escapeQueryChars(input)");
        return string;
    }

    private final String quote(String input) {
        return "\"" + input + "\"";
    }
}

