/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.people.business.search;

import de.justsoftware.kafka.client.KafkaCleaningProducer;
import de.justsoftware.people.business.event.ProfileTenantsUpdatedEvent;
import de.justsoftware.people.business.event.ProfilesDeletedEvent;
import de.justsoftware.people.business.event.ProfilesUpdatedEvent;
import de.justsoftware.people.business.event.UserGroupCreatedOrPublishedEvent;
import de.justsoftware.people.business.event.UserGroupDeletedEvent;
import de.justsoftware.people.business.event.UserGroupMembersUpdatedEvent;
import de.justsoftware.people.business.event.UserGroupRolesUpdatedEvent;
import de.justsoftware.people.business.event.UserGroupUpdatedEvent;
import de.justsoftware.people.business.profile.ProfileAttributeConfigService;
import de.justsoftware.people.business.profile.ProfileService;
import de.justsoftware.people.business.profile.model.Profile;
import de.justsoftware.people.business.profile.model.ProfileAttributeConfig;
import de.justsoftware.people.business.search.SearchService;
import de.justsoftware.people.business.search.VisibilityService;
import de.justsoftware.people.business.search.model.FacetFilter;
import de.justsoftware.people.business.search.model.SearchField;
import de.justsoftware.people.business.search.model.SearchFilter;
import de.justsoftware.people.business.search.model.SearchId;
import de.justsoftware.people.business.search.solr.SolrIntegration;
import de.justsoftware.people.business.search.solr.model.ProfileSearchReadModel;
import de.justsoftware.people.business.search.solr.model.SearchModel;
import de.justsoftware.people.business.search.solr.model.UserGroupSearchIndexModel;
import de.justsoftware.people.business.usergroup.UserGroupService;
import de.justsoftware.people.business.usergroup.model.UserGroup;
import de.justsoftware.people.model.PagedResult;
import de.justsoftware.people.model.ProfileId;
import de.justsoftware.people.model.TenantId;
import de.justsoftware.people.model.UserGroupId;
import de.justsoftware.people.utils.CollectionUtilsKt;
import de.justsoftware.permission.client.model.Role;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.apache.kafka.clients.consumer.ConsumerRecord;
import org.apache.kafka.clients.consumer.ConsumerRecords;
import org.apache.kafka.clients.producer.ProducerRecord;
import org.apache.kafka.clients.producer.RecordMetadata;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.event.EventListener;
import org.springframework.kafka.annotation.KafkaListener;
import org.springframework.stereotype.Service;

/*
 * Exception performing whole class analysis ignored.
 */
@Service
@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u00ec\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u001e\n\u0002\b\u0005\b\u0017\u0018\u0000 Z2\u00020\u0001:\u0001ZBC\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\u0014\b\u0001\u0010\f\u001a\u000e\u0012\u0004\u0012\u00020\u000e\u0012\u0004\u0012\u00020\u000e0\r\u00a2\u0006\u0002\u0010\u000fJ`\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u001a0\u00192\b\u0010\u001b\u001a\u0004\u0018\u00010\u001c2\u0006\u0010\u001d\u001a\u00020\u000e2\f\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\u001f0\u00112\f\u0010 \u001a\b\u0012\u0004\u0012\u00020\"0!2\b\u0010#\u001a\u0004\u0018\u00010$2\b\u0010%\u001a\u0004\u0018\u00010&2\u0006\u0010'\u001a\u00020(2\u0006\u0010)\u001a\u00020(H\u0016J>\u0010*\u001a\b\u0012\u0004\u0012\u00020+0\u00192\b\u0010\u001b\u001a\u0004\u0018\u00010\u001c2\u0006\u0010\u001d\u001a\u00020\u000e2\f\u0010 \u001a\b\u0012\u0004\u0012\u00020\"0!2\u0006\u0010'\u001a\u00020(2\u0006\u0010)\u001a\u00020(H\u0016J \u0010,\u001a\u0004\u0018\u00010\u001a2\u0006\u0010-\u001a\u00020.2\f\u0010 \u001a\b\u0012\u0004\u0012\u00020\"0!H\u0016J\u0016\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00120/2\u0006\u00100\u001a\u00020\u0016H\u0016J\u0015\u00101\u001a\u0002022\u0006\u00103\u001a\u000204H\u0011\u00a2\u0006\u0002\b5J\u0015\u00106\u001a\u0002022\u0006\u00103\u001a\u000207H\u0011\u00a2\u0006\u0002\b8J\u0015\u00109\u001a\u0002022\u0006\u00103\u001a\u00020:H\u0011\u00a2\u0006\u0002\b;J!\u0010<\u001a\u0002022\u0012\u0010=\u001a\u000e\u0012\u0004\u0012\u00020?\u0012\u0004\u0012\u00020\u000e0>H\u0011\u00a2\u0006\u0002\b@J\u0015\u0010A\u001a\u0002022\u0006\u00103\u001a\u00020BH\u0011\u00a2\u0006\u0002\bCJ\u0015\u0010D\u001a\u0002022\u0006\u00103\u001a\u00020EH\u0011\u00a2\u0006\u0002\bFJ\u0015\u0010G\u001a\u0002022\u0006\u00103\u001a\u00020HH\u0011\u00a2\u0006\u0002\bIJ\u0015\u0010J\u001a\u0002022\u0006\u00103\u001a\u00020KH\u0011\u00a2\u0006\u0002\bLJ\u0015\u0010M\u001a\u0002022\u0006\u00103\u001a\u00020NH\u0011\u00a2\u0006\u0002\bOJ\b\u0010P\u001a\u000202H\u0016JJ\u0010Q\u001a\b\u0012\u0004\u0012\u00020+0\u00192\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u000e2\f\u0010 \u001a\b\u0012\u0004\u0012\u00020\"0!2\f\u0010R\u001a\b\u0012\u0004\u0012\u00020\u000e0!2\u0006\u0010'\u001a\u00020(2\u0006\u0010)\u001a\u00020(H\u0016J\u0010\u0010S\u001a\u0002022\u0006\u0010T\u001a\u00020?H\u0012J\u0016\u0010S\u001a\u0002022\f\u0010U\u001a\b\u0012\u0004\u0012\u00020?0VH\u0012J\u001e\u0010W\u001a\u0002022\u0006\u0010X\u001a\u00020&2\f\u0010Y\u001a\b\u0012\u0004\u0012\u00020.0!H\u0012R\u001a\u0010\f\u001a\u000e\u0012\u0004\u0012\u00020\u000e\u0012\u0004\u0012\u00020\u000e0\rX\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00120\u00118VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0013\u0010\u0014R\u001a\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00160\u00118VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0017\u0010\u0014R\u000e\u0010\u0002\u001a\u00020\u0003X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0092\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006["}, d2={"Lde/justsoftware/people/business/search/SearchService;", "", "solrIntegration", "Lde/justsoftware/people/business/search/solr/SolrIntegration;", "profileAttributeConfigService", "Lde/justsoftware/people/business/profile/ProfileAttributeConfigService;", "profileService", "Lde/justsoftware/people/business/profile/ProfileService;", "userGroupService", "Lde/justsoftware/people/business/usergroup/UserGroupService;", "visibilityService", "Lde/justsoftware/people/business/search/VisibilityService;", "kafkaProducer", "Lde/justsoftware/kafka/client/KafkaCleaningProducer;", "", "(Lde/justsoftware/people/business/search/solr/SolrIntegration;Lde/justsoftware/people/business/profile/ProfileAttributeConfigService;Lde/justsoftware/people/business/profile/ProfileService;Lde/justsoftware/people/business/usergroup/UserGroupService;Lde/justsoftware/people/business/search/VisibilityService;Lde/justsoftware/kafka/client/KafkaCleaningProducer;)V", "searchConfiguration", "", "Lde/justsoftware/people/business/profile/model/ProfileAttributeConfig;", "getSearchConfiguration", "()Ljava/util/List;", "searchableFields", "Lde/justsoftware/people/business/search/model/SearchField;", "getSearchableFields", "allProfiles", "Lde/justsoftware/people/model/PagedResult;", "Lde/justsoftware/people/business/search/solr/model/ProfileSearchReadModel;", "tenantId", "Lde/justsoftware/people/model/TenantId;", "searchString", "searchFilter", "Lde/justsoftware/people/business/search/model/SearchFilter;", "searchRoles", "", "Lde/justsoftware/permission/client/model/Role;", "facetFilter", "Lde/justsoftware/people/business/search/model/FacetFilter;", "groupId", "Lde/justsoftware/people/model/UserGroupId;", "offset", "", "limit", "allProfilesAndUserGroups", "Lde/justsoftware/people/business/search/solr/model/SearchModel;", "findProfile", "profileId", "Lde/justsoftware/people/model/ProfileId;", "Ljava/util/Optional;", "searchField", "onProfileTenantsUpdatedEvent", "", "e", "Lde/justsoftware/people/business/event/ProfileTenantsUpdatedEvent;", "onProfileTenantsUpdatedEvent$people_api", "onProfilesDeletedEvent", "Lde/justsoftware/people/business/event/ProfilesDeletedEvent;", "onProfilesDeletedEvent$people_api", "onProfilesUpdatedEvent", "Lde/justsoftware/people/business/event/ProfilesUpdatedEvent;", "onProfilesUpdatedEvent$people_api", "onSearchIndex", "records", "Lorg/apache/kafka/clients/consumer/ConsumerRecords;", "Lde/justsoftware/people/business/search/model/SearchId;", "onSearchIndex$people_api", "onUserGroupCreatedOrPublishedEvent", "Lde/justsoftware/people/business/event/UserGroupCreatedOrPublishedEvent;", "onUserGroupCreatedOrPublishedEvent$people_api", "onUserGroupDeletedEvent", "Lde/justsoftware/people/business/event/UserGroupDeletedEvent;", "onUserGroupDeletedEvent$people_api", "onUserGroupMembersUpdatedEvent", "Lde/justsoftware/people/business/event/UserGroupMembersUpdatedEvent;", "onUserGroupMembersUpdatedEvent$people_api", "onUserGroupRolesUpdatedEvent", "Lde/justsoftware/people/business/event/UserGroupRolesUpdatedEvent;", "onUserGroupRolesUpdatedEvent$people_api", "onUserGroupUpdatedEvent", "Lde/justsoftware/people/business/event/UserGroupUpdatedEvent;", "onUserGroupUpdatedEvent$people_api", "reindexAllGroups", "searchInNames", "types", "send", "searchId", "searchIds", "", "updateUserGroupsAndMembers", "userGroupId", "memberIds", "Companion", "people-api"})
@SourceDebugExtension(value={"SMAP\nSearchService.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SearchService.kt\nde/justsoftware/people/business/search/SearchService\n+ 2 CollectionUtils.kt\nde/justsoftware/people/utils/CollectionUtilsKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,265:1\n17#2:266\n1620#3,3:267\n800#3,11:270\n800#3,11:281\n1549#3:292\n1620#3,3:293\n1549#3:296\n1620#3,3:297\n1855#3,2:300\n*S KotlinDebug\n*F\n+ 1 SearchService.kt\nde/justsoftware/people/business/search/SearchService\n*L\n167#1:266\n167#1:267,3\n168#1:270,11\n169#1:281,11\n176#1:292\n176#1:293,3\n183#1:296\n183#1:297,3\n240#1:300,2\n*E\n"})
public class SearchService {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final SolrIntegration solrIntegration;
    @NotNull
    private final ProfileAttributeConfigService profileAttributeConfigService;
    @NotNull
    private final ProfileService profileService;
    @NotNull
    private final UserGroupService userGroupService;
    @NotNull
    private final VisibilityService visibilityService;
    @NotNull
    private final KafkaCleaningProducer<String, String> kafkaProducer;
    @NotNull
    public static final String SEARCH_INDEX_TOPIC = "just.people.search.index";
    @NotNull
    public static final String SEARCH_INDEX_LISTENER_ID = "SearchIndexConsumer";
    private static final Logger LOG = LoggerFactory.getLogger(SearchService.class);

    public SearchService(@NotNull SolrIntegration solrIntegration, @NotNull ProfileAttributeConfigService profileAttributeConfigService, @NotNull ProfileService profileService, @NotNull UserGroupService userGroupService, @NotNull VisibilityService visibilityService, @Qualifier(value="KAFKA_STRING_PRODUCER") @NotNull KafkaCleaningProducer<String, String> kafkaProducer) {
        Intrinsics.checkNotNullParameter((Object)solrIntegration, (String)"solrIntegration");
        Intrinsics.checkNotNullParameter((Object)profileAttributeConfigService, (String)"profileAttributeConfigService");
        Intrinsics.checkNotNullParameter((Object)profileService, (String)"profileService");
        Intrinsics.checkNotNullParameter((Object)userGroupService, (String)"userGroupService");
        Intrinsics.checkNotNullParameter((Object)visibilityService, (String)"visibilityService");
        Intrinsics.checkNotNullParameter(kafkaProducer, (String)"kafkaProducer");
        this.solrIntegration = solrIntegration;
        this.profileAttributeConfigService = profileAttributeConfigService;
        this.profileService = profileService;
        this.userGroupService = userGroupService;
        this.visibilityService = visibilityService;
        this.kafkaProducer = kafkaProducer;
    }

    @NotNull
    public PagedResult<ProfileSearchReadModel> allProfiles(@Nullable TenantId tenantId, @NotNull String searchString, @NotNull List<? extends SearchFilter> searchFilter, @NotNull Set<Role> searchRoles, @Nullable FacetFilter facetFilter, @Nullable UserGroupId groupId, int offset, int limit) {
        Intrinsics.checkNotNullParameter((Object)searchString, (String)"searchString");
        Intrinsics.checkNotNullParameter(searchFilter, (String)"searchFilter");
        Intrinsics.checkNotNullParameter(searchRoles, (String)"searchRoles");
        return this.solrIntegration.allProfiles(tenantId, searchString, searchFilter, searchRoles, facetFilter, groupId, offset, limit);
    }

    @NotNull
    public PagedResult<SearchModel> allProfilesAndUserGroups(@Nullable TenantId tenantId, @NotNull String searchString, @NotNull Set<Role> searchRoles, int offset, int limit) {
        Intrinsics.checkNotNullParameter((Object)searchString, (String)"searchString");
        Intrinsics.checkNotNullParameter(searchRoles, (String)"searchRoles");
        return this.solrIntegration.allProfilesAndUserGroups(tenantId, searchString, searchRoles, offset, limit);
    }

    @Nullable
    public ProfileSearchReadModel findProfile(@NotNull ProfileId profileId, @NotNull Set<Role> searchRoles) {
        Intrinsics.checkNotNullParameter((Object)profileId, (String)"profileId");
        Intrinsics.checkNotNullParameter(searchRoles, (String)"searchRoles");
        return this.solrIntegration.findProfile(profileId, searchRoles);
    }

    @NotNull
    public PagedResult<SearchModel> searchInNames(@NotNull TenantId tenantId, @NotNull String searchString, @NotNull Set<Role> searchRoles, @NotNull Set<String> types, int offset, int limit) {
        Intrinsics.checkNotNullParameter((Object)tenantId, (String)"tenantId");
        Intrinsics.checkNotNullParameter((Object)searchString, (String)"searchString");
        Intrinsics.checkNotNullParameter(searchRoles, (String)"searchRoles");
        Intrinsics.checkNotNullParameter(types, (String)"types");
        return this.solrIntegration.searchInNames(tenantId, searchString, searchRoles, types, offset, limit);
    }

    @NotNull
    public List<SearchField> getSearchableFields() {
        return this.profileAttributeConfigService.searchFields();
    }

    @NotNull
    public List<ProfileAttributeConfig> getSearchConfiguration() {
        return CollectionsKt.toList((Iterable)this.profileAttributeConfigService.getConfiguration().values());
    }

    @NotNull
    public Optional<ProfileAttributeConfig> getSearchConfiguration(@NotNull SearchField searchField) {
        Intrinsics.checkNotNullParameter((Object)searchField, (String)"searchField");
        return this.profileAttributeConfigService.configFor(searchField);
    }

    public void reindexAllGroups() {
        this.solrIntegration.deleteAllUserGroups();
        this.userGroupService.forAllUserGroups(arg_0 -> SearchService.reindexAllGroups$lambda$0(this, arg_0));
    }

    /*
     * WARNING - void declaration
     */
    @KafkaListener(id="SearchIndexConsumer", containerFactory="searchIndexQueueConsumerFactory", topics={"just.people.search.index"}, idIsGroup=false)
    public void onSearchIndex$people_api(@NotNull ConsumerRecords<SearchId, String> records) {
        void $this$mapTo$iv$iv;
        void $this$mapTo$iv$iv2;
        void $this$filterIsInstanceTo$iv$iv;
        void $this$filterIsInstanceTo$iv$iv2;
        Collection collection;
        void $this$mapTo$iv$iv3;
        Intrinsics.checkNotNullParameter(records, (String)"records");
        LOG.debug("Update Solr for {} records", (Object)records.count());
        Iterable $this$mapToSet$iv = (Iterable)records;
        boolean $i$f$mapToSet = false;
        Iterable iterable = $this$mapToSet$iv;
        Iterable destination$iv$iv = new LinkedHashSet(CollectionUtilsKt.getDefaultSize((Iterable)$this$mapToSet$iv));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv3) {
            void p0;
            ConsumerRecord consumerRecord = (ConsumerRecord)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            collection.add((SearchId)p0.key());
        }
        Set searchIds = (Set)destination$iv$iv;
        Iterable $this$filterIsInstance$iv = searchIds;
        boolean $i$f$filterIsInstance = false;
        destination$iv$iv = $this$filterIsInstance$iv;
        Iterable destination$iv$iv2 = new ArrayList();
        boolean $i$f$filterIsInstanceTo = false;
        for (Object element$iv$iv : $this$filterIsInstanceTo$iv$iv2) {
            if (!(element$iv$iv instanceof ProfileId)) continue;
            destination$iv$iv2.add(element$iv$iv);
        }
        Set profileIds = CollectionsKt.toSet((Iterable)((List)destination$iv$iv2));
        Iterable $this$filterIsInstance$iv2 = searchIds;
        boolean $i$f$filterIsInstance2 = false;
        destination$iv$iv2 = $this$filterIsInstance$iv2;
        Collection destination$iv$iv3 = new ArrayList();
        boolean $i$f$filterIsInstanceTo2 = false;
        for (Object element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
            if (!(element$iv$iv instanceof UserGroupId)) continue;
            destination$iv$iv3.add(element$iv$iv);
        }
        Set userGroupIds = CollectionsKt.toSet((Iterable)((List)destination$iv$iv3));
        Map visibilities = this.visibilityService.visibilities(searchIds);
        Map profiles = this.profileService.findUndeletedProfileByIds((Iterable)profileIds);
        Map profileTenants = this.profileService.findTenantsByProfileIds((Iterable)profiles.keySet());
        Map profileUserGroupIds = this.userGroupService.getUserGroupsForProfiles(profiles.keySet());
        Map userGroups = this.userGroupService.findAllByIds(userGroupIds);
        Set deletedSearchIds = SetsKt.minus((Set)SetsKt.minus((Set)searchIds, (Iterable)profiles.keySet()), (Iterable)userGroups.keySet());
        Iterable $this$map$iv = profiles.values();
        boolean $i$f$map = false;
        Iterable iterable2 = $this$map$iv;
        Iterable destination$iv$iv4 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo2 = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv2) {
            void it;
            Profile profile = (Profile)item$iv$iv;
            collection = destination$iv$iv4;
            boolean bl = false;
            List list = (List)profileUserGroupIds.get(it.getId());
            List list2 = (List)profileTenants.get(it.getId());
            Collection collection2 = (Collection)visibilities.get(it.getId());
            collection.add(Profile.Companion.toProfileSearchIndexModel((Profile)it, list != null ? CollectionsKt.toSet((Iterable)list) : null, list2 != null ? CollectionsKt.toSet((Iterable)list2) : null, collection2 != null ? CollectionsKt.toSet((Iterable)collection2) : null));
        }
        List profileSearchIndexModels = (List)destination$iv$iv4;
        Iterable $this$map$iv2 = userGroups.values();
        boolean $i$f$map2 = false;
        destination$iv$iv4 = $this$map$iv2;
        Collection destination$iv$iv5 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv2, (int)10));
        boolean $i$f$mapTo3 = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            UserGroup bl = (UserGroup)item$iv$iv;
            collection = destination$iv$iv5;
            boolean bl2 = false;
            UserGroupId userGroupId = it.getId();
            String string = it.getName();
            TenantId tenantId = it.getTenantId();
            boolean bl3 = it.isImported();
            boolean bl4 = it.isAllTenantUsers();
            Collection collection3 = (Collection)visibilities.get(it.getId());
            if (collection3 == null || (collection3 = CollectionsKt.toSet((Iterable)collection3)) == null) {
                collection3 = SetsKt.emptySet();
            }
            collection.add(new UserGroupSearchIndexModel(userGroupId, string, tenantId, bl3, bl4, (Set)collection3));
        }
        List userGroupSearchIndexModel = (List)destination$iv$iv5;
        this.solrIntegration.delete(deletedSearchIds);
        this.solrIntegration.index((Iterable)CollectionsKt.plus((Collection)profileSearchIndexModels, (Iterable)userGroupSearchIndexModel));
        Object[] objectArray = new Object[]{profileSearchIndexModels.size(), userGroupSearchIndexModel.size(), deletedSearchIds.size()};
        LOG.info("Updating Solr with {} profiles and {} groups. Deleting {} profiles and groups.", objectArray);
    }

    @EventListener
    public void onProfilesUpdatedEvent$people_api(@NotNull ProfilesUpdatedEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        this.send((Collection)e.getProfileIds());
    }

    @EventListener
    public void onProfilesDeletedEvent$people_api(@NotNull ProfilesDeletedEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        this.send((Collection)e.getProfileIds());
    }

    @EventListener
    public void onProfileTenantsUpdatedEvent$people_api(@NotNull ProfileTenantsUpdatedEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        this.send((Collection)e.getUpdatedProfileTenants().keySet());
    }

    @EventListener
    public void onUserGroupCreatedOrPublishedEvent$people_api(@NotNull UserGroupCreatedOrPublishedEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        this.send((SearchId)e.getUserGroupId());
    }

    @EventListener
    public void onUserGroupUpdatedEvent$people_api(@NotNull UserGroupUpdatedEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        this.send((SearchId)e.getUserGroupId());
    }

    @EventListener
    public void onUserGroupDeletedEvent$people_api(@NotNull UserGroupDeletedEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        this.updateUserGroupsAndMembers(e.getUserGroupId(), e.getGroupMembers());
    }

    @EventListener
    public void onUserGroupMembersUpdatedEvent$people_api(@NotNull UserGroupMembersUpdatedEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        this.updateUserGroupsAndMembers(e.getUserGroupId(), SetsKt.plus((Set)e.getAddedMembers(), (Iterable)e.getDeletedMembers()));
    }

    @EventListener
    public void onUserGroupRolesUpdatedEvent$people_api(@NotNull UserGroupRolesUpdatedEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        this.updateUserGroupsAndMembers(e.getUserGroupId(), e.getGroupMembers());
    }

    private void updateUserGroupsAndMembers(UserGroupId userGroupId, Set<ProfileId> memberIds) {
        this.send((Collection)SetsKt.plus((Set)SetsKt.setOf((Object)userGroupId), (Iterable)memberIds));
    }

    private void send(Collection<? extends SearchId> searchIds) {
        Iterable $this$forEach$iv = searchIds;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            SearchId p0 = (SearchId)element$iv;
            boolean bl = false;
            this.send(p0);
        }
    }

    private void send(SearchId searchId) {
        this.kafkaProducer.send(new ProducerRecord("just.people.search.index", (Object)searchId.toCanonicalId(), (Object)""), SearchService::send$lambda$4);
    }

    private static final void reindexAllGroups$lambda$0(SearchService this$0, UserGroup userGroup) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)userGroup, (String)"userGroup");
        this$0.send((SearchId)userGroup.getId());
    }

    private static final void send$lambda$4(RecordMetadata metadata, Exception exception) {
        Intrinsics.checkNotNullParameter((Object)metadata, (String)"metadata");
        Companion.access$logErrorCallback((Companion)Companion, (RecordMetadata)metadata, (Exception)exception);
    }

    public static final /* synthetic */ Logger access$getLOG$cp() {
        return LOG;
    }
}

