/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.people.business.profile;

import com.google.common.base.Enums;
import de.justsoftware.people.business.profile.AttributeNameValidator;
import de.justsoftware.people.business.profile.ProfileAttributeConfigService;
import de.justsoftware.people.business.profile.model.ProfileAttributeConfig;
import de.justsoftware.people.business.profile.model.ProfileAttributeConfigKafkaModel;
import de.justsoftware.people.business.search.model.SearchField;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import org.apache.kafka.clients.consumer.ConsumerRecord;
import org.apache.kafka.clients.consumer.ConsumerRecords;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.kafka.annotation.KafkaListener;
import org.springframework.stereotype.Service;

@Service
@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0017\u0018\u0000 \u001d2\u00020\u0001:\u0001\u001dB\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u0005H\u0016J\u0016\u0010\r\u001a\u00020\u000b2\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00050\u000fH\u0016J\u0016\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00060\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0016J\u000e\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00130\u000fH\u0016J'\u0010\u0015\u001a\u00020\u00162\u0018\u0010\u0017\u001a\u0014\u0012\u0004\u0012\u00020\u0005\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u001a0\u00190\u0018H\u0011\u00a2\u0006\u0002\b\u001bJ\u000e\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u00130\u000fH\u0016R6\u0010\u0007\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00060\u00042\u0012\u0010\u0003\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00060\u0004@RX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\t\u00a8\u0006\u001e"}, d2={"Lde/justsoftware/people/business/profile/ProfileAttributeConfigService;", "Lde/justsoftware/people/business/profile/AttributeNameValidator;", "()V", "<set-?>", "", "", "Lde/justsoftware/people/business/profile/model/ProfileAttributeConfig;", "configuration", "getConfiguration", "()Ljava/util/Map;", "attributeNameIsValid", "", "attributeName", "attributeNamesAreValid", "attributeNames", "", "configFor", "Ljava/util/Optional;", "searchField", "Lde/justsoftware/people/business/search/model/SearchField;", "facetableFields", "listen", "", "records", "Lorg/apache/kafka/clients/consumer/ConsumerRecords;", "", "Lde/justsoftware/people/business/profile/model/ProfileAttributeConfigKafkaModel;", "listen$people_api", "searchFields", "Companion", "people-api"})
@SourceDebugExtension(value={"SMAP\nProfileAttributeConfigService.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ProfileAttributeConfigService.kt\nde/justsoftware/people/business/profile/ProfileAttributeConfigService\n+ 2 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,113:1\n8676#2,2:114\n9358#2,4:116\n766#3:120\n857#3,2:121\n1549#3:123\n1620#3,3:124\n766#3:127\n857#3,2:128\n1549#3:130\n1620#3,3:131\n766#3:134\n857#3,2:135\n1549#3:137\n1620#3,3:138\n766#3:141\n857#3,2:142\n1549#3:144\n1620#3,3:145\n*S KotlinDebug\n*F\n+ 1 ProfileAttributeConfigService.kt\nde/justsoftware/people/business/profile/ProfileAttributeConfigService\n*L\n30#1:114,2\n30#1:116,4\n76#1:120\n76#1:121,2\n77#1:123\n77#1:124,3\n78#1:127\n78#1:128,2\n79#1:130\n79#1:131,3\n86#1:134\n86#1:135,2\n87#1:137\n87#1:138,3\n88#1:141\n88#1:142,2\n89#1:144\n89#1:145,3\n*E\n"})
public class ProfileAttributeConfigService
implements AttributeNameValidator {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private Map<String, ? extends ProfileAttributeConfig> configuration = MapsKt.emptyMap();
    @NotNull
    public static final String TOPIC = "just.persons.profileAttributesConfig";
    @NotNull
    private static final String DEFAULT_CONFIG_KEY = "DEFAULT";
    private static final Logger LOG = LoggerFactory.getLogger(ProfileAttributeConfigService.class);

    @NotNull
    public final Map<String, ProfileAttributeConfig> getConfiguration() {
        return this.configuration;
    }

    /*
     * WARNING - void declaration
     */
    @KafkaListener(containerFactory="profileAttributeConfigurationListenerContainerFactory", topics={"just.persons.profileAttributesConfig"})
    public void listen$people_api(@NotNull ConsumerRecords<String, ProfileAttributeConfigKafkaModel[]> records) {
        Intrinsics.checkNotNullParameter(records, (String)"records");
        for (ConsumerRecord record : records) {
            Object object;
            try {
                void $this$associateTo$iv$iv;
                if (!Intrinsics.areEqual((Object)DEFAULT_CONFIG_KEY, (Object)record.key())) continue;
                Object object2 = record.value();
                Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"record.value()");
                Object[] $this$associate$iv = (Object[])object2;
                boolean $i$f$associate = false;
                int capacity$iv = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)$this$associate$iv.length), (int)16);
                Object[] objectArray = $this$associate$iv;
                Map destination$iv$iv = new LinkedHashMap(capacity$iv);
                boolean $i$f$associateTo = false;
                for (void element$iv$iv : $this$associateTo$iv$iv) {
                    SearchField searchField;
                    Map map = destination$iv$iv;
                    ProfileAttributeConfigKafkaModel it = (ProfileAttributeConfigKafkaModel)element$iv$iv;
                    boolean bl = false;
                    String string = it.getName();
                    ProfileAttributeConfig.AttributeType attributeType = (ProfileAttributeConfig.AttributeType)Enums.getIfPresent(ProfileAttributeConfig.AttributeType.class, (String)it.getType()).or((Object)ProfileAttributeConfig.AttributeType.UNKNOWN);
                    String string2 = it.getName();
                    boolean bl2 = it.isVisibleOnBadge();
                    boolean bl3 = it.isSearchable();
                    boolean bl4 = it.isFacetable();
                    boolean bl5 = it.isClickable();
                    boolean bl6 = it.isPhoneNumber();
                    if (it.isSearchable()) {
                        String string3 = it.getName();
                        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"it.name");
                        searchField = SearchField.Companion.dynamic(string3, it.isPhoneNumber(), it.isSearchable());
                    } else {
                        searchField = null;
                    }
                    Pair pair = TuplesKt.to((Object)string, (Object)new ProfileAttributeConfig(attributeType, string2, bl2, bl3, bl4, bl5, bl6, searchField, it.getTranslatedValues()));
                    map.put(pair.getFirst(), pair.getSecond());
                }
                Map newConfig = MapsKt.toMutableMap((Map)destination$iv$iv);
                object = newConfig;
                String string = ProfileAttributeConfig.FIRST_NAME.getName();
                ProfileAttributeConfig profileAttributeConfig = ProfileAttributeConfig.FIRST_NAME;
                Intrinsics.checkNotNullExpressionValue((Object)profileAttributeConfig, (String)"FIRST_NAME");
                ProfileAttributeConfig profileAttributeConfig2 = profileAttributeConfig;
                object.put(string, profileAttributeConfig2);
                object = newConfig;
                string = ProfileAttributeConfig.LAST_NAME.getName();
                ProfileAttributeConfig profileAttributeConfig3 = ProfileAttributeConfig.LAST_NAME;
                Intrinsics.checkNotNullExpressionValue((Object)profileAttributeConfig3, (String)"LAST_NAME");
                profileAttributeConfig2 = profileAttributeConfig3;
                object.put(string, profileAttributeConfig2);
                object = newConfig;
                string = ProfileAttributeConfig.TITLE.getName();
                ProfileAttributeConfig profileAttributeConfig4 = ProfileAttributeConfig.TITLE;
                Intrinsics.checkNotNullExpressionValue((Object)profileAttributeConfig4, (String)"TITLE");
                profileAttributeConfig2 = profileAttributeConfig4;
                object.put(string, profileAttributeConfig2);
                object = newConfig;
                string = ProfileAttributeConfig.ADDITIONAL_TITLE.getName();
                ProfileAttributeConfig profileAttributeConfig5 = ProfileAttributeConfig.ADDITIONAL_TITLE;
                Intrinsics.checkNotNullExpressionValue((Object)profileAttributeConfig5, (String)"ADDITIONAL_TITLE");
                profileAttributeConfig2 = profileAttributeConfig5;
                object.put(string, profileAttributeConfig2);
                this.configuration = MapsKt.toMap((Map)newConfig);
            }
            catch (RuntimeException e) {
                object = new Object[]{record.key(), record.value(), e.getMessage()};
                LOG.error("Failed to process profile attribute config record with {} = {} - {}", (Object[])object);
            }
        }
    }

    @NotNull
    public List<SearchField> searchFields() {
        Collection collection;
        Iterable $this$mapTo$iv$iv;
        Object it;
        Iterable $this$filterTo$iv$iv;
        Iterable $this$filter$iv = this.configuration.values();
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            it = (ProfileAttributeConfig)element$iv$iv;
            boolean bl = false;
            if (!it.isSearchable()) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Iterable $this$map$iv = (List)destination$iv$iv;
        boolean $i$f$map = false;
        $this$filterTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            it = (ProfileAttributeConfig)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            collection.add(it.getSearchField());
        }
        $this$filter$iv = (List)destination$iv$iv;
        $i$f$filter = false;
        $this$mapTo$iv$iv = $this$filter$iv;
        destination$iv$iv = new ArrayList();
        $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            it = (Optional)element$iv$iv;
            boolean bl = false;
            if (!((Optional)it).isPresent()) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $this$map$iv = (List)destination$iv$iv;
        $i$f$map = false;
        $this$filterTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            it = (Optional)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            collection.add((SearchField)((Optional)it).get());
        }
        return (List)destination$iv$iv;
    }

    @NotNull
    public List<SearchField> facetableFields() {
        Collection collection;
        Iterable $this$mapTo$iv$iv;
        Object it;
        Iterable $this$filterTo$iv$iv;
        Iterable $this$filter$iv = this.configuration.values();
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            it = (ProfileAttributeConfig)element$iv$iv;
            boolean bl = false;
            if (!it.isFacetable()) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Iterable $this$map$iv = (List)destination$iv$iv;
        boolean $i$f$map = false;
        $this$filterTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            it = (ProfileAttributeConfig)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            collection.add(it.getSearchField());
        }
        $this$filter$iv = (List)destination$iv$iv;
        $i$f$filter = false;
        $this$mapTo$iv$iv = $this$filter$iv;
        destination$iv$iv = new ArrayList();
        $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            it = (Optional)element$iv$iv;
            boolean bl = false;
            if (!((Optional)it).isPresent()) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $this$map$iv = (List)destination$iv$iv;
        $i$f$map = false;
        $this$filterTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            it = (Optional)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            collection.add((SearchField)((Optional)it).get());
        }
        return (List)destination$iv$iv;
    }

    @NotNull
    public Optional<ProfileAttributeConfig> configFor(@NotNull SearchField searchField) {
        Intrinsics.checkNotNullParameter((Object)searchField, (String)"searchField");
        Optional<ProfileAttributeConfig> optional = Optional.ofNullable(this.configuration.get(searchField.getAttributeName()));
        Intrinsics.checkNotNullExpressionValue(optional, (String)"ofNullable(configuration\u2026archField.attributeName])");
        return optional;
    }

    public boolean attributeNamesAreValid(@NotNull List<String> attributeNames) {
        Intrinsics.checkNotNullParameter(attributeNames, (String)"attributeNames");
        return this.configuration.keySet().containsAll((Collection)attributeNames);
    }

    public boolean attributeNameIsValid(@NotNull String attributeName) {
        Intrinsics.checkNotNullParameter((Object)attributeName, (String)"attributeName");
        return this.configuration.containsKey(attributeName);
    }
}

