/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.people.business.externallink;

import de.justsoftware.people.business.externallink.ExternalLinkParser;
import de.justsoftware.people.business.externallink.model.ExternalLinkConfig;
import de.justsoftware.people.business.externallink.model.LinkConfigCreateModel;
import de.justsoftware.people.business.externallink.model.ValidExternalLink;
import de.justsoftware.people.business.externallink.model.ValidLinkInsertModel;
import de.justsoftware.people.business.profile.AttributeNameValidator;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.apache.commons.text.StringSubstitutor;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.springframework.stereotype.Service;

@Service
@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\b\u0017\u0018\u0000 \u00182\u00020\u0001:\u0001\u0018B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0016\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t2\u0006\u0010\u000b\u001a\u00020\nH\u0012J&\u0010\f\u001a\u0004\u0018\u00010\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0012\u0010\u0010\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\n0\u0011H\u0016J\u0010\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015H\u0016J\f\u0010\u0016\u001a\u00020\u0017*\u00020\nH\u0012R\u000e\u0010\u0002\u001a\u00020\u0003X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0005\u001a\n \u0007*\u0004\u0018\u00010\u00060\u0006X\u0092\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0019"}, d2={"Lde/justsoftware/people/business/externallink/ExternalLinkParser;", "", "attributeNameValidator", "Lde/justsoftware/people/business/profile/AttributeNameValidator;", "(Lde/justsoftware/people/business/profile/AttributeNameValidator;)V", "tokenMatchPattern", "Ljava/util/regex/Pattern;", "kotlin.jvm.PlatformType", "getPlaceholderAttributes", "", "", "input", "linkFromConfig", "Lde/justsoftware/people/business/externallink/model/ValidExternalLink;", "linkConfig", "Lde/justsoftware/people/business/externallink/model/ExternalLinkConfig;", "insertValues", "", "parseAndValidateCreateModel", "Lde/justsoftware/people/business/externallink/model/ValidLinkInsertModel;", "createModel", "Lde/justsoftware/people/business/externallink/model/LinkConfigCreateModel;", "hasDanglingDelimiters", "", "Companion", "people-api"})
@SourceDebugExtension(value={"SMAP\nExternalLinkParser.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ExternalLinkParser.kt\nde/justsoftware/people/business/externallink/ExternalLinkParser\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,97:1\n1#2:98\n*E\n"})
public class ExternalLinkParser {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final AttributeNameValidator attributeNameValidator;
    private final Pattern tokenMatchPattern;
    @NotNull
    private static final String TOKEN_START = "{";
    @NotNull
    private static final String TOKEN_END = "}";

    public ExternalLinkParser(@NotNull AttributeNameValidator attributeNameValidator) {
        Intrinsics.checkNotNullParameter((Object)attributeNameValidator, (String)"attributeNameValidator");
        this.attributeNameValidator = attributeNameValidator;
        this.tokenMatchPattern = Pattern.compile("(?<=\\{)(\\w+)(?=})");
    }

    @NotNull
    public ValidLinkInsertModel parseAndValidateCreateModel(@NotNull LinkConfigCreateModel createModel) {
        Intrinsics.checkNotNullParameter((Object)createModel, (String)"createModel");
        String uri = createModel.getUri();
        if (!(!StringsKt.isBlank((CharSequence)uri))) {
            boolean $i$a$-require-ExternalLinkParser$parseAndValidateCreateModel$42 = false;
            String $i$a$-require-ExternalLinkParser$parseAndValidateCreateModel$42 = "A uri can not be blank.";
            throw new IllegalArgumentException($i$a$-require-ExternalLinkParser$parseAndValidateCreateModel$42.toString());
        }
        if (!(!this.hasDanglingDelimiters(uri))) {
            boolean bl = false;
            String string = "The URI '" + uri + "' contains dangling placeholder delimiters.";
            throw new IllegalArgumentException(string.toString());
        }
        List placeholderAttributes = this.getPlaceholderAttributes(uri);
        if (!this.attributeNameValidator.attributeNamesAreValid(placeholderAttributes)) {
            boolean bl = false;
            String string = "The parsed list of placeholders '[" + CollectionsKt.joinToString$default((Iterable)placeholderAttributes, (CharSequence)",", null, null, (int)0, null, null, (int)62, null) + "]' contained invalid entries.";
            throw new IllegalArgumentException(string.toString());
        }
        return new ValidLinkInsertModel(uri, createModel.getDescription());
    }

    @Nullable
    public ValidExternalLink linkFromConfig(@NotNull ExternalLinkConfig linkConfig, @NotNull Map<String, String> insertValues) {
        Intrinsics.checkNotNullParameter((Object)linkConfig, (String)"linkConfig");
        Intrinsics.checkNotNullParameter(insertValues, (String)"insertValues");
        StringSubstitutor substitutor = new StringSubstitutor(insertValues, TOKEN_START, TOKEN_END);
        String uri = substitutor.replace(linkConfig.getPlaceholderUri());
        Intrinsics.checkNotNullExpressionValue((Object)uri, (String)"uri");
        List unfilledPlaceholders = this.getPlaceholderAttributes(uri);
        return !((Collection)unfilledPlaceholders).isEmpty() ? null : new ValidExternalLink(uri, linkConfig.getDescription());
    }

    private List<String> getPlaceholderAttributes(String input) {
        Matcher tokenMatcher = this.tokenMatchPattern.matcher(input);
        ArrayList<String> result = new ArrayList<String>();
        while (tokenMatcher.find()) {
            result.add(tokenMatcher.group());
        }
        return result;
    }

    private boolean hasDanglingDelimiters(String $this$hasDanglingDelimiters) {
        long endDelimitersCount;
        long startDelimitersCount = $this$hasDanglingDelimiters.chars().filter(ExternalLinkParser::hasDanglingDelimiters$lambda$3).count();
        return startDelimitersCount != (endDelimitersCount = $this$hasDanglingDelimiters.chars().filter(ExternalLinkParser::hasDanglingDelimiters$lambda$4).count());
    }

    private static final boolean hasDanglingDelimiters$lambda$3(int c) {
        return c == 123;
    }

    private static final boolean hasDanglingDelimiters$lambda$4(int c) {
        return c == 125;
    }
}

