/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.wikiservice.kafka;

import de.justsoftware.wikiservice.business.DeletionService;
import de.justsoftware.wikiservice.kafka.AbstractKafkaConsumer;
import de.justsoftware.wikiservice.kafka.KafkaConsumerContext;
import de.justsoftware.wikiservice.kafka.TenantsKafkaConsumer;
import de.justsoftware.wikiservice.model.TenantId;
import java.time.Instant;
import kotlin.Metadata;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.apache.kafka.clients.consumer.ConsumerRecord;
import org.apache.kafka.clients.consumer.ConsumerRecords;
import org.apache.kafka.common.record.TimestampType;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;

@Component
@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0017\u0018\u0000 \u00162\u0010\u0012\u0004\u0012\u00020\u0002\u0012\u0006\u0012\u0004\u0018\u00010\u00020\u0001:\u0001\u0016B#\b\u0007\u0012\b\b\u0001\u0010\u0003\u001a\u00020\u0002\u0012\b\b\u0001\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ+\u0010\u000f\u001a\u00020\u00102\u0014\u0010\u0011\u001a\u0010\u0012\u0004\u0012\u00020\u0002\u0012\u0006\u0012\u0004\u0018\u00010\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0010\u00a2\u0006\u0002\b\u0015R\u000e\u0010\u0003\u001a\u00020\u0002X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\t\u001a\u00020\n8TX\u0094\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\fR\u0016\u0010\r\u001a\n \u000e*\u0004\u0018\u00010\n0\nX\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0092\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Lde/justsoftware/wikiservice/kafka/TenantsKafkaConsumer;", "Lde/justsoftware/wikiservice/kafka/AbstractKafkaConsumer;", "", "bootstrapServers", "maxChunkSize", "", "deletionService", "Lde/justsoftware/wikiservice/business/DeletionService;", "(Ljava/lang/String;ILde/justsoftware/wikiservice/business/DeletionService;)V", "log", "Lorg/slf4j/Logger;", "getLog", "()Lorg/slf4j/Logger;", "logger", "kotlin.jvm.PlatformType", "process", "", "records", "Lorg/apache/kafka/clients/consumer/ConsumerRecords;", "context", "Lde/justsoftware/wikiservice/kafka/KafkaConsumerContext;", "process$wiki_service", "Companion", "wiki-service"})
@SourceDebugExtension(value={"SMAP\nTenantsKafkaConsumer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TenantsKafkaConsumer.kt\nde/justsoftware/wikiservice/kafka/TenantsKafkaConsumer\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,87:1\n1855#2,2:88\n*S KotlinDebug\n*F\n+ 1 TenantsKafkaConsumer.kt\nde/justsoftware/wikiservice/kafka/TenantsKafkaConsumer\n*L\n38#1:88,2\n*E\n"})
public class TenantsKafkaConsumer
extends AbstractKafkaConsumer<String, String> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final String bootstrapServers;
    private final int maxChunkSize;
    @NotNull
    private final DeletionService deletionService;
    private final Logger logger;
    @NotNull
    public static final String topic = "just.tenants";

    @Autowired
    public TenantsKafkaConsumer(@Value(value="${kafka.bootstrapServers:localhost:9092}") @NotNull String bootstrapServers, @Value(value="${kafka.consumerMaxChunkSize:100}") int maxChunkSize, @NotNull DeletionService deletionService) {
        Intrinsics.checkNotNullParameter((Object)bootstrapServers, (String)"bootstrapServers");
        Intrinsics.checkNotNullParameter((Object)deletionService, (String)"deletionService");
        super(Companion.createConsumer(bootstrapServers, maxChunkSize), SetsKt.setOf((Object)topic));
        this.bootstrapServers = bootstrapServers;
        this.maxChunkSize = maxChunkSize;
        this.deletionService = deletionService;
        this.logger = LoggerFactory.getLogger(TenantsKafkaConsumer.class);
    }

    @NotNull
    protected Logger getLog() {
        Logger logger = this.logger;
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"logger");
        return logger;
    }

    public void process$wiki_service(@NotNull ConsumerRecords<String, String> records, @NotNull KafkaConsumerContext context) {
        Intrinsics.checkNotNullParameter(records, (String)"records");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Iterable $this$forEach$iv = (Iterable)records;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            ConsumerRecord record = (ConsumerRecord)element$iv;
            boolean bl = false;
            try {
                if (record.value() != null || record.timestampType() != TimestampType.CREATE_TIME) continue;
                Instant recordCreatedAt = Instant.ofEpochMilli(record.timestamp());
                Object object = record.key();
                Intrinsics.checkNotNullExpressionValue((Object)object, (String)"record.key()");
                TenantId tenantId = new TenantId((String)object);
                Intrinsics.checkNotNullExpressionValue((Object)recordCreatedAt, (String)"recordCreatedAt");
                this.deletionService.deleteWikisInTenant(tenantId, recordCreatedAt);
            }
            catch (RuntimeException e) {
                this.logger.error("Failed to process TenantId changes with key = " + record.key() + ". Skip this record.", (Throwable)e);
            }
        }
    }
}

