/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.wikiservice.graphql.fetchers;

import de.justsoftware.wikiservice.application.ArticleApplicationService;
import de.justsoftware.wikiservice.business.model.ArticleDto;
import de.justsoftware.wikiservice.business.model.ArticleVersionDto;
import de.justsoftware.wikiservice.business.model.ArticleWithTitleDto;
import de.justsoftware.wikiservice.business.model.ChapterDto;
import de.justsoftware.wikiservice.business.model.WikiDto;
import de.justsoftware.wikiservice.graphql.AuthenticatedGraphQLContext;
import de.justsoftware.wikiservice.graphql.dataloader.DataLoaderFactory;
import de.justsoftware.wikiservice.graphql.dataloader.DataLoaderName;
import de.justsoftware.wikiservice.graphql.generated.MutationCreateArticleArgs;
import de.justsoftware.wikiservice.graphql.generated.MutationDeleteArticleArgs;
import de.justsoftware.wikiservice.graphql.generated.MutationDeleteArticleEditingTokenArgs;
import de.justsoftware.wikiservice.graphql.generated.MutationUpdateArticleArgs;
import de.justsoftware.wikiservice.graphql.generated.MutationUpdateArticleEditingTokenArgs;
import de.justsoftware.wikiservice.graphql.generated.QueryArticleArgs;
import de.justsoftware.wikiservice.graphql.generated.QueryArticleVersionArgs;
import de.justsoftware.wikiservice.graphql.generated.QuerySubscribedArticlesArgs;
import de.justsoftware.wikiservice.model.ArticleId;
import de.justsoftware.wikiservice.model.ParentId;
import de.justsoftware.wikiservice.model.WikiId;
import graphql.schema.DataFetcher;
import graphql.schema.DataFetchingEnvironment;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import kotlin.Metadata;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import org.dataloader.DataLoader;
import org.jetbrains.annotations.NotNull;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Bean;
import org.springframework.stereotype.Component;

@Component
@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000^\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0003\b\u0017\u0018\u00002\u00020\u0001B\u000f\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0014\u0010\u001b\u001a\u000e\u0012\u0004\u0012\u00020\u001d\u0012\u0004\u0012\u00020\u00160\u001cH\u0017J\u001a\u0010\u001e\u001a\u0014\u0012\u0004\u0012\u00020\u001f\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000f0\b0\u001cH\u0017J\u001a\u0010 \u001a\u0014\u0012\u0004\u0012\u00020!\u0012\n\u0012\b\u0012\u0004\u0012\u00020\t0\b0\u001cH\u0017J\u000e\u0010\"\u001a\b\u0012\u0004\u0012\u00020\t0\u0006H\u0016J\u000e\u0010#\u001a\b\u0012\u0004\u0012\u00020\t0\u0006H\u0016J\u000e\u0010$\u001a\b\u0012\u0004\u0012\u00020%0\u0006H\u0016J\u000e\u0010&\u001a\b\u0012\u0004\u0012\u00020\t0\u0006H\u0016J\u000e\u0010'\u001a\b\u0012\u0004\u0012\u00020%0\u0006H\u0016R&\u0010\u0005\u001a\u0014\u0012\u0010\u0012\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\t0\b0\u00070\u0006X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR&\u0010\f\u001a\u0014\u0012\u0010\u0012\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\t0\b0\u00070\u0006X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000bR\u000e\u0010\u0002\u001a\u00020\u0003X\u0092\u0004\u00a2\u0006\u0002\n\u0000R&\u0010\u000e\u001a\u0014\u0012\u0010\u0012\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000f0\b0\u00070\u0006X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u000bR\u001a\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\t0\u0006X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u000bR\u001a\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\t0\u0006X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u000bR \u0010\u0015\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00160\u00070\u0006X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u000bR \u0010\u0018\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00190\b0\u0006X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\u000b\u00a8\u0006("}, d2={"Lde/justsoftware/wikiservice/graphql/fetchers/ArticleFetcher;", "", "articleApplicationService", "Lde/justsoftware/wikiservice/application/ArticleApplicationService;", "(Lde/justsoftware/wikiservice/application/ArticleApplicationService;)V", "allByChapter", "Lgraphql/schema/DataFetcher;", "Ljava/util/concurrent/CompletableFuture;", "", "Lde/justsoftware/wikiservice/business/model/ArticleDto;", "getAllByChapter", "()Lgraphql/schema/DataFetcher;", "allByWiki", "getAllByWiki", "articleVersionsByArticleId", "Lde/justsoftware/wikiservice/business/model/ArticleVersionDto;", "getArticleVersionsByArticleId", "byId", "getById", "byVersionId", "getByVersionId", "countByWiki", "", "getCountByWiki", "subscribedArticles", "Lde/justsoftware/wikiservice/business/model/ArticleWithTitleDto;", "getSubscribedArticles", "articleCountForWholeWikiDataLoaderFactory", "Lde/justsoftware/wikiservice/graphql/dataloader/DataLoaderFactory;", "Lde/justsoftware/wikiservice/model/WikiId;", "articleVersionsByArticleIdsDataLoaderFactory", "Lde/justsoftware/wikiservice/model/ArticleId;", "childArticlesByChapterParentsDataLoaderFactory", "Lde/justsoftware/wikiservice/model/ParentId;", "create", "delete", "deleteEditingToken", "", "update", "updateEditingToken", "wiki-service"})
public class ArticleFetcher {
    @NotNull
    private final ArticleApplicationService articleApplicationService;
    @NotNull
    private final DataFetcher<ArticleDto> byId;
    @NotNull
    private final DataFetcher<ArticleDto> byVersionId;
    @NotNull
    private final DataFetcher<List<ArticleWithTitleDto>> subscribedArticles;
    @NotNull
    private final DataFetcher<CompletableFuture<List<ArticleVersionDto>>> articleVersionsByArticleId;
    @NotNull
    private final DataFetcher<CompletableFuture<List<ArticleDto>>> allByWiki;
    @NotNull
    private final DataFetcher<CompletableFuture<Integer>> countByWiki;
    @NotNull
    private final DataFetcher<CompletableFuture<List<ArticleDto>>> allByChapter;

    @Autowired
    public ArticleFetcher(@NotNull ArticleApplicationService articleApplicationService) {
        Intrinsics.checkNotNullParameter((Object)articleApplicationService, (String)"articleApplicationService");
        this.articleApplicationService = articleApplicationService;
        this.byId = arg_0 -> ArticleFetcher.byId$lambda$0(this, arg_0);
        this.byVersionId = arg_0 -> ArticleFetcher.byVersionId$lambda$1(this, arg_0);
        this.subscribedArticles = arg_0 -> ArticleFetcher.subscribedArticles$lambda$2(this, arg_0);
        this.articleVersionsByArticleId = ArticleFetcher::articleVersionsByArticleId$lambda$3;
        this.allByWiki = ArticleFetcher::allByWiki$lambda$4;
        this.countByWiki = ArticleFetcher::countByWiki$lambda$5;
        this.allByChapter = ArticleFetcher::allByChapter$lambda$6;
    }

    @Bean
    @NotNull
    public DataLoaderFactory<ParentId, List<ArticleDto>> childArticlesByChapterParentsDataLoaderFactory() {
        return new DataLoaderFactory(DataLoaderName.CHILD_ARTICLES_LOADER, (Function2)new /* Unavailable Anonymous Inner Class!! */);
    }

    @Bean
    @NotNull
    public DataLoaderFactory<ArticleId, List<ArticleVersionDto>> articleVersionsByArticleIdsDataLoaderFactory() {
        return new DataLoaderFactory(DataLoaderName.ARTICLE_VERSIONS_LOADER, (Function2)new /* Unavailable Anonymous Inner Class!! */);
    }

    @Bean
    @NotNull
    public DataLoaderFactory<WikiId, Integer> articleCountForWholeWikiDataLoaderFactory() {
        return new DataLoaderFactory(DataLoaderName.WIKI_ARTICLE_COUNT_LOADER, (Function2)new /* Unavailable Anonymous Inner Class!! */);
    }

    @NotNull
    public DataFetcher<ArticleDto> getById() {
        return this.byId;
    }

    @NotNull
    public DataFetcher<ArticleDto> getByVersionId() {
        return this.byVersionId;
    }

    @NotNull
    public DataFetcher<List<ArticleWithTitleDto>> getSubscribedArticles() {
        return this.subscribedArticles;
    }

    @NotNull
    public DataFetcher<CompletableFuture<List<ArticleVersionDto>>> getArticleVersionsByArticleId() {
        return this.articleVersionsByArticleId;
    }

    @NotNull
    public DataFetcher<CompletableFuture<List<ArticleDto>>> getAllByWiki() {
        return this.allByWiki;
    }

    @NotNull
    public DataFetcher<CompletableFuture<Integer>> getCountByWiki() {
        return this.countByWiki;
    }

    @NotNull
    public DataFetcher<CompletableFuture<List<ArticleDto>>> getAllByChapter() {
        return this.allByChapter;
    }

    @NotNull
    public DataFetcher<ArticleDto> create() {
        return arg_0 -> ArticleFetcher.create$lambda$7(this, arg_0);
    }

    @NotNull
    public DataFetcher<ArticleDto> update() {
        return arg_0 -> ArticleFetcher.update$lambda$8(this, arg_0);
    }

    @NotNull
    public DataFetcher<ArticleDto> delete() {
        return arg_0 -> ArticleFetcher.delete$lambda$9(this, arg_0);
    }

    @NotNull
    public DataFetcher<Boolean> updateEditingToken() {
        return arg_0 -> ArticleFetcher.updateEditingToken$lambda$10(this, arg_0);
    }

    @NotNull
    public DataFetcher<Boolean> deleteEditingToken() {
        return arg_0 -> ArticleFetcher.deleteEditingToken$lambda$11(this, arg_0);
    }

    private static final ArticleDto byId$lambda$0(ArticleFetcher this$0, DataFetchingEnvironment env) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Map map = env.getArguments();
        Intrinsics.checkNotNullExpressionValue((Object)map, (String)"env.arguments");
        QueryArticleArgs args = new QueryArticleArgs(map);
        Object object = env.getContext();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"env.getContext()");
        AuthenticatedGraphQLContext context = (AuthenticatedGraphQLContext)object;
        return this$0.articleApplicationService.read(args.getId(), context.getAuthContext());
    }

    private static final ArticleDto byVersionId$lambda$1(ArticleFetcher this$0, DataFetchingEnvironment env) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Map map = env.getArguments();
        Intrinsics.checkNotNullExpressionValue((Object)map, (String)"env.arguments");
        QueryArticleVersionArgs args = new QueryArticleVersionArgs(map);
        Object object = env.getContext();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"env.getContext()");
        AuthenticatedGraphQLContext context = (AuthenticatedGraphQLContext)object;
        return this$0.articleApplicationService.readArticleByVersionId(args.getId(), context.getAuthContext());
    }

    private static final List subscribedArticles$lambda$2(ArticleFetcher this$0, DataFetchingEnvironment env) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Map map = env.getArguments();
        Intrinsics.checkNotNullExpressionValue((Object)map, (String)"env.arguments");
        QuerySubscribedArticlesArgs args = new QuerySubscribedArticlesArgs(map);
        Object object = env.getContext();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"env.getContext()");
        AuthenticatedGraphQLContext context = (AuthenticatedGraphQLContext)object;
        return this$0.articleApplicationService.readSubscribedArticles(args.getPage(), args.getSize(), context.getAuthContext());
    }

    private static final CompletableFuture articleVersionsByArticleId$lambda$3(DataFetchingEnvironment env) {
        Object object = env.getContext();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"env.getContext()");
        AuthenticatedGraphQLContext context = (AuthenticatedGraphQLContext)object;
        DataLoader dataLoader = context.getDataLoader(DataLoaderName.ARTICLE_VERSIONS_LOADER);
        Object object2 = env.getSource();
        Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"env.getSource()");
        ArticleDto article = (ArticleDto)object2;
        return dataLoader.load((Object)article.getId());
    }

    private static final CompletableFuture allByWiki$lambda$4(DataFetchingEnvironment env) {
        Object object = env.getContext();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"env.getContext()");
        AuthenticatedGraphQLContext context = (AuthenticatedGraphQLContext)object;
        DataLoader dataLoader = context.getDataLoader(DataLoaderName.CHILD_ARTICLES_LOADER);
        Object object2 = env.getSource();
        Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"env.getSource()");
        WikiDto wiki = (WikiDto)object2;
        return dataLoader.load((Object)wiki.getId());
    }

    private static final CompletableFuture countByWiki$lambda$5(DataFetchingEnvironment env) {
        Object object = env.getContext();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"env.getContext()");
        AuthenticatedGraphQLContext context = (AuthenticatedGraphQLContext)object;
        DataLoader dataLoader = context.getDataLoader(DataLoaderName.WIKI_ARTICLE_COUNT_LOADER);
        Object object2 = env.getSource();
        Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"env.getSource()");
        WikiDto wiki = (WikiDto)object2;
        return dataLoader.load((Object)wiki.getId());
    }

    private static final CompletableFuture allByChapter$lambda$6(DataFetchingEnvironment env) {
        Object object = env.getContext();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"env.getContext()");
        AuthenticatedGraphQLContext context = (AuthenticatedGraphQLContext)object;
        DataLoader dataLoader = context.getDataLoader(DataLoaderName.CHILD_ARTICLES_LOADER);
        Object object2 = env.getSource();
        Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"env.getSource()");
        ChapterDto chapter = (ChapterDto)object2;
        return dataLoader.load((Object)chapter.getId());
    }

    private static final ArticleDto create$lambda$7(ArticleFetcher this$0, DataFetchingEnvironment env) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Map map = env.getArguments();
        Intrinsics.checkNotNullExpressionValue((Object)map, (String)"env.arguments");
        MutationCreateArticleArgs args = new MutationCreateArticleArgs(map);
        Object object = env.getContext();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"env.getContext()");
        AuthenticatedGraphQLContext context = (AuthenticatedGraphQLContext)object;
        return this$0.articleApplicationService.create(args.getArticle(), context.getAuthContext());
    }

    private static final ArticleDto update$lambda$8(ArticleFetcher this$0, DataFetchingEnvironment env) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Map map = env.getArguments();
        Intrinsics.checkNotNullExpressionValue((Object)map, (String)"env.arguments");
        MutationUpdateArticleArgs args = new MutationUpdateArticleArgs(map);
        Object object = env.getContext();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"env.getContext()");
        AuthenticatedGraphQLContext context = (AuthenticatedGraphQLContext)object;
        return this$0.articleApplicationService.update(args.getId(), args.getArticle(), context.getAuthContext());
    }

    private static final ArticleDto delete$lambda$9(ArticleFetcher this$0, DataFetchingEnvironment env) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Map map = env.getArguments();
        Intrinsics.checkNotNullExpressionValue((Object)map, (String)"env.arguments");
        MutationDeleteArticleArgs args = new MutationDeleteArticleArgs(map);
        Object object = env.getContext();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"env.getContext()");
        AuthenticatedGraphQLContext context = (AuthenticatedGraphQLContext)object;
        return this$0.articleApplicationService.delete(args.getId(), context.getAuthContext());
    }

    private static final Boolean updateEditingToken$lambda$10(ArticleFetcher this$0, DataFetchingEnvironment env) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Map map = env.getArguments();
        Intrinsics.checkNotNullExpressionValue((Object)map, (String)"env.arguments");
        MutationUpdateArticleEditingTokenArgs args = new MutationUpdateArticleEditingTokenArgs(map);
        Object object = env.getContext();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"env.getContext()");
        AuthenticatedGraphQLContext context = (AuthenticatedGraphQLContext)object;
        return this$0.articleApplicationService.updateEditingToken(args.getId(), context.getAuthContext());
    }

    private static final Boolean deleteEditingToken$lambda$11(ArticleFetcher this$0, DataFetchingEnvironment env) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Map map = env.getArguments();
        Intrinsics.checkNotNullExpressionValue((Object)map, (String)"env.arguments");
        MutationDeleteArticleEditingTokenArgs args = new MutationDeleteArticleEditingTokenArgs(map);
        Object object = env.getContext();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"env.getContext()");
        AuthenticatedGraphQLContext context = (AuthenticatedGraphQLContext)object;
        return this$0.articleApplicationService.deleteEditingToken(args.getId(), context.getAuthContext());
    }

    public static final /* synthetic */ ArticleApplicationService access$getArticleApplicationService$p(ArticleFetcher $this) {
        return $this.articleApplicationService;
    }
}

