/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.wikiservice.business;

import de.justsoftware.wikiservice.business.AncestorService;
import de.justsoftware.wikiservice.business.PermissionService;
import de.justsoftware.wikiservice.business.exceptions.ArticleNotFoundException;
import de.justsoftware.wikiservice.business.exceptions.ArticleVersionNotFoundException;
import de.justsoftware.wikiservice.business.exceptions.EmptyArticleTitleException;
import de.justsoftware.wikiservice.business.model.ArticleDto;
import de.justsoftware.wikiservice.business.model.ArticleVersionDto;
import de.justsoftware.wikiservice.business.model.ArticleWithTitleDto;
import de.justsoftware.wikiservice.drive.DriveService;
import de.justsoftware.wikiservice.model.ArticleId;
import de.justsoftware.wikiservice.model.ArticleVersionId;
import de.justsoftware.wikiservice.model.DeletionId;
import de.justsoftware.wikiservice.model.IdType;
import de.justsoftware.wikiservice.model.ParentId;
import de.justsoftware.wikiservice.model.ProfileId;
import de.justsoftware.wikiservice.model.WikiId;
import de.justsoftware.wikiservice.persistence.ArticleRepository;
import de.justsoftware.wikiservice.persistence.ArticleVersionRepository;
import de.justsoftware.wikiservice.persistence.model.Article;
import de.justsoftware.wikiservice.persistence.model.ArticleVersion;
import de.justsoftware.wikiservice.prosemirror.ProseMirrorContentParserKt;
import de.justsoftware.wikiservice.util.IdUtilsKt;
import de.justsoftware.wikiservice.util.TransactionUtils;
import jakarta.persistence.EntityManager;
import jakarta.persistence.PersistenceContext;
import java.time.Clock;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.jvm.internal.StringCompanionObject;
import kotlin.ranges.RangesKt;
import kotlin.text.StringsKt;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u00bc\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\"\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u0017\u0018\u00002\u00020\u0001BY\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\u0006\u0010\f\u001a\u00020\r\u0012\u0006\u0010\u000e\u001a\u00020\u000f\u0012\u0006\u0010\u0010\u001a\u00020\u0011\u0012\b\b\u0001\u0010\u0012\u001a\u00020\u0013\u0012\u0006\u0010\u0014\u001a\u00020\u0015\u00a2\u0006\u0002\u0010\u0016J\"\u0010\u0017\u001a\u000e\u0012\u0004\u0012\u00020\u0019\u0012\u0004\u0012\u00020\u001a0\u00182\f\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u00190\u001cH\u0016JJ\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020 2\u0006\u0010!\u001a\u00020\u00192\u0006\u0010\"\u001a\u00020#2\u0006\u0010$\u001a\u00020#2\u0006\u0010%\u001a\u00020#2\u0006\u0010&\u001a\u00020'2\u0006\u0010(\u001a\u00020\u001a2\b\u0010)\u001a\u0004\u0018\u00010'H\u0017J \u0010*\u001a\u00020+2\u0006\u0010,\u001a\u00020-2\u0006\u0010.\u001a\u00020/2\u0006\u00100\u001a\u00020'H\u0017J\u001e\u00101\u001a\u00020+2\f\u00102\u001a\b\u0012\u0004\u0012\u00020 0\u001c2\u0006\u0010.\u001a\u00020/H\u0017J\u0018\u00103\u001a\u0002042\u0006\u00105\u001a\u00020\u001e2\u0006\u00106\u001a\u00020'H\u0017J\u0018\u00107\u001a\u00020+2\u0006\u00108\u001a\u00020\u00192\u0006\u0010.\u001a\u00020/H\u0017J\u0010\u00109\u001a\u00020:2\u0006\u0010,\u001a\u00020-H\u0012J\u0010\u0010;\u001a\u00020\u001e2\u0006\u0010,\u001a\u00020-H\u0017J\u000e\u0010<\u001a\b\u0012\u0004\u0012\u00020-0\u001cH\u0016J\u0010\u0010=\u001a\u00020\u001e2\u0006\u0010>\u001a\u00020?H\u0017J\"\u0010@\u001a\u000e\u0012\u0004\u0012\u00020-\u0012\u0004\u0012\u00020\u001e0\u00182\f\u0010A\u001a\b\u0012\u0004\u0012\u00020-0\u001cH\u0016J(\u0010B\u001a\u0014\u0012\u0004\u0012\u00020 \u0012\n\u0012\b\u0012\u0004\u0012\u00020\u001e0C0\u00182\f\u00102\u001a\b\u0012\u0004\u0012\u00020 0\u001cH\u0016J&\u0010D\u001a\b\u0012\u0004\u0012\u00020E0C2\u0006\u0010F\u001a\u00020'2\u0006\u0010G\u001a\u00020\u001a2\u0006\u0010H\u001a\u00020\u001aH\u0017J(\u0010I\u001a\u0014\u0012\u0004\u0012\u00020-\u0012\n\u0012\b\u0012\u0004\u0012\u00020J0C0\u00182\f\u0010A\u001a\b\u0012\u0004\u0012\u00020-0\u001cH\u0017J\u0016\u0010K\u001a\u00020+2\f\u0010L\u001a\b\u0012\u0004\u0012\u00020/0\u001cH\u0017JJ\u0010M\u001a\u00020\u001e2\u0006\u0010,\u001a\u00020-2\b\u0010\"\u001a\u0004\u0018\u00010#2\b\u0010$\u001a\u0004\u0018\u00010#2\b\u0010%\u001a\u0004\u0018\u00010#2\u0006\u00106\u001a\u00020'2\b\u0010)\u001a\u0004\u0018\u00010'2\b\b\u0002\u0010N\u001a\u000204H\u0017J\u0018\u0010O\u001a\u0002042\u0006\u00105\u001a\u00020\u001e2\u0006\u00106\u001a\u00020'H\u0017R\u000e\u0010\u000e\u001a\u00020\u000fX\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0011X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0014\u001a\u00020\u00158\u0012X\u0093\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0013X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0092\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006P"}, d2={"Lde/justsoftware/wikiservice/business/ArticleService;", "", "permissionService", "Lde/justsoftware/wikiservice/business/PermissionService;", "articleRepository", "Lde/justsoftware/wikiservice/persistence/ArticleRepository;", "articleVersionRepository", "Lde/justsoftware/wikiservice/persistence/ArticleVersionRepository;", "transactionUtils", "Lde/justsoftware/wikiservice/util/TransactionUtils;", "applicationEventPublisher", "Lorg/springframework/context/ApplicationEventPublisher;", "driveService", "Lde/justsoftware/wikiservice/drive/DriveService;", "ancestorService", "Lde/justsoftware/wikiservice/business/AncestorService;", "clock", "Ljava/time/Clock;", "maxEditingTokenDuration", "", "entityManager", "Ljakarta/persistence/EntityManager;", "(Lde/justsoftware/wikiservice/business/PermissionService;Lde/justsoftware/wikiservice/persistence/ArticleRepository;Lde/justsoftware/wikiservice/persistence/ArticleVersionRepository;Lde/justsoftware/wikiservice/util/TransactionUtils;Lorg/springframework/context/ApplicationEventPublisher;Lde/justsoftware/wikiservice/drive/DriveService;Lde/justsoftware/wikiservice/business/AncestorService;Ljava/time/Clock;JLjakarta/persistence/EntityManager;)V", "countByWikiIds", "", "Lde/justsoftware/wikiservice/model/WikiId;", "", "wikiIds", "", "create", "Lde/justsoftware/wikiservice/business/model/ArticleDto;", "parentId", "Lde/justsoftware/wikiservice/model/ParentId;", "wiki", "title", "", "content", "textContent", "creator", "Lde/justsoftware/wikiservice/model/ProfileId;", "position", "contactPerson", "delete", "", "articleId", "Lde/justsoftware/wikiservice/model/ArticleId;", "deletionId", "Lde/justsoftware/wikiservice/model/DeletionId;", "deletedBy", "deleteByParentIds", "parentIds", "deleteEditingToken", "", "articleDto", "updater", "deleteWikiArticles", "wikiId", "getLatestArticleVersion", "Lde/justsoftware/wikiservice/persistence/model/ArticleVersion;", "read", "readAllIds", "readArticleByVersionId", "versionId", "Lde/justsoftware/wikiservice/model/ArticleVersionId;", "readByIds", "articleIds", "readByParentIds", "", "readBySubscriber", "Lde/justsoftware/wikiservice/business/model/ArticleWithTitleDto;", "subscriber", "page", "limit", "readVersions", "Lde/justsoftware/wikiservice/business/model/ArticleVersionDto;", "removeDeletedArticles", "deletionIds", "update", "articleWasMoved", "updateEditingToken", "wiki-service"})
@SourceDebugExtension(value={"SMAP\nArticleService.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ArticleService.kt\nde/justsoftware/wikiservice/business/ArticleService\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,419:1\n1271#2,2:420\n1285#2,4:422\n1603#2,9:426\n1855#2:435\n1856#2:437\n1612#2:438\n1549#2:439\n1620#2,3:440\n1194#2,2:443\n1222#2,4:445\n1603#2,9:449\n1855#2:458\n1856#2:460\n1612#2:461\n1271#2,2:462\n1285#2,2:464\n1549#2:466\n1620#2,3:467\n1288#2:470\n1603#2,9:471\n1855#2:480\n1856#2:482\n1612#2:483\n1271#2,2:484\n1285#2,4:486\n1855#2,2:491\n1855#2,2:493\n1549#2:495\n1620#2,3:496\n1#3:436\n1#3:459\n1#3:481\n1#3:490\n*S KotlinDebug\n*F\n+ 1 ArticleService.kt\nde/justsoftware/wikiservice/business/ArticleService\n*L\n156#1:420,2\n156#1:422,4\n172#1:426,9\n172#1:435\n172#1:437\n172#1:438\n176#1:439\n176#1:440,3\n184#1:443,2\n184#1:445,4\n192#1:449,9\n192#1:458\n192#1:460\n192#1:461\n195#1:462,2\n195#1:464,2\n198#1:466\n198#1:467,3\n195#1:470\n210#1:471,9\n210#1:480\n210#1:482\n210#1:483\n215#1:484,2\n215#1:486,4\n326#1:491,2\n341#1:493,2\n403#1:495\n403#1:496,3\n172#1:436\n192#1:459\n210#1:481\n*E\n"})
public class ArticleService {
    @NotNull
    private final PermissionService permissionService;
    @NotNull
    private final ArticleRepository articleRepository;
    @NotNull
    private final ArticleVersionRepository articleVersionRepository;
    @NotNull
    private final TransactionUtils transactionUtils;
    @NotNull
    private final ApplicationEventPublisher applicationEventPublisher;
    @NotNull
    private final DriveService driveService;
    @NotNull
    private final AncestorService ancestorService;
    @NotNull
    private final Clock clock;
    private final long maxEditingTokenDuration;
    @PersistenceContext
    @NotNull
    private final EntityManager entityManager;

    @Autowired
    public ArticleService(@NotNull PermissionService permissionService, @NotNull ArticleRepository articleRepository, @NotNull ArticleVersionRepository articleVersionRepository, @NotNull TransactionUtils transactionUtils, @NotNull ApplicationEventPublisher applicationEventPublisher, @NotNull DriveService driveService, @NotNull AncestorService ancestorService, @NotNull Clock clock, @Value(value="${service.maxArticleEditingTokenDurationSec:28800}") long maxEditingTokenDuration, @NotNull EntityManager entityManager) {
        Intrinsics.checkNotNullParameter((Object)permissionService, (String)"permissionService");
        Intrinsics.checkNotNullParameter((Object)articleRepository, (String)"articleRepository");
        Intrinsics.checkNotNullParameter((Object)articleVersionRepository, (String)"articleVersionRepository");
        Intrinsics.checkNotNullParameter((Object)transactionUtils, (String)"transactionUtils");
        Intrinsics.checkNotNullParameter((Object)applicationEventPublisher, (String)"applicationEventPublisher");
        Intrinsics.checkNotNullParameter((Object)driveService, (String)"driveService");
        Intrinsics.checkNotNullParameter((Object)ancestorService, (String)"ancestorService");
        Intrinsics.checkNotNullParameter((Object)clock, (String)"clock");
        Intrinsics.checkNotNullParameter((Object)entityManager, (String)"entityManager");
        this.permissionService = permissionService;
        this.articleRepository = articleRepository;
        this.articleVersionRepository = articleVersionRepository;
        this.transactionUtils = transactionUtils;
        this.applicationEventPublisher = applicationEventPublisher;
        this.driveService = driveService;
        this.ancestorService = ancestorService;
        this.clock = clock;
        this.maxEditingTokenDuration = maxEditingTokenDuration;
        this.entityManager = entityManager;
    }

    @Transactional
    @NotNull
    public ArticleDto create(@NotNull ParentId parentId, @NotNull WikiId wiki, @NotNull String title, @NotNull String content, @NotNull String textContent, @NotNull ProfileId creator, int position, @Nullable ProfileId contactPerson) {
        Intrinsics.checkNotNullParameter((Object)parentId, (String)"parentId");
        Intrinsics.checkNotNullParameter((Object)wiki, (String)"wiki");
        Intrinsics.checkNotNullParameter((Object)title, (String)"title");
        Intrinsics.checkNotNullParameter((Object)content, (String)"content");
        Intrinsics.checkNotNullParameter((Object)textContent, (String)"textContent");
        Intrinsics.checkNotNullParameter((Object)creator, (String)"creator");
        if (StringsKt.isBlank((CharSequence)title)) {
            throw new EmptyArticleTitleException();
        }
        Article it = (Article)this.articleRepository.save((Object)new Article(wiki, parentId, null, null, null, Integer.valueOf(position), contactPerson, 28, null));
        boolean bl = false;
        ArticleId articleId = it.getId();
        if (articleId == null) {
            throw new ArticleNotFoundException(null, 1, null);
        }
        ArticleId articleId2 = articleId;
        String string = StringUtils.normalizeSpace((String)title);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"normalizeSpace(title)");
        ArticleVersion version = (ArticleVersion)this.articleVersionRepository.save((Object)new ArticleVersion(articleId2, string, content, textContent, creator));
        Set tempDriveMediaIds = ProseMirrorContentParserKt.driveMediaIdsFromPMContent((String)content);
        if (!((Collection)tempDriveMediaIds).isEmpty()) {
            this.driveService.persistFiles(tempDriveMediaIds, articleId2, creator);
        }
        this.transactionUtils.afterCommit((Function0)new /* Unavailable Anonymous Inner Class!! */);
        this.permissionService.addPermissionItemForNewArticle(articleId2, wiki);
        Instant updatedAt = version.getUpdatedAt();
        if (updatedAt == null) {
            String string2 = "Required value was null.";
            throw new IllegalStateException(string2.toString());
        }
        this.ancestorService.updateEditedStatusForAncestors(parentId, updatedAt, version.getModifiedBy());
        Intrinsics.checkNotNullExpressionValue((Object)it, (String)"it");
        Intrinsics.checkNotNullExpressionValue((Object)version, (String)"version");
        return ArticleDto.Companion.toDto(it, version, this.clock, this.maxEditingTokenDuration);
    }

    private ArticleVersion getLatestArticleVersion(ArticleId articleId) {
        ArticleVersion articleVersion = (ArticleVersion)this.articleVersionRepository.findLatestArticleVersionsByArticleIds(SetsKt.setOf((Object)articleId)).get(articleId);
        if (articleVersion == null) {
            throw new ArticleVersionNotFoundException(null, 1, null);
        }
        return articleVersion;
    }

    @Transactional(readOnly=true)
    @NotNull
    public List<ArticleWithTitleDto> readBySubscriber(@NotNull ProfileId subscriber, int page, int limit) {
        Intrinsics.checkNotNullParameter((Object)subscriber, (String)"subscriber");
        long l = subscriber.getId();
        String[] stringArray = new String[]{"id"};
        PageRequest pageRequest = PageRequest.of((int)page, (int)limit, (Sort)Sort.by((Sort.Direction)Sort.Direction.ASC, (String[])stringArray));
        Intrinsics.checkNotNullExpressionValue((Object)pageRequest, (String)"of(page, limit, Sort.by(Sort.Direction.ASC, \"id\"))");
        List<ArticleWithTitleDto> list = this.articleRepository.findAllBySubscriber(l, (Pageable)pageRequest).get().toList();
        Intrinsics.checkNotNullExpressionValue(list, (String)"articleRepository.findAl\u2026d\"))\n    ).get().toList()");
        return list;
    }

    @Transactional
    @NotNull
    public ArticleDto read(@NotNull ArticleId articleId) {
        Intrinsics.checkNotNullParameter((Object)articleId, (String)"articleId");
        Article it = (Article)this.articleRepository.getReferenceById((Object)articleId);
        boolean bl = false;
        ArticleId articleId2 = it.getId();
        if (articleId2 == null) {
            throw new ArticleNotFoundException(articleId);
        }
        ArticleId id = articleId2;
        ArticleVersion articleVersion = this.getLatestArticleVersion(id);
        Intrinsics.checkNotNullExpressionValue((Object)it, (String)"it");
        return ArticleDto.Companion.toDto(it, articleVersion, this.clock, this.maxEditingTokenDuration);
    }

    @Transactional
    @NotNull
    public ArticleDto readArticleByVersionId(@NotNull ArticleVersionId versionId) {
        Intrinsics.checkNotNullParameter((Object)versionId, (String)"versionId");
        ArticleVersion it = (ArticleVersion)this.articleVersionRepository.findById((Object)versionId).orElseThrow(() -> ArticleService.readArticleByVersionId$lambda$2(versionId));
        boolean bl = false;
        Object object = this.articleRepository.getReferenceById((Object)it.getArticleId());
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"articleRepository.getReferenceById(it.articleId)");
        Article article = (Article)object;
        Intrinsics.checkNotNullExpressionValue((Object)it, (String)"it");
        return ArticleDto.Companion.toDto(article, it, this.clock, this.maxEditingTokenDuration);
    }

    /*
     * WARNING - void declaration
     */
    @Transactional
    @NotNull
    public Map<ArticleId, List<ArticleVersionDto>> readVersions(@NotNull Set<ArticleId> articleIds) {
        Intrinsics.checkNotNullParameter(articleIds, (String)"articleIds");
        Iterable $this$associateWith$iv = articleIds;
        boolean $i$f$associateWith = false;
        LinkedHashMap result$iv = new LinkedHashMap(RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associateWith$iv, (int)10)), (int)16));
        Iterable $this$associateWithTo$iv$iv = $this$associateWith$iv;
        boolean $i$f$associateWithTo = false;
        for (Object element$iv$iv : $this$associateWithTo$iv$iv) {
            void article;
            ArticleId articleId = (ArticleId)element$iv$iv;
            Object t = element$iv$iv;
            Map map = result$iv;
            boolean bl = false;
            List<ArticleVersionDto> list = this.articleVersionRepository.findByArticleIdOrderByCreatedAtDesc((ArticleId)article).map(arg_0 -> ArticleService.readVersions$lambda$5$lambda$4((Function1)new /* Unavailable Anonymous Inner Class!! */, arg_0)).toList();
            map.put(t, list);
        }
        return result$iv;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public Map<ArticleId, ArticleDto> readByIds(@NotNull Set<ArticleId> articleIds) {
        void $this$associateByTo$iv$iv;
        void $this$associateBy$iv;
        void $this$mapTo$iv$iv;
        Iterable $this$map$iv;
        void $this$mapNotNullTo$iv$iv;
        Iterable $this$mapNotNull$iv;
        Intrinsics.checkNotNullParameter(articleIds, (String)"articleIds");
        List articles = this.articleRepository.findByIds(articleIds);
        boolean bl = false;
        Iterable iterable = articles;
        Object object = this.articleVersionRepository;
        boolean $i$f$mapNotNull = false;
        void var7_7 = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        Iterator $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Article article = $this$forEach$iv$iv$iv.iterator();
        while (article.hasNext()) {
            ArticleId it$iv$iv;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = article.next();
            boolean bl2 = false;
            Article article2 = (Article)element$iv$iv;
            boolean bl3 = false;
            if (article2.getId() == null) continue;
            boolean bl4 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        Map latestVersions = object.findLatestArticleVersionsByArticleIds(CollectionsKt.toSet((Iterable)((List)destination$iv$iv)));
        $this$mapNotNull$iv = articles;
        boolean $i$f$map = false;
        $this$mapNotNullTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            ArticleId id;
            void it;
            article = (Article)item$iv$iv;
            object = destination$iv$iv;
            boolean bl5 = false;
            if (it.getId() == null) {
                throw new ArticleNotFoundException(null, 1, null);
            }
            ArticleVersion articleVersion = (ArticleVersion)latestVersions.get(id);
            if (articleVersion == null) {
                throw new ArticleVersionNotFoundException(null, 1, null);
            }
            object.add(ArticleDto.Companion.toDto((Article)it, articleVersion, this.clock, this.maxEditingTokenDuration));
        }
        $this$map$iv = (List)destination$iv$iv;
        boolean $i$f$associateBy = false;
        int capacity$iv = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associateBy$iv, (int)10)), (int)16);
        destination$iv$iv = $this$associateBy$iv;
        Map destination$iv$iv2 = new LinkedHashMap(capacity$iv);
        boolean $i$f$associateByTo = false;
        for (Object element$iv$iv : $this$associateByTo$iv$iv) {
            void it;
            ArticleDto bl5 = (ArticleDto)element$iv$iv;
            object = destination$iv$iv2;
            boolean bl6 = false;
            object.put(it.getId(), element$iv$iv);
        }
        return destination$iv$iv2;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public Map<ParentId, List<ArticleDto>> readByParentIds(@NotNull Set<? extends ParentId> parentIds) {
        Article it;
        Object element$iv$iv;
        void $this$mapNotNullTo$iv$iv;
        void $this$mapNotNull$iv;
        Intrinsics.checkNotNullParameter(parentIds, (String)"parentIds");
        Map parentArticles = this.articleRepository.findByParentIds(parentIds);
        Iterable iterable = CollectionsKt.flatten((Iterable)parentArticles.values());
        Object object = this.articleVersionRepository;
        boolean $i$f$mapNotNull = false;
        void var6_6 = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        ParentId parentId = $this$forEach$iv$iv$iv.iterator();
        while (parentId.hasNext()) {
            ArticleId it$iv$iv;
            Object element$iv$iv$iv;
            element$iv$iv = element$iv$iv$iv = parentId.next();
            boolean bl = false;
            it = (Article)element$iv$iv;
            boolean bl2 = false;
            if (it.getId() == null) continue;
            boolean bl3 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        Map articleVersions = object.findLatestArticleVersionsByArticleIds(CollectionsKt.toSet((Iterable)((List)destination$iv$iv)));
        Iterable $this$associateWith$iv = parentIds;
        boolean $i$f$associateWith = false;
        LinkedHashMap result$iv = new LinkedHashMap(RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associateWith$iv, (int)10)), (int)16));
        Iterable $this$associateWithTo$iv$iv = $this$associateWith$iv;
        boolean $i$f$associateWithTo = false;
        for (Object element$iv$iv2 : $this$associateWithTo$iv$iv) {
            void $this$mapTo$iv$iv;
            void $this$map$iv;
            void parentId2;
            parentId = (ParentId)element$iv$iv2;
            Object t = element$iv$iv2;
            object = result$iv;
            boolean bl = false;
            element$iv$iv = parentArticles.getOrDefault(parentId2, CollectionsKt.emptyList());
            boolean $i$f$map = false;
            it = $this$map$iv;
            Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                ArticleId id;
                void it2;
                Article article = (Article)item$iv$iv;
                Collection collection = destination$iv$iv2;
                boolean bl4 = false;
                if (it2.getId() == null) {
                    throw new ArticleNotFoundException(null, 1, null);
                }
                ArticleVersion articleVersion = (ArticleVersion)articleVersions.get(id);
                if (articleVersion == null) {
                    throw new ArticleVersionNotFoundException(null, 1, null);
                }
                collection.add(ArticleDto.Companion.toDto((Article)it2, articleVersion, this.clock, this.maxEditingTokenDuration));
            }
            Comparator comparator = StringsKt.getCASE_INSENSITIVE_ORDER((StringCompanionObject)StringCompanionObject.INSTANCE);
            List list = CollectionsKt.sortedWith((Iterable)((List)destination$iv$iv2), (Comparator)((Comparator)new /* Unavailable Anonymous Inner Class!! */));
            object.put(t, list);
        }
        return result$iv;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public Set<ArticleId> readAllIds() {
        void $this$mapNotNullTo$iv$iv;
        List list = this.articleRepository.findAll();
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"articleRepository.findAll()");
        Iterable $this$mapNotNull$iv = list;
        boolean $i$f$mapNotNull = false;
        Iterable iterable = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv$iv$iv.iterator();
        while (iterator.hasNext()) {
            ArticleId it$iv$iv;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator.next();
            boolean bl = false;
            Article it = (Article)element$iv$iv;
            boolean bl2 = false;
            if (it.getId() == null) continue;
            boolean bl3 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        return CollectionsKt.toSet((Iterable)((List)destination$iv$iv));
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public Map<WikiId, Integer> countByWikiIds(@NotNull Set<WikiId> wikiIds) {
        Intrinsics.checkNotNullParameter(wikiIds, (String)"wikiIds");
        Map countsByWiki = this.articleRepository.countByWikiIds(wikiIds);
        Iterable $this$associateWith$iv = wikiIds;
        boolean $i$f$associateWith = false;
        LinkedHashMap result$iv = new LinkedHashMap(RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associateWith$iv, (int)10)), (int)16));
        Iterable $this$associateWithTo$iv$iv = $this$associateWith$iv;
        boolean $i$f$associateWithTo = false;
        for (Object element$iv$iv : $this$associateWithTo$iv$iv) {
            void it;
            WikiId wikiId = (WikiId)element$iv$iv;
            Object t = element$iv$iv;
            Map map = result$iv;
            boolean bl = false;
            Integer n = (int)((Number)countsByWiki.getOrDefault(it, 0L)).longValue();
            map.put(t, n);
        }
        return MapsKt.toMap((Map)result$iv);
    }

    @Transactional
    @NotNull
    public ArticleDto update(@NotNull ArticleId articleId, @Nullable String title, @Nullable String content, @Nullable String textContent, @NotNull ProfileId updater, @Nullable ProfileId contactPerson, boolean articleWasMoved) {
        String newTextContent;
        String string;
        String newTitle;
        String string2;
        String string3;
        boolean contentIsValidForUpdate;
        Intrinsics.checkNotNullParameter((Object)articleId, (String)"articleId");
        Intrinsics.checkNotNullParameter((Object)updater, (String)"updater");
        if (title != null && StringsKt.isBlank((CharSequence)title)) {
            throw new EmptyArticleTitleException();
        }
        boolean bl = contentIsValidForUpdate = content == null && textContent == null || content != null && textContent != null;
        if (!contentIsValidForUpdate) {
            boolean $i$a$-require-ArticleService$update$22 = false;
            String $i$a$-require-ArticleService$update$22 = "You cannot save content without textContent or vice versa";
            throw new IllegalArgumentException($i$a$-require-ArticleService$update$22.toString());
        }
        Article article = (Article)this.articleRepository.getReferenceById((Object)articleId);
        if (!Intrinsics.areEqual((Object)contactPerson, (Object)article.getContactPerson())) {
            article.setContactPerson(contactPerson);
            this.articleRepository.save((Object)article);
        }
        ArticleVersion oldArticleVersion = this.getLatestArticleVersion(articleId);
        String string4 = title;
        if (string4 != null) {
            String it = string4;
            boolean bl2 = false;
            string3 = StringUtils.normalizeSpace((String)title);
        } else {
            string3 = string2 = null;
        }
        if (string3 == null) {
            string2 = newTitle = oldArticleVersion.getTitle();
        }
        if ((string = content) == null) {
            string = oldArticleVersion.getContent();
        }
        String newContent = string;
        String string5 = newTextContent = !Intrinsics.areEqual((Object)content, (Object)oldArticleVersion.getContent()) && textContent != null ? textContent : oldArticleVersion.getTextContent();
        if (Intrinsics.areEqual((Object)oldArticleVersion.getContent(), (Object)newContent) && Intrinsics.areEqual((Object)oldArticleVersion.getTitle(), (Object)newTitle) && !articleWasMoved) {
            Intrinsics.checkNotNullExpressionValue((Object)article, (String)"article");
            return ArticleDto.Companion.toDto(article, oldArticleVersion, this.clock, this.maxEditingTokenDuration);
        }
        ArticleVersion newArticleVersion = (ArticleVersion)this.articleVersionRepository.save((Object)new ArticleVersion(articleId, newTitle, newContent, newTextContent, updater));
        Set oldDriveMediaIds = ProseMirrorContentParserKt.driveMediaIdsFromPMContent((String)oldArticleVersion.getContent());
        Set newDriveMediaIds = ProseMirrorContentParserKt.driveMediaIdsFromPMContent((String)newContent);
        Set driveMediaIdsToSave = SetsKt.minus((Set)newDriveMediaIds, (Iterable)oldDriveMediaIds);
        if (!((Collection)driveMediaIdsToSave).isEmpty()) {
            this.driveService.persistFiles(driveMediaIdsToSave, articleId, updater);
        }
        this.transactionUtils.afterCommit((Function0)new /* Unavailable Anonymous Inner Class!! */);
        Instant updatedAt = newArticleVersion.getUpdatedAt();
        if (updatedAt == null) {
            String string6 = "Required value was null.";
            throw new IllegalStateException(string6.toString());
        }
        this.ancestorService.updateEditedStatusForAncestors(IdUtilsKt.parentIdOf((UUID)article.getParentId(), (IdType)article.getParentType()), updatedAt, newArticleVersion.getModifiedBy());
        Intrinsics.checkNotNullExpressionValue((Object)article, (String)"article");
        Intrinsics.checkNotNullExpressionValue((Object)newArticleVersion, (String)"newArticleVersion");
        return ArticleDto.Companion.toDto(article, newArticleVersion, this.clock, this.maxEditingTokenDuration);
    }

    public static /* synthetic */ ArticleDto update$default(ArticleService articleService, ArticleId articleId, String string, String string2, String string3, ProfileId profileId, ProfileId profileId2, boolean bl, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: update");
        }
        if ((n & 0x40) != 0) {
            bl = false;
        }
        return articleService.update(articleId, string, string2, string3, profileId, profileId2, bl);
    }

    @Transactional
    public void delete(@NotNull ArticleId articleId, @NotNull DeletionId deletionId, @NotNull ProfileId deletedBy) {
        Intrinsics.checkNotNullParameter((Object)articleId, (String)"articleId");
        Intrinsics.checkNotNullParameter((Object)deletionId, (String)"deletionId");
        Intrinsics.checkNotNullParameter((Object)deletedBy, (String)"deletedBy");
        Article article = (Article)this.articleRepository.getReferenceById((Object)articleId);
        UUID deletedArticleParentId = article.getParentId();
        IdType deletedArticleParentType = article.getParentType();
        this.articleRepository.deleteById((Object)articleId, deletionId);
        this.transactionUtils.afterCommit((Function0)new /* Unavailable Anonymous Inner Class!! */);
        this.permissionService.removePermissionsForDeletedArticle(articleId);
        ParentId parentId = IdUtilsKt.parentIdOf((UUID)deletedArticleParentId, (IdType)deletedArticleParentType);
        Instant instant = Instant.now();
        Intrinsics.checkNotNullExpressionValue((Object)instant, (String)"now()");
        this.ancestorService.updateEditedStatusForAncestors(parentId, instant, deletedBy);
    }

    @Transactional
    public void deleteByParentIds(@NotNull Set<? extends ParentId> parentIds, @NotNull DeletionId deletionId) {
        Intrinsics.checkNotNullParameter(parentIds, (String)"parentIds");
        Intrinsics.checkNotNullParameter((Object)deletionId, (String)"deletionId");
        Set deletedArticles = this.articleRepository.deleteAllByParentIds(parentIds, deletionId);
        Iterable $this$forEach$iv = deletedArticles;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            ArticleId it = (ArticleId)element$iv;
            boolean bl = false;
            this.permissionService.removePermissionsForDeletedArticle(it);
        }
        this.transactionUtils.afterCommit((Function0)new /* Unavailable Anonymous Inner Class!! */);
    }

    @Transactional
    public void deleteWikiArticles(@NotNull WikiId wikiId, @NotNull DeletionId deletionId) {
        Intrinsics.checkNotNullParameter((Object)wikiId, (String)"wikiId");
        Intrinsics.checkNotNullParameter((Object)deletionId, (String)"deletionId");
        Set deletedArticles = this.articleRepository.deleteAllByWikiId(wikiId, deletionId);
        Iterable $this$forEach$iv = deletedArticles;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Article it = (Article)element$iv;
            boolean bl = false;
            ArticleId articleId = it.getId();
            if (articleId == null) {
                throw new ArticleNotFoundException(null, 1, null);
            }
            this.permissionService.removePermissionsForDeletedArticle(articleId);
        }
        this.transactionUtils.afterCommit((Function0)new /* Unavailable Anonymous Inner Class!! */);
    }

    @Transactional
    public boolean updateEditingToken(@NotNull ArticleDto articleDto, @NotNull ProfileId updater) {
        boolean canUpdateToken;
        Intrinsics.checkNotNullParameter((Object)articleDto, (String)"articleDto");
        Intrinsics.checkNotNullParameter((Object)updater, (String)"updater");
        boolean bl = canUpdateToken = articleDto.getEditingStartedBy() == null || Intrinsics.areEqual((Object)articleDto.getEditingStartedBy(), (Object)updater);
        if (!canUpdateToken) {
            return false;
        }
        Instant now = Instant.ofEpochMilli(this.clock.millis());
        Article article = (Article)this.articleRepository.getReferenceById((Object)articleDto.getId());
        article.setEditingStartedAt(now);
        article.setEditingStartedBy(updater);
        this.articleRepository.save((Object)article);
        return true;
    }

    @Transactional
    public boolean deleteEditingToken(@NotNull ArticleDto articleDto, @NotNull ProfileId updater) {
        boolean canDeleteToken;
        Intrinsics.checkNotNullParameter((Object)articleDto, (String)"articleDto");
        Intrinsics.checkNotNullParameter((Object)updater, (String)"updater");
        boolean bl = canDeleteToken = articleDto.getEditingStartedBy() == null || Intrinsics.areEqual((Object)articleDto.getEditingStartedBy(), (Object)updater);
        if (!canDeleteToken) {
            return false;
        }
        Article article = (Article)this.articleRepository.getReferenceById((Object)articleDto.getId());
        article.setEditingStartedAt(null);
        article.setEditingStartedBy(null);
        this.articleRepository.save((Object)article);
        return true;
    }

    /*
     * WARNING - void declaration
     */
    @Transactional
    public void removeDeletedArticles(@NotNull Set<DeletionId> deletionIds) {
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter(deletionIds, (String)"deletionIds");
        Iterable $this$map$iv = this.articleRepository.findAllByDeletionIds(deletionIds);
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            Article article = (Article)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            ArticleId articleId = it.getId();
            if (articleId == null) {
                String string = "Required value was null.";
                throw new IllegalStateException(string.toString());
            }
            collection.add(articleId);
        }
        Set articlesToDelete = CollectionsKt.toSet((Iterable)((List)destination$iv$iv));
        this.articleVersionRepository.deleteAllByArticleIds(articlesToDelete);
        this.articleRepository.deleteAllByDeletionIds(deletionIds);
        this.transactionUtils.afterCommit((Function0)new /* Unavailable Anonymous Inner Class!! */);
    }

    private static final ArticleVersionNotFoundException readArticleByVersionId$lambda$2(ArticleVersionId $versionId) {
        Intrinsics.checkNotNullParameter((Object)$versionId, (String)"$versionId");
        return new ArticleVersionNotFoundException($versionId);
    }

    private static final ArticleVersionDto readVersions$lambda$5$lambda$4(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (ArticleVersionDto)$tmp0.invoke(p0);
    }

    public static final /* synthetic */ ApplicationEventPublisher access$getApplicationEventPublisher$p(ArticleService $this) {
        return $this.applicationEventPublisher;
    }

    public static final /* synthetic */ EntityManager access$getEntityManager$p(ArticleService $this) {
        return $this.entityManager;
    }
}

