/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.wikiservice.application;

import de.justsoftware.wikiservice.authorization.AuthContext;
import de.justsoftware.wikiservice.business.WikiOverviewService;
import de.justsoftware.wikiservice.persistence.model.WikiOverview;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0017\u0018\u00002\u00020\u0001B\u000f\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016J0\u0010\t\u001a\n \n*\u0004\u0018\u00010\u00060\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0092\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lde/justsoftware/wikiservice/application/WikiOverviewApplicationService;", "", "wikiOverviewDisplayService", "Lde/justsoftware/wikiservice/business/WikiOverviewService;", "(Lde/justsoftware/wikiservice/business/WikiOverviewService;)V", "getWikiOverview", "Lde/justsoftware/wikiservice/persistence/model/WikiOverview;", "authContext", "Lde/justsoftware/wikiservice/authorization/AuthContext;", "setWikiOverview", "kotlin.jvm.PlatformType", "sort", "Lde/justsoftware/wikiservice/persistence/model/WikiOverview$Companion$Sort;", "direction", "Lde/justsoftware/wikiservice/persistence/model/WikiOverview$Companion$Direction;", "display", "Lde/justsoftware/wikiservice/persistence/model/WikiOverview$Companion$Display;", "wiki-service"})
public class WikiOverviewApplicationService {
    @NotNull
    private final WikiOverviewService wikiOverviewDisplayService;

    @Autowired
    public WikiOverviewApplicationService(@NotNull WikiOverviewService wikiOverviewDisplayService) {
        Intrinsics.checkNotNullParameter((Object)wikiOverviewDisplayService, (String)"wikiOverviewDisplayService");
        this.wikiOverviewDisplayService = wikiOverviewDisplayService;
    }

    @NotNull
    public WikiOverview getWikiOverview(@NotNull AuthContext authContext) {
        Intrinsics.checkNotNullParameter((Object)authContext, (String)"authContext");
        WikiOverview wikiOverview = this.wikiOverviewDisplayService.getWikiOverview(authContext.getUser());
        Intrinsics.checkNotNullExpressionValue((Object)wikiOverview, (String)"wikiOverviewDisplayServi\u2026verview(authContext.user)");
        return wikiOverview;
    }

    public WikiOverview setWikiOverview(@NotNull AuthContext authContext, @NotNull WikiOverview.Companion.Sort sort, @NotNull WikiOverview.Companion.Direction direction, @NotNull WikiOverview.Companion.Display display) {
        Intrinsics.checkNotNullParameter((Object)authContext, (String)"authContext");
        Intrinsics.checkNotNullParameter((Object)sort, (String)"sort");
        Intrinsics.checkNotNullParameter((Object)direction, (String)"direction");
        Intrinsics.checkNotNullParameter((Object)display, (String)"display");
        return this.wikiOverviewDisplayService.setWikiOverview(authContext.getUser(), sort, direction, display);
    }
}

