﻿/*
Copyright (c) 2003-2011, CKSource - Frederico Knabben. All rights reserved.
For licensing, see LICENSE.html or http://ckeditor.com/license
*/

CKEDITOR.editorConfig = function( config )
{
    // The configuration options below are needed when running CKEditor from source files.
    config.plugins = 'a11yhelp,about,basicstyles,blockquote,clipboard,'
        + 'codesnippet,colorbutton,colordialog,contextmenu,elementspath,'
        + 'enterkey,entities,filebrowser,floatingspace,font,format,'
        + 'horizontalrule,htmlwriter,image,indentlist,justify,link,list,'
        + 'magicline,maximize,pastefromword,pastetext,removeformat,resize,scayt,'
        + 'showblocks,showborders,sourcedialog,specialchar,stylescombo,tab,table,'
        + 'tableresize,tabletools,templates,toolbar,undo,widget,wsc,wysiwygarea';
    config.skin = 'bootstrapck';

    config.extraPlugins =
        justConnect.ckEditor.appendPlugins('jc_link,jc_image,jc_file,jc_fold,jc_contentbox,simpleuploads');

    config.removePlugins = 'link,image,forms,elementspath'; // 'forms' depends on 'image' so we have to remove it either.

    config.format_tags = 'p;h1;h2;h3;pre';

    config.disableNativeSpellChecker = false;

    config.removeFormatTags = 'b,big,code,del,dfn,em,font,i,ins,kbd,q,samp,small,span,strike,strong,sub,sup,tt,u,var,' +
        'h1,h2,h3,h4,h5,h6,' +
        'table,tbody,tr,td,' +
        'a,p,div,' +
        'ol,ul,li,dl,dt,dd,' +
        's';

    config.templates_files = [ '/toro/ckeditor/justConnectTemplates.js' ];

    config.fontSize_sizes = 'xx-small/xx-small;x-small/x-small;small/small;medium/medium;large/large;x-large/x-large;xx-large/xx-large';

    config.templates_replaceContent = false;

    // As we use antisamy for that purpose and e.g. import html-data, we have to deactivate CKEditors content filtering completely by allowing all HTML content.
    config.allowedContent = true;

    // CKEditor by default replaces i-tags by em-tags, but we need i-tags for the jc-fold plugin.
    config.coreStyles_italic = { element : 'i'};

    // Set the theme of codeSnippet. Serr available themes here: https://highlightjs.org/static/demo/
    config.codeSnippet_theme = 'monokai_sublime';

    // Set colors of font color selector to Just Social default app colors
    config.colorButton_colors = 'CD52B0,7CB342,5587A2,FFA000,EF5350,42b392';
};
