/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.onx.survey.presentation.client.ui;

import com.freiheit.toro.client.mediator.I18nMediator;
import com.freiheit.toro.client.mediator.PageTitleCallback;
import com.freiheit.toro.common.presentation.ui.LoadingDialog;
import com.freiheit.toro.common.shared.util.ClientStringUtil;
import com.freiheit.toro.common.shared.util.UrlUtil;
import com.github.gwtbootstrap.client.ui.constants.IconType;
import com.google.common.collect.ImmutableSet;
import com.google.gwt.core.client.GWT;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.uibinder.client.UiField;
import com.google.gwt.user.client.ui.Composite;
import com.google.gwt.user.client.ui.HTML;
import com.google.gwt.user.client.ui.Label;
import com.google.gwt.user.client.ui.Widget;
import de.justsoftware.onx.common.presentation.client.ClientFactory;
import de.justsoftware.onx.common.presentation.client.ui.InfoBoxWidget;
import de.justsoftware.onx.common.presentation.client.ui.InlineFeedbackWidget;
import de.justsoftware.onx.common.presentation.client.ui.OptionsWidget;
import de.justsoftware.onx.common.presentation.client.ui.PersonTeaserCollectionWidget;
import de.justsoftware.onx.common.shared.model.action.Action;
import de.justsoftware.onx.common.shared.model.action.StaticAction;
import de.justsoftware.onx.common.shared.util.CollectionUtil;
import de.justsoftware.onx.survey.presentation.client.ui.SurveyCreateOrEditHandler;
import de.justsoftware.onx.survey.presentation.client.ui.SurveyDetailsHandler;
import de.justsoftware.onx.survey.presentation.client.ui.SurveyDetailsWidget;
import de.justsoftware.onx.survey.presentation.client.ui.SurveyQuestionsWidget;
import de.justsoftware.onx.survey.presentation.client.ui.SurveyResultWidget;
import de.justsoftware.onx.survey.shared.i18n.SurveyConstants;
import de.justsoftware.onx.survey.shared.model.SurveyDetails;
import de.justsoftware.onx.survey.shared.model.SurveyId;
import de.justsoftware.onx.survey.shared.model.SurveyTeaser;
import java.util.Collection;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;

@ParametersAreNonnullByDefault
public class SurveyDetailsWidget
extends Composite {
    private static final ImmutableSet<Action> READ_ACTIONS = ImmutableSet.of((Object)StaticAction.SURVEY_READ, (Object)StaticAction.SURVEY_READ_RESULT);
    private static final SurveyConstants SURVEY = I18nMediator.SURVEY;
    private static final SurveyDetailsUIBinder UI_BINDER = (SurveyDetailsUIBinder)GWT.create(SurveyDetailsUIBinder.class);
    private static final SurveyBaseDataUIBinder BASE_DATA_UI_BINDER = (SurveyBaseDataUIBinder)GWT.create(SurveyBaseDataUIBinder.class);
    @UiField
    InlineFeedbackWidget _inlineMessage;
    @UiField
    InfoBoxWidget _questionsAndAnswers;
    @UiField
    InfoBoxWidget _baseData;
    @UiField
    InfoBoxWidget _headerData;
    @UiField
    InfoBoxWidget _adminData;
    @UiField
    InfoBoxWidget _privacyData;
    private SurveyDetails _surveyDetails;
    private final LoadingDialog _loadingDialog;
    private boolean _displayResult = true;
    private boolean _forceDisplayQuestions;
    private final boolean _forceDisplayResults;
    private boolean _displaySavedMessages;
    private final Long _countOfParticipantsReset;
    private final PageTitleCallback _titleCallback;
    private final ClientFactory _clientFactory;

    private SurveyDetailsWidget(boolean forceDisplayQuestions, boolean forceDisplayResults, boolean displaySavedMessages, @Nullable Long countOfParticipantsReset, PageTitleCallback titleCallback, ClientFactory clientFactory) {
        this._clientFactory = clientFactory;
        this.initWidget((Widget)UI_BINDER.createAndBindUi((Object)this));
        this._loadingDialog = new LoadingDialog();
        this._forceDisplayQuestions = forceDisplayQuestions;
        this._forceDisplayResults = forceDisplayResults;
        this._displaySavedMessages = displaySavedMessages;
        this._countOfParticipantsReset = countOfParticipantsReset;
        this._titleCallback = titleCallback;
    }

    public SurveyDetailsWidget(SurveyDetails survey, boolean forceDisplayQuestions, boolean forceDisplayResults, boolean displaySavedMessages, @Nullable Long countOfParticipantsReset, PageTitleCallback titleCallback, ClientFactory clientFactory) {
        this(forceDisplayQuestions, forceDisplayResults, displaySavedMessages, countOfParticipantsReset, titleCallback, clientFactory);
        this.setSurvey(survey);
    }

    private void setSurvey(SurveyDetails survey) {
        if (this._forceDisplayQuestions) {
            this._displayResult = false;
            this._forceDisplayQuestions = false;
        } else {
            boolean hasParticipated = !CollectionUtil.isEmpty((Iterable)survey.getCurrentUserAnswers());
            boolean maySeeResult = survey.getAllowedActions().containsAll((Collection)READ_ACTIONS);
            this._displayResult = (this._forceDisplayResults || hasParticipated) && maySeeResult;
        }
        this._surveyDetails = survey;
        this._titleCallback.setPageTitle(survey.getTitle());
        this._baseData.setContent((Widget)new SurveyBaseData(this));
        this._headerData.setContent((Widget)this.createOptionsWidget());
        this._adminData.setContent((Widget)this.createAdminTeaserCollectionWidget());
        this.updatePrivacyData();
        if (!this._displaySavedMessages) {
            this._inlineMessage.setVisible(false);
        } else {
            if (this._countOfParticipantsReset == null || this._countOfParticipantsReset.intValue() <= 0) {
                this._inlineMessage.setMessage(SURVEY.answersSaved());
            } else {
                this._inlineMessage.setMessage(I18nMediator.SURVEY_MSG.questionSavedXAnswersOfParticipantDeleted(this._countOfParticipantsReset.intValue()));
            }
            this._inlineMessage.setType(InlineFeedbackWidget.InlineType.SUCCESS);
            this._inlineMessage.showAndHideAfterDelay();
            this._displaySavedMessages = false;
        }
        this._questionsAndAnswers.setStyleName("survey-questions", !this._displayResult);
        this._questionsAndAnswers.setStyleName("survey-results", this._displayResult);
        if (this._displayResult) {
            this._questionsAndAnswers.setLabel(SURVEY.resultOfSurveyLabel());
            this._questionsAndAnswers.setContent((Widget)new SurveyResultWidget((SurveyTeaser)this._surveyDetails, this._clientFactory));
        } else {
            this._questionsAndAnswers.setLabel(SURVEY.surveyQuestionsLabel());
            this._questionsAndAnswers.setContent((Widget)new SurveyQuestionsWidget((SurveyTeaser)this._surveyDetails, this._clientFactory));
        }
    }

    @Nonnull
    private OptionsWidget createOptionsWidget() {
        OptionsWidget optionInfoBox = new OptionsWidget();
        boolean hasParticipated = !CollectionUtil.isEmpty((Iterable)this._surveyDetails.getCurrentUserAnswers());
        ImmutableSet allowedActions = this._surveyDetails.getAllowedActions();
        if (allowedActions.contains(StaticAction.SURVEY_READ) && this._displayResult) {
            optionInfoBox.addLink(IconType.LIST_UL, hasParticipated ? SURVEY.displayMyAnswersLabel() : SURVEY.displaySurveyQuestions(), SurveyDetailsHandler.token((SurveyId)this._surveyDetails.getSurveyId(), (boolean)true, (boolean)false, (Long)0L));
        }
        if (allowedActions.contains(StaticAction.SURVEY_READ_RESULT) && !this._displayResult) {
            optionInfoBox.addLink(IconType.BAR_CHART, SURVEY.displayResultLabel(), SurveyDetailsHandler.token((SurveyId)this._surveyDetails.getSurveyId(), (boolean)false, (boolean)true, (boolean)false, (Long)0L));
        }
        if (allowedActions.contains(StaticAction.SURVEY_CHANGE_OWN_GIVEN_ANSWER) && hasParticipated) {
            optionInfoBox.addLink(IconType.TRASH, SURVEY.deleteMyAnswersOption(), (ClickHandler)new SurveyChangeOwnGivenAnswerClickHandler(this));
        }
        if (allowedActions.contains(StaticAction.SURVEY_UPDATE)) {
            optionInfoBox.addLink(IconType.COG, SURVEY.editSurveyOption(), SurveyCreateOrEditHandler.token((SurveyId)this._surveyDetails.getSurveyData().getId(), null, (int)0));
        }
        if (allowedActions.contains(StaticAction.SURVEY_READ_RESULT)) {
            optionInfoBox.addLinkToExtern(IconType.TABLE, SURVEY.csvExportLabel(), UrlUtil.getSurveyExportUrl((SurveyId)this._surveyDetails.getSurveyId()), true);
        }
        if (allowedActions.contains(StaticAction.SURVEY_DELETE)) {
            optionInfoBox.addLink(IconType.TRASH, SURVEY.deleteSurveyOption(), (ClickHandler)new SurveyDeleteClickHandler(this));
        }
        if (optionInfoBox.getLinkCount() <= 0) {
            optionInfoBox.setVisible(false);
        }
        return optionInfoBox;
    }

    @Nonnull
    private PersonTeaserCollectionWidget createAdminTeaserCollectionWidget() {
        PersonTeaserCollectionWidget personTeaserCollectionWidget = new PersonTeaserCollectionWidget();
        personTeaserCollectionWidget.addPerson(this._surveyDetails.getSurveyOwner());
        return personTeaserCollectionWidget;
    }

    private void updatePrivacyData() {
        this._privacyData.setContent((Widget)new HTML("<b>" + ClientStringUtil.htmlEscape((String)SURVEY.resultVisibilityLabel()) + "</b><BR/>"));
        switch (1.$SwitchMap$de$justsoftware$onx$survey$shared$model$SurveyResultVisibility[this._surveyDetails.getSurveyData().getResultVisibility().ordinal()]) {
            case 1: {
                this._privacyData.addContent((Widget)new Label(SURVEY.visibilityAdmin()));
                break;
            }
            case 2: {
                this._privacyData.addContent((Widget)new Label(SURVEY.visibilityParticipant()));
                break;
            }
            case 3: {
                this._privacyData.addContent((Widget)new Label(SURVEY.visibilityParticipantAndAfterExpiratationForAll()));
                break;
            }
            default: {
                this._privacyData.addContent((Widget)new Label("unknown"));
            }
        }
        this._privacyData.addContent((Widget)new HTML("<BR/><b>" + ClientStringUtil.htmlEscape((String)SURVEY.surveyTypeLabel()) + "</b><BR/>"));
        if (this._surveyDetails.getSurveyData().isAnonym()) {
            this._privacyData.addContent((Widget)new Label(SURVEY.anonymous()));
        } else {
            this._privacyData.addContent((Widget)new Label(SURVEY.named()));
        }
        this._privacyData.addContent((Widget)new HTML("<BR/><b>" + ClientStringUtil.htmlEscape((String)SURVEY.changingLabel()) + "</b><BR/>"));
        if (this._surveyDetails.getSurveyData().isParticipantMayModify()) {
            this._privacyData.addContent((Widget)new Label(SURVEY.participantMayChangesAnswers()));
        } else {
            this._privacyData.addContent((Widget)new Label(SURVEY.participantDoNotChangeAnswers()));
        }
    }
}

