/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.onx.searchnew.presentation.server;

import com.freiheit.toro.common.shared.model.ServiceException;
import com.google.common.base.Charsets;
import com.google.common.collect.Iterables;
import de.justsoftware.onx.authorization.business.AuthorizationContext;
import de.justsoftware.onx.authorization.business.SessionAuthorizationContextProvider;
import de.justsoftware.onx.common.shared.model.action.Action;
import de.justsoftware.onx.common.shared.model.action.StaticAction;
import de.justsoftware.onx.searchnew.business.SearchIndexService;
import de.justsoftware.onx.searchnew.business.SearchService;
import de.justsoftware.onx.searchnew.business.SolrAdminService;
import de.justsoftware.onx.searchnew.presentation.server.SearchSynonymFileUploadServlet;
import java.io.IOException;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.solr.common.util.ContentStream;
import org.json.JSONException;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.multipart.MultipartHttpServletRequest;

@Controller(value="searchSynonymFileUploadServlet")
@RequestMapping(value={"/upload/searchSynonym"}, method={RequestMethod.GET, RequestMethod.POST})
public class SearchSynonymFileUploadServlet {
    private static final Logger LOG = LoggerFactory.getLogger(SearchSynonymFileUploadServlet.class);
    @Autowired
    private SessionAuthorizationContextProvider _authorizationContextProvider;
    @Autowired
    private SolrAdminService _solrAdminService;
    @Autowired
    private SearchService _searchService;
    @Autowired
    private SearchIndexService _searchIndexService;

    private void setResponseMessage(@Nonnull HttpServletResponse response, @Nonnull Status status, @Nullable String message) {
        try {
            JSONObject jsonObject = new JSONObject();
            jsonObject.put("status", (Object)status.getStatusType());
            if (message != null) {
                jsonObject.put(status.getMessageFieldName(), (Object)message);
            }
            response.setCharacterEncoding(Charsets.UTF_8.name());
            response.setContentType("text/html");
            response.getWriter().write(jsonObject.toString());
        }
        catch (IOException | JSONException e) {
            LOG.error("Unexpected error during create JSON response object", e);
            response.setStatus(500);
            return;
        }
    }

    @RequestMapping(method={RequestMethod.POST})
    public void handleRequest(@Nonnull HttpServletResponse response, @Nonnull MultipartHttpServletRequest request) {
        AuthorizationContext authorizationContext = this._authorizationContextProvider.getAuthorizationContextForCurrentUser((HttpServletRequest)request);
        if (!authorizationContext.may((Action)StaticAction.ADMIN_SYSTEM_ADMINISTRATION)) {
            this.setResponseMessage(response, Status.ERROR, "Your don't have the permission to upload a new search synonym file");
            response.setStatus(403);
            return;
        }
        Map fileMap = request.getFileMap();
        MultipartFile file = (MultipartFile)Iterables.getFirst(fileMap.values(), null);
        if (file == null) {
            this.setResponseMessage(response, Status.ERROR, "No search synonym file found");
            response.setStatus(400);
            return;
        }
        try {
            this._solrAdminService.saveConfigFileToSolr("synonyms.txt", (ContentStream)new MultipartFileContentStream(file));
        }
        catch (ServiceException e) {
            response.setStatus(500);
            LOG.error("ServiceException: Failed to save synonym file: " + e.getMessage(), (Throwable)e);
            this.setResponseMessage(response, Status.ERROR, "Failed to save synonym file: " + e.getMessage());
            return;
        }
        try {
            this._searchIndexService.fullImport((Set)this._searchService.getAllFilterTypes(), false);
        }
        catch (RuntimeException e) {
            LOG.error("Failed to do a reindex after uploading synonyms files successfully: ", (Throwable)e);
            response.setStatus(500);
            this.setResponseMessage(response, Status.ERROR, "Uploaded synonym file success, but couldn't reindex solr. Maybe a fullindex is still running? Reindex the Solr server later. For more information see server log.");
            return;
        }
        response.setStatus(200);
        this.setResponseMessage(response, Status.SUCCESS, null);
    }
}

