/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.onx.searchnew.presentation.server;

import com.freiheit.toro.common.shared.model.InvalidIdServiceException;
import com.google.common.collect.ImmutableList;
import de.justsoftware.onx.authorization.business.AuthorizationContext;
import de.justsoftware.onx.authorization.business.SearchAuthorizationCheckContext;
import de.justsoftware.onx.authorization.business.SessionAuthorizationContextProvider;
import de.justsoftware.onx.common.business.InvalidIDException;
import de.justsoftware.onx.searchnew.business.SearchDispatcherService;
import de.justsoftware.onx.searchnew.business.SearchService;
import de.justsoftware.onx.searchnew.presentation.shared.SearchController;
import de.justsoftware.onx.searchnew.shared.model.FederatedSearchResultEntry;
import de.justsoftware.onx.searchnew.shared.model.InvalidSearchFieldException;
import de.justsoftware.onx.searchnew.shared.model.SearchParameters;
import de.justsoftware.onx.searchnew.shared.model.SearchProvider;
import de.justsoftware.onx.searchnew.shared.model.SearchResult;
import de.justsoftware.onx.searchnew.shared.model.SearchTrackingAction;
import de.justsoftware.onx.searchnew.shared.model.SortType;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class SearchControllerImpl
implements SearchController {
    @Autowired
    private SessionAuthorizationContextProvider _sessionAuthorizationContextProvider;
    @Autowired
    private SearchDispatcherService _searchDispatcher;
    @Autowired
    private SearchService _searchService;

    public SearchResult<FederatedSearchResultEntry> count(SearchParameters searchParameter) {
        SearchResult result = this.search(searchParameter, 0, 10, null);
        SearchResult countResult = new SearchResult(result.getNumberOfResults(), ImmutableList.of(), result.getSearchProvider());
        countResult.setHasMoreResults(result.hasMoreResults());
        return countResult;
    }

    public SearchResult<FederatedSearchResultEntry> search(SearchParameters searchParameter, int offset, int numberOfResults, String searchTrackingId) throws InvalidSearchFieldException {
        AuthorizationContext authorizationContext = this._sessionAuthorizationContextProvider.getAuthorizationContextForCurrentUser();
        try {
            return this._searchDispatcher.search(searchParameter, offset, numberOfResults, searchTrackingId, (SearchAuthorizationCheckContext)authorizationContext);
        }
        catch (InvalidIDException e) {
            throw new InvalidIdServiceException(e.getMessage());
        }
    }

    public void trackFeedback(String searchTrackingId, String searchResultId, SearchTrackingAction action, SortType sortType) {
        AuthorizationContext authorizationContext = this._sessionAuthorizationContextProvider.getAuthorizationContextForCurrentUser();
        this._searchService.trackFeedback(searchTrackingId, searchResultId, action, sortType, (SearchAuthorizationCheckContext)authorizationContext);
    }

    public ImmutableList<SearchProvider> getAvailableSearchProvider() {
        return this._searchDispatcher.getProviderModelList();
    }
}

