/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.onx.searchnew.presentation.client.ui;

import com.freiheit.toro.client.mediator.I18nMediator;
import com.freiheit.toro.common.presentation.ui.HTMLUtil;
import com.github.gwtbootstrap.client.ui.constants.IconType;
import com.google.gwt.user.client.ui.InlineHyperlink;
import com.google.gwt.user.client.ui.Widget;
import de.justsoftware.onx.common.presentation.client.ClientFactory;
import de.justsoftware.onx.common.presentation.client.ui.JCIconOnlyAnchor;
import de.justsoftware.onx.container.shared.model.NewsPostId;
import de.justsoftware.onx.container.shared.model.SearchableId;
import de.justsoftware.onx.searchnew.presentation.client.SearchTrackingInfo;
import de.justsoftware.onx.searchnew.presentation.client.ui.BaseSearchResultBadgePresenter;
import de.justsoftware.onx.searchnew.shared.model.NewsPostSearchResultBadgeModel;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;

@ParametersAreNonnullByDefault
public class NewsPostSearchResultBadgePresenter
extends BaseSearchResultBadgePresenter {
    private final NewsPostSearchResultBadgeModel _model;
    private final String _targetHistoryToken;

    public NewsPostSearchResultBadgePresenter(ClientFactory clientFactory, NewsPostSearchResultBadgeModel model, @Nullable String searchString, boolean displayParents, boolean displayContextSwitch, @Nullable SearchTrackingInfo searchTrackingInfo, @Nullable String additionalOverlayStyleName) {
        super(clientFactory, displayContextSwitch, (SearchableId)model.getId(), searchTrackingInfo, additionalOverlayStyleName);
        this._model = model;
        this._targetHistoryToken = "/news/posts/" + ((NewsPostId)this._model.getId()).getId();
        this.setIcon(IconType.COMMENTS);
        this.setTitle();
        this.setLastChangeDate(this._model.getModifyDate());
        this._view.setParentEnabled(true);
        if (model.getChannelTitle() != null) {
            InlineHyperlink parentLink = new InlineHyperlink(this._model.getChannelTitle(), "/news/channel/" + this._model.getChannelId().getId());
            parentLink.setTitle(this._model.getChannelTitle());
            this._view.setParentWidget((Widget)parentLink);
        }
        this._view.setParentEnabled(displayParents);
    }

    private void setTitle() {
        this._view.setTitleWidget(new InlineHyperlink(HTMLUtil.highlightedHtmlEscape((String)this._model.getName()), this._targetHistoryToken));
    }

    private void setIcon(IconType iconType) {
        JCIconOnlyAnchor icon = new JCIconOnlyAnchor(iconType, "");
        icon.addStyleName("action");
        icon.addStyleName("badgeIcon");
        icon.addStyleName("news");
        icon.addStyleName("app-news-color");
        icon.setTitle(I18nMediator.WORKSTREAM.microblogPosting());
        this._view.setIconWidget((Widget)icon);
    }
}

