/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.onx.searchnew.presentation.client;

import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.google.gwt.user.client.ui.SuggestOracle;
import de.justsoftware.onx.common.presentation.client.DataSuggestion;
import de.justsoftware.onx.common.presentation.client.ServerSideSuggestOracle;
import de.justsoftware.onx.searchnew.presentation.client.AbstractSolrSuggestOracle;
import de.justsoftware.onx.searchnew.presentation.client.CommonSearchMediator;
import de.justsoftware.onx.searchnew.shared.model.FilterType;
import de.justsoftware.onx.searchnew.shared.model.SearchContextModel;
import de.justsoftware.onx.searchnew.shared.model.SearchSuggestModelVisitor;
import de.justsoftware.onx.searchnew.shared.model.SortType;
import de.justsoftware.onx.searchnew.shared.model.SubFilter;
import de.justsoftware.onx.searchnew.shared.model.SuggestModel;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.annotation.Nonnull;

public abstract class AbstractSolrSuggestOracle<T extends SuggestModel<?, ?>>
extends ServerSideSuggestOracle<T, DataSuggestion<T>> {
    private ImmutableSet<FilterType> _filterTypes;
    private SearchContextModel _searchContextModel;
    private Collection<SubFilter> _additionalFilter;

    protected AbstractSolrSuggestOracle(@Nonnull ImmutableSet<FilterType> filterTypes) {
        this._filterTypes = filterTypes;
        this._additionalFilter = new ArrayList();
    }

    public void setFilterTypes(@Nonnull ImmutableSet<FilterType> filterTypes) {
        this._filterTypes = filterTypes;
    }

    @Nonnull
    public ImmutableSet<FilterType> getFilterTypes() {
        return this._filterTypes;
    }

    public void setSearchContextModel(SearchContextModel searchContextModel) {
        this._searchContextModel = searchContextModel;
    }

    public void setAdditionalFilter(Collection<SubFilter> additionalFilter) {
        this._additionalFilter = additionalFilter;
    }

    public boolean isDisplayStringHTML() {
        return true;
    }

    protected List<DataSuggestion<T>> convertToFormattedSuggestions(@Nonnull String originalQuery, @Nonnull Collection<SuggestModel<?, ?>> candidates) {
        ArrayList suggestions = Lists.newArrayListWithCapacity((int)candidates.size());
        for (SuggestModel<?, ?> candidate : candidates) {
            DataSuggestion dataSuggestion = (DataSuggestion)candidate.visit(this.createDataSuggestionConverter(originalQuery));
            if (dataSuggestion == null) continue;
            suggestions.add(dataSuggestion);
        }
        return suggestions;
    }

    @Nonnull
    protected abstract SearchSuggestModelVisitor<DataSuggestion<T>> createDataSuggestionConverter(@Nonnull String var1);

    protected DataSuggestion<T> createSuggestion(String displayString, String replacementString, T data) {
        throw new IllegalStateException("We have not to use this method, because the Method is overriden");
    }

    protected String getReplacementStringFromDataSuggestion(T suggestionData) {
        throw new IllegalStateException("We have not to use this method, because the Method is overriden");
    }

    protected void search(SuggestOracle.Request request, String normalizedQuery, SuggestOracle.Callback callback) {
        CommonSearchMediator.getInstance().suggest(normalizedQuery, this._searchContextModel, this._additionalFilter, this._filterTypes, SortType.RELEVANCE, 0, request.getLimit(), (AsyncCallback)new SearchResultCallback(this, request, callback));
    }

    public void requestDefaultSuggestions(SuggestOracle.Request request, SuggestOracle.Callback callback) {
        callback.onSuggestionsReady(request, new SuggestOracle.Response(new ArrayList()));
    }
}

