/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.onx.person.presentation.client.ui;

import com.freiheit.toro.client.mediator.Callback;
import com.freiheit.toro.client.mediator.I18nMediator;
import com.github.gwtbootstrap.client.ui.ButtonGroup;
import com.github.gwtbootstrap.client.ui.ButtonToolbar;
import com.github.gwtbootstrap.client.ui.NavLink;
import com.github.gwtbootstrap.client.ui.base.HasIcon;
import com.github.gwtbootstrap.client.ui.constants.IconType;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.event.logical.shared.HasAttachHandlers;
import com.google.gwt.user.client.ui.Composite;
import com.google.gwt.user.client.ui.Widget;
import de.justsoftware.onx.common.presentation.client.ui.ConfirmDialogOpeningClickHandler;
import de.justsoftware.onx.common.presentation.client.ui.DelegatingClickHandler;
import de.justsoftware.onx.common.presentation.client.ui.JCButton;
import de.justsoftware.onx.person.presentation.client.ui.ReactProfileOptionView;
import de.justsoftware.onx.person.presentation.client.ui.component.ProfileOptionsView;
import de.justsoftware.onx.person.shared.i18n.ProfileConstants;
import de.justsoftware.onx.person.shared.i18n.ProfileMessages;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;

@ParametersAreNonnullByDefault
public class ReactProfileOptionView
extends Composite
implements ProfileOptionsView {
    private static final ProfileConstants PROFILE = I18nMediator.PROFILE;
    private static final ProfileMessages PROFILE_MSG = I18nMediator.PROFILE_MSG;
    private final ButtonGroup _buttonGroup = new ButtonGroup();
    private final MoreButton _moreButton = new MoreButton();
    private final ButtonToolbar _buttonToolbar = new ButtonToolbar();

    public ReactProfileOptionView() {
        this._buttonToolbar.add((Widget)this._buttonGroup);
        this._buttonGroup.addStyleName("profile-options-button-group");
        this._moreButton.addStyleName("profile-options-more-button");
        this.initWidget((Widget)this._buttonToolbar);
    }

    public void addPersonEdit(String historyToken, boolean extended) {
        this.addLink(null, PROFILE.editProfile(), historyToken, true);
    }

    public void addAdminDeleteWithoutPassword(Callback selected, String fullName, boolean extended) {
        this.addLink(PROFILE.deletePerson(), (ClickHandler)new ConfirmDialogOpeningClickHandler(PROFILE_MSG.deleteAccountQuestion(fullName), selected), true);
    }

    public void addAdminBlockProfile(Callback selected, boolean personIsBlocked, boolean extended) {
        String linkText = personIsBlocked ? PROFILE.unblockPerson() : PROFILE.blockPerson();
        this.addLink(linkText, (ClickHandler)new DelegatingClickHandler(selected), true);
    }

    public void addAdminActivateProfile(Callback selected, boolean personIsActive) {
        String linkText = personIsActive ? PROFILE.deactivatePerson() : PROFILE.activatePerson();
        this.addLink(linkText, (ClickHandler)new DelegatingClickHandler(selected), true);
    }

    public void addRemoveContact(Callback selected, boolean extended) {
        this.addLink(IconType.OK, PROFILE.contact(), (ClickHandler)new ConfirmDialogOpeningClickHandler(PROFILE.reallyRemoveContact(), selected), false);
    }

    public void addRemoveInvitation(Callback selected, boolean extended) {
        this.addLink(PROFILE.removeContactRequest(), (ClickHandler)new ConfirmDialogOpeningClickHandler(PROFILE.reallyRemoveContactRequest(), selected), false);
    }

    public void addAcceptInvitation(Callback selected, boolean extended) {
        this.addLink(PROFILE.acceptInvitation(), (ClickHandler)new DelegatingClickHandler(selected), false);
    }

    public void addDeclineInvitation(Callback selected, boolean extended) {
        this.addLink(PROFILE.declineInvitation(), (ClickHandler)new DelegatingClickHandler(selected), false);
    }

    public void addContact(Callback selected, boolean extended) {
        this.addLink(PROFILE.inviteAsContact(), (ClickHandler)new DelegatingClickHandler(selected), false);
    }

    public void addEditAccount(String token, boolean extended) {
        this.addLink(null, PROFILE.editAccountSettings(), token, true);
    }

    public void addStartChat(Callback selected, boolean extended) {
        DelegatingClickHandler startChatHandler = new DelegatingClickHandler(selected);
        JCButton startChat = new JCButton(PROFILE.startChat(), null, (ClickHandler)startChatHandler);
        this._buttonGroup.insert((Widget)startChat, 0);
        this.addLink(PROFILE.startChat(), (ClickHandler)startChatHandler, true);
    }

    private void addLink(String text, ClickHandler handler, boolean extended) {
        this.addLink(text, handler, extended, null);
    }

    private void addLink(String text, ClickHandler handler, boolean extended, IconType iconType) {
        NavLink link = new NavLink(text);
        link.addClickHandler(handler);
        this.setIcon((HasIcon)link, iconType);
        this.addExtendedOption(link);
        if (!extended) {
            this.addOption(new JCButton(text, iconType, handler));
        }
    }

    private void setIcon(HasIcon hasIcon, @Nullable IconType iconType) {
        if (iconType != null) {
            hasIcon.setIcon(iconType);
        }
    }

    public int getOptionCount() {
        return 0;
    }

    public void clearOptions() {
        this._buttonGroup.clear();
        this._moreButton.clear();
    }

    public void addLink(IconType iconType, String text, ClickHandler handler, boolean extended) {
        this.addLink(text, handler, extended, iconType);
    }

    public void addLink(IconType iconType, String text, ClickHandler handler, String hint, boolean extended) {
        this.addLink(iconType, text, handler, extended);
    }

    public void addLink(IconType iconType, String text, String historyItem, boolean extended) {
        NavLink link = new NavLink(text);
        this.setIcon((HasIcon)link, iconType);
        link.setTargetHistoryToken(historyItem);
        this.addExtendedOption(link);
        if (!extended) {
            JCButton button = new JCButton(text);
            this.setIcon((HasIcon)button, iconType);
            button.setTargetHistoryToken(historyItem);
            this.addOption(button);
        }
    }

    @Nonnull
    private HasIcon addOption(JCButton button) {
        this._buttonGroup.add((Widget)button);
        return button;
    }

    @Nonnull
    private HasIcon addExtendedOption(NavLink option) {
        if (this.getMoreButtonIndex() < 0) {
            this._buttonToolbar.add((Widget)this._moreButton);
        }
        this._moreButton.add((Widget)option);
        return option;
    }

    private int getMoreButtonIndex() {
        return this._buttonToolbar.getWidgetIndex((Widget)this._moreButton.getTriggerWidget());
    }

    public HasAttachHandlers asHasAttachHandlers() {
        return this;
    }
}

