/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.onx.person.presentation.client;

import com.freiheit.toro.util.client.HostPropertiesMediator;
import com.google.common.base.Joiner;
import com.google.common.base.MoreObjects;
import com.google.common.base.Splitter;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import de.justsoftware.onx.common.presentation.client.FieldNameResolver;
import de.justsoftware.onx.common.shared.model.BadgeField;
import de.justsoftware.onx.common.shared.model.BadgeFieldType;
import de.justsoftware.onx.person.presentation.client.ProfileFieldNameTranslator;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;

@ParametersAreNonnullByDefault
public enum ProfileFieldNameTranslator implements FieldNameResolver
{
    INSTANCE;

    private final ImmutableMap<String, String> _translation = HostPropertiesMediator.getHostPropertiesBean().getProfileBadgeFieldTranslation();

    public String resolveFieldName(BadgeField field) {
        return this.translateName(field.getName());
    }

    @Nonnull
    private String translateName(String fieldName) {
        return (String)MoreObjects.firstNonNull((Object)((String)this._translation.get((Object)fieldName)), (Object)fieldName);
    }

    @Nonnull
    public ImmutableList<BadgeField> translateValues(Iterable<BadgeField> fields) {
        ImmutableList.Builder builder = ImmutableList.builder();
        for (BadgeField field : fields) {
            builder.add((Object)new BadgeField(field.getName(), BadgeFieldType.VALUES, this.translateValues(field.getType(), field.getContentList())));
        }
        return builder.build();
    }

    @Nonnull
    public BadgeField translate(BadgeField field) {
        return new BadgeField(this.translateName(field.getName()), BadgeFieldType.VALUES, this.translateValues(field.getType(), field.getContentList()));
    }

    @Nonnull
    private ImmutableList<String> translateValues(BadgeFieldType type, ImmutableList<String> values) {
        switch (1.$SwitchMap$de$justsoftware$onx$common$shared$model$BadgeFieldType[type.ordinal()]) {
            case 1: {
                return this.translateSelectValues(values);
            }
            case 2: {
                return this.translateTreeSelectValues(values);
            }
        }
        return values;
    }

    @Nonnull
    private ImmutableList<String> translateSelectValues(Iterable<String> values) {
        ImmutableList.Builder builder = ImmutableList.builder();
        for (String valueKey : values) {
            builder.add((Object)this.translateName(valueKey));
        }
        return builder.build();
    }

    @Nonnull
    private ImmutableList<String> translateTreeSelectValues(ImmutableList<String> values) {
        ImmutableList.Builder builder = ImmutableList.builder();
        for (String treeValue : values) {
            builder.add((Object)Joiner.on((String)" - ").join((Iterable)this.translateSelectValues(Splitter.on((char)',').split((CharSequence)treeValue))));
        }
        return builder.build();
    }
}

