/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.onx.hierarchy.presentation.client.ui;

import com.github.gwtbootstrap.client.ui.base.ListItem;
import com.github.gwtbootstrap.client.ui.base.UnorderedList;
import com.github.gwtbootstrap.client.ui.constants.IconType;
import com.google.common.base.Objects;
import com.google.common.collect.Maps;
import com.google.gwt.core.client.GWT;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.uibinder.client.UiField;
import com.google.gwt.uibinder.client.UiHandler;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.google.gwt.user.client.ui.Composite;
import com.google.gwt.user.client.ui.FlowPanel;
import com.google.gwt.user.client.ui.IsWidget;
import com.google.gwt.user.client.ui.Label;
import com.google.gwt.user.client.ui.Panel;
import com.google.gwt.user.client.ui.Widget;
import de.justsoftware.onx.common.presentation.client.ui.JCIconOnlyAnchor;
import de.justsoftware.onx.common.shared.util.CollectionUtil;
import de.justsoftware.onx.components.presentation.client.ui.AnchorPanel;
import de.justsoftware.onx.container.presentation.client.EntityMediator;
import de.justsoftware.onx.container.presentation.client.EntityUtils;
import de.justsoftware.onx.container.presentation.client.PreviewPopupUtil;
import de.justsoftware.onx.container.presentation.client.ui.EntityIconCreator;
import de.justsoftware.onx.container.presentation.client.ui.EntityOverviewHandler;
import de.justsoftware.onx.container.shared.model.EntityId;
import de.justsoftware.onx.container.shared.model.EntityInfo;
import de.justsoftware.onx.hierarchy.presentation.client.ui.DynamicEntityTreeItem;
import de.justsoftware.onx.hierarchy.presentation.client.ui.DynamicEntityTreeWidget;
import de.justsoftware.onx.hierarchy.presentation.client.ui.EntityTreeItem;
import de.justsoftware.onx.hierarchy.shared.model.EntityTreeItemData;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

/*
 * Exception performing whole class analysis ignored.
 */
final class DynamicEntityTreeItem
extends Composite {
    private static final DynamicEntityTreeItemUIBinder UI_BINDER = (DynamicEntityTreeItemUIBinder)GWT.create(DynamicEntityTreeItemUIBinder.class);
    @UiField
    UnorderedList _childPanels;
    @UiField(provided=true)
    Panel _itemWidget;
    @UiField(provided=true)
    Widget _icon;
    @UiField
    Label _label;
    @UiField
    ListItem _listItem;
    @UiField
    JCIconOnlyAnchor _openCloseIcon;
    final EntityTreeItem _treeItem;
    final DynamicEntityTreeItem _parentItem;
    int _expandedChildItemCount;
    private final LinkedHashMap<EntityTreeItem, DynamicEntityTreeItem> _childItems = Maps.newLinkedHashMap();
    private boolean _expanded = false;
    private boolean _loading = false;
    private boolean _openCloseIconAvailable = false;
    private final DynamicEntityTreeWidget _container;

    DynamicEntityTreeItem(@Nonnull DynamicEntityTreeWidget container, @Nullable DynamicEntityTreeItem parentItem, EntityTreeItem myTreeItem) {
        this._container = container;
        this._treeItem = myTreeItem;
        this._parentItem = parentItem;
        container._itemsByEntityId.put((Object)myTreeItem.getId(), (Object)this);
        EntityTreeItemData itemData = this._treeItem.getData();
        EntityInfo entity = itemData.getEntity();
        this._icon = EntityIconCreator.DEFAULT.create(entity);
        this._itemWidget = DynamicEntityTreeItem.createItemWidget((EntityTreeItemData)itemData);
        this.initWidget((Widget)UI_BINDER.createAndBindUi((Object)this));
        this._label.setText(EntityUtils.getStartAtNamePrefix((EntityInfo)entity) + entity.getName());
        this._itemWidget.setTitle(entity.getName());
        this.buildChildItem();
        this.setExpanded(false);
        this.updateOpenCloseIconVisibility();
    }

    @UiHandler(value={"_openCloseIcon"})
    void onOpenIconClick(@Nonnull ClickEvent e) {
        if (this._openCloseIconAvailable && !this._loading) {
            this.setExpanded(!this._expanded);
        }
    }

    @Nonnull
    private static Panel createItemWidget(EntityTreeItemData itemData) {
        if (itemData.getEntity().isVisible()) {
            AnchorPanel link = new AnchorPanel();
            link.setTargetHistoryToken(EntityOverviewHandler.token((EntityId)((EntityId)itemData.getEntity().getId())));
            PreviewPopupUtil.attachEntityPreviewPopup((IsWidget)link, (EntityId)((EntityId)itemData.getEntity().getId()));
            return link;
        }
        return new FlowPanel();
    }

    void updateOpenCloseIconVisibility() {
        int fixedChildrenCount = 0;
        if (!CollectionUtil.isEmpty((Iterable)this._treeItem.getChildren())) {
            for (EntityTreeItem child : this._treeItem.getChildren()) {
                if (!this.isPartOfFixedTree(child)) continue;
                ++fixedChildrenCount;
            }
        }
        boolean bl = this._openCloseIconAvailable = this._treeItem.getChildCount() > fixedChildrenCount;
        if (this._openCloseIconAvailable) {
            boolean bl2 = this._expanded = this._expandedChildItemCount > this._treeItem.getChildCount();
            if (!this._expanded) {
                this.contractAll();
            }
        }
        this.setOpenStyle();
    }

    void buildChildItem() {
        this._childPanels.clear();
        for (EntityTreeItem e : this._treeItem.getChildren()) {
            DynamicEntityTreeItem item = (DynamicEntityTreeItem)this._childItems.get(e);
            if (item == null) {
                item = new DynamicEntityTreeItem(this._container, this, e);
                this._childItems.put(e, item);
            }
            this._childPanels.add((Widget)item);
        }
    }

    private void setExpanded(boolean expanded) {
        this._expandedChildItemCount = 0;
        if (!expanded) {
            this.contractAll();
        } else if (this._treeItem.isChildLoaded()) {
            this.buildChildItem();
            this.expandAll();
        } else {
            this._loading = true;
            this._openCloseIcon.setVisible(false);
            EntityMediator.getInstance().getDirectChildEntityTree(this._treeItem.getId(), this._container._treeEntityTypes, (AsyncCallback)new /* Unavailable Anonymous Inner Class!! */);
        }
    }

    private void contractAll() {
        this._expanded = false;
        this._expandedChildItemCount = 0;
        for (EntityTreeItem e : this._treeItem.getChildren()) {
            DynamicEntityTreeItem i = (DynamicEntityTreeItem)this._childItems.get(e);
            if (i == null) continue;
            if (!i.isPartOfFixedTree()) {
                i.setVisible(false);
                continue;
            }
            i.setVisible(true);
            ++this._expandedChildItemCount;
        }
        this.setOpenStyle();
    }

    boolean isPartOfFixedTree() {
        return this.isPartOfFixedTree(this._treeItem);
    }

    private boolean isPartOfFixedTree(@Nonnull EntityTreeItem treeItem) {
        if (this._container._fixedItems.contains((Object)treeItem.getId())) {
            return true;
        }
        if (Objects.equal((Object)EntityMediator.getInstance().getCurrentLayoutEntityId(), (Object)treeItem.getId())) {
            return true;
        }
        for (EntityTreeItem child : treeItem.getChildren()) {
            if (!this.isPartOfFixedTree(child)) continue;
            return true;
        }
        return false;
    }

    private void expandAll() {
        this._expanded = true;
        this._expandedChildItemCount = 0;
        this.setOpenStyle();
        for (EntityTreeItem e : this._treeItem.getChildren()) {
            DynamicEntityTreeItem i = (DynamicEntityTreeItem)this._childItems.get(e);
            if (i == null) continue;
            i.setVisible(true);
            ++this._expandedChildItemCount;
        }
    }

    private void setOpenStyle() {
        this._openCloseIcon.setVisible(this._openCloseIconAvailable);
        this._openCloseIcon.setIcon(this._expanded ? IconType.CHEVRON_DOWN : IconType.CHEVRON_RIGHT);
    }

    public DynamicEntityTreeItem getParentItem() {
        return this._parentItem;
    }

    public Map<EntityTreeItem, DynamicEntityTreeItem> getChildItems() {
        return this._childItems;
    }
}

