/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.onx.contentbuttons.presentation.client.ui;

import com.google.common.collect.ImmutableList;
import com.google.gwt.user.client.History;
import com.google.gwt.user.client.ui.Anchor;
import com.google.gwt.user.client.ui.Composite;
import com.google.gwt.user.client.ui.FlowPanel;
import com.google.gwt.user.client.ui.Widget;
import de.justsoftware.onx.common.shared.model.OptionsItem;
import de.justsoftware.onx.common.shared.model.component.ComponentTypeVisitor;
import de.justsoftware.onx.common.shared.model.component.StaticComponentType;
import de.justsoftware.onx.components.presentation.client.ui.HolmesService;
import de.justsoftware.onx.container.presentation.client.ui.EntityOverviewHandler;
import de.justsoftware.onx.container.shared.i18n.EntityMessages;
import de.justsoftware.onx.container.shared.model.EntityDetails;
import de.justsoftware.onx.container.shared.model.EntityId;
import de.justsoftware.onx.container.shared.model.EntityTab;
import de.justsoftware.onx.container.shared.model.StaticEntityTab;
import de.justsoftware.onx.contentbuttons.shared.model.ContentButtonsModuleData;
import de.justsoftware.onx.searchnew.shared.model.FilterTypeCountType;
import java.util.Optional;

public class ContentButtonsModuleWidget
extends Composite {
    private final FlowPanel _content = new FlowPanel();
    private final EntityMessages _entityMessages;
    private final HolmesService _holmes;

    public ContentButtonsModuleWidget(EntityDetails entityDetails, ContentButtonsModuleData moduleData, EntityMessages entityMessages, HolmesService holmes) {
        this._entityMessages = entityMessages;
        this._holmes = holmes;
        this.initWidget((Widget)this._content);
        this.addDocumentsContentButton(entityDetails.getId(), entityDetails.getOptionsItems());
        if (moduleData.showSubpages()) {
            this.addSubpagesContentButton(entityDetails.getId(), entityDetails.getVisibleHierarchyChildrenCount(), entityDetails.getOptionsItems());
        }
    }

    private void addDocumentsContentButton(EntityId entityId, ImmutableList<OptionsItem> optionItems) {
        Optional<OptionsItem> optionsItem = optionItems.stream().filter(o -> o.getComponentType().equals(StaticComponentType.DOCUMENT)).findFirst();
        if (optionsItem.isPresent()) {
            String token = EntityOverviewHandler.token((EntityId)entityId, (EntityTab)StaticEntityTab.DOCUMENTS);
            int count = optionsItem.get().getCount(FilterTypeCountType.STANDARD);
            if (count > 0 || optionsItem.get().isMayCreate()) {
                this.addContentButton(count == 1 ? this._entityMessages.contentButtonsDocumentsSingular() : this._entityMessages.contentButtonsDocumentsPlural(count), token, "DOCUMENTS");
            }
        }
    }

    private void addSubpagesContentButton(EntityId entityId, int visibleHierarchyChildrenCount, ImmutableList<OptionsItem> optionItems) {
        String token = EntityOverviewHandler.token((EntityId)entityId, (EntityTab)StaticEntityTab.HIERARCHY);
        if (visibleHierarchyChildrenCount > 0 || this.userMayCreateSubpages(optionItems)) {
            this.addContentButton(visibleHierarchyChildrenCount == 1 ? this._entityMessages.contentButtonsSubpagesSingular() : this._entityMessages.contentButtonsSubpagesPlural(visibleHierarchyChildrenCount), token, "SUBPAGES");
        }
    }

    private boolean userMayCreateSubpages(ImmutableList<OptionsItem> optionItems) {
        return optionItems.stream().anyMatch(o -> (Boolean)o.getComponentType().accept((ComponentTypeVisitor)new /* Unavailable Anonymous Inner Class!! */));
    }

    private void addContentButton(String buttonTitle, String historyToken, String trackButtonName) {
        Anchor button = new Anchor(buttonTitle);
        button.addClickHandler(e -> {
            this._holmes.track(this._holmes.createPayload("PAGE_ENTITY_MODULE").set("action", "CONTENT_BUTTON_CLICKED").set("button", trackButtonName));
            History.newItem((String)historyToken);
        });
        this._content.add((Widget)button);
    }
}

