/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.onx.container.presentation.server.model;

import de.justsoftware.onx.common.business.ServerLocalizedMessages;
import de.justsoftware.onx.container.server.i18n.EntityPrintPreviewMessages;
import de.justsoftware.onx.container.shared.i18n.EntityConstants;
import de.justsoftware.onx.container.shared.i18n.EntityVersionConstants;
import de.justsoftware.onx.container.shared.model.EntityType;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;

@ParametersAreNonnullByDefault
public class EntityPrintPreviewLabels {
    private final String _header;
    private final String _platformLogo;
    private final String _printPreviewOf;
    private final String _title;
    private final String _duration;
    private final String _location;
    private final String _version;
    private final String _releaseDate;
    private final String _expirationDate;
    private final String _processStatus;
    private final String _tags;
    private final String _assignedEntities;
    private final String _admins;
    private final String _coAdmins;
    private final String _inheritedCoAdmins;

    public EntityPrintPreviewLabels(ServerLocalizedMessages messages, EntityType entityType) {
        EntityPrintPreviewMessages previewMessages = messages.entityPrintPreviewMessages();
        EntityConstants entityConstants = messages.entityConstants(entityType);
        EntityVersionConstants versionConstants = messages.entityVersionConstants();
        this._header = previewMessages.header();
        this._platformLogo = previewMessages.platformLogo();
        this._printPreviewOf = previewMessages.printPreviewOf();
        this._title = previewMessages.titleLabel();
        this._duration = entityConstants.duration();
        this._location = entityConstants.location();
        this._version = versionConstants.version();
        this._releaseDate = versionConstants.releaseDate();
        this._expirationDate = versionConstants.expirationDate();
        this._processStatus = previewMessages.processStatus();
        this._tags = entityConstants.tags();
        this._assignedEntities = entityConstants.assignedToEntites();
        this._admins = entityConstants.admin();
        this._coAdmins = entityConstants.coAdmins();
        this._inheritedCoAdmins = entityConstants.inheritedAdmins();
    }

    @Nonnull
    public String getHeader() {
        return this._header;
    }

    @Nonnull
    public String getPlatformLogo() {
        return this._platformLogo;
    }

    @Nonnull
    public String getPrintPreviewOf() {
        return this._printPreviewOf;
    }

    @Nonnull
    public String getTitle() {
        return this._title;
    }

    @Nonnull
    public String getDuration() {
        return this._duration;
    }

    @Nonnull
    public String getLocation() {
        return this._location;
    }

    @Nonnull
    public String getVersion() {
        return this._version;
    }

    @Nonnull
    public String getReleaseDate() {
        return this._releaseDate;
    }

    @Nonnull
    public String getExpirationDate() {
        return this._expirationDate;
    }

    @Nonnull
    public String getProcessStatus() {
        return this._processStatus;
    }

    @Nonnull
    public String getTags() {
        return this._tags;
    }

    @Nonnull
    public String getAssignedEntities() {
        return this._assignedEntities;
    }

    @Nonnull
    public String getAdmins() {
        return this._admins;
    }

    @Nonnull
    public String getCoAdmins() {
        return this._coAdmins;
    }

    @Nonnull
    public String getInheritedCoAdmins() {
        return this._inheritedCoAdmins;
    }
}

