/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.onx.container.presentation.client.ui.navigator;

import com.freiheit.toro.client.mediator.I18nMediator;
import com.google.common.base.Function;
import com.google.common.base.Predicates;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.google.gwt.user.client.rpc.AsyncCallback;
import de.justsoftware.onx.common.presentation.client.ClientFactory;
import de.justsoftware.onx.container.presentation.client.ui.navigator.EntityNavigatorBreadcrumbView;
import de.justsoftware.onx.container.shared.model.EntityId;
import de.justsoftware.onx.container.shared.model.EntityInfo;
import de.justsoftware.onx.searchnew.shared.model.SearchParameters;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;

@ParametersAreNonnullByDefault
public class EntityNavigatorBreadcrumbPresenter
implements EntityNavigatorBreadcrumbView.Presenter {
    private final EntityNavigatorBreadcrumbView _view;
    private final EntityId _entityId;
    private final Map<EntityId, EntityNavigatorBreadcrumbView.ContextHierarchyItem> _contextHierarchyItemCache = Maps.newHashMap();
    private final ClientFactory _clientFactory;

    public EntityNavigatorBreadcrumbPresenter(ClientFactory clientFactory, SearchParameters searchParameters, EntityInfo entity) {
        this._clientFactory = clientFactory;
        this._entityId = (EntityId)entity.getId();
        this._contextHierarchyItemCache.put(this._entityId, new EntityNavigatorBreadcrumbView.ContextHierarchyItem(this._entityId, entity.getName(), entity.isVisible()));
        this._view = clientFactory.entityFactory().navigatorBreadcrumbView(this._entityId, searchParameters);
        this.updateView(searchParameters);
    }

    @Nonnull
    private EntityId getContextId(SearchParameters searchParameters) {
        EntityId searchContextId = searchParameters.getContextEntityId();
        return searchContextId != null ? searchContextId : this._entityId;
    }

    public EntityNavigatorBreadcrumbView getView() {
        return this._view;
    }

    private void updateView(SearchParameters searchParameters) {
        EntityId searchContextId = searchParameters.getContextEntityId();
        EntityId contextId = searchContextId != null ? searchContextId : this._entityId;
        ImmutableList contextHierarchy = searchParameters.getContextHierarchy();
        HashSet neededInfoIds = Sets.newHashSet((Object[])new EntityId[]{contextId});
        neededInfoIds.addAll(contextHierarchy);
        neededInfoIds.removeAll(this._contextHierarchyItemCache.keySet());
        if (neededInfoIds.isEmpty()) {
            this.updateViewWithCache(contextHierarchy, contextId);
        } else {
            this._clientFactory.entityFactory().controller().getInfoMapByIds(ImmutableSet.copyOf((Collection)neededInfoIds), (AsyncCallback)new /* Unavailable Anonymous Inner Class!! */);
        }
    }

    private void updateViewWithCache(ImmutableList<EntityId> contextHierarchy, EntityId contextId) {
        EntityNavigatorBreadcrumbView.ContextHierarchyItem contextIdItem = this.getFromCacheOrDeleted(contextId);
        ImmutableList contextHierarchyItems = FluentIterable.from(contextHierarchy).transform((Function)new /* Unavailable Anonymous Inner Class!! */).filter(Predicates.notNull()).toList();
        this._view.onContextChanged(contextIdItem, contextHierarchyItems);
    }

    @Nonnull
    private EntityNavigatorBreadcrumbView.ContextHierarchyItem getFromCacheOrDeleted(EntityId entityId) {
        EntityNavigatorBreadcrumbView.ContextHierarchyItem item = (EntityNavigatorBreadcrumbView.ContextHierarchyItem)this._contextHierarchyItemCache.get(entityId);
        if (item != null) {
            return item;
        }
        EntityNavigatorBreadcrumbView.ContextHierarchyItem itemDeleted = new EntityNavigatorBreadcrumbView.ContextHierarchyItem(entityId, I18nMediator.BASIC_CONSTANTS.deletedEntity(), false);
        this._contextHierarchyItemCache.put(entityId, itemDeleted);
        return itemDeleted;
    }

    public void onSearchParametersChanged(SearchParameters parameters) {
        this.updateView(parameters);
    }
}

