/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.onx.container.presentation.client.presenter.recommendastask;

import com.google.common.collect.ImmutableSet;
import de.justsoftware.onx.common.presentation.client.ui.input.ValueChangeHandler;
import de.justsoftware.onx.common.presentation.client.ui.input.ValueInput;
import de.justsoftware.onx.common.shared.i18n.BasicConstants;
import de.justsoftware.onx.common.shared.model.PersonId;
import de.justsoftware.onx.container.presentation.client.EntityMemberClientFactory;
import de.justsoftware.onx.container.presentation.client.EntityRecommendationClientFactory;
import de.justsoftware.onx.container.presentation.client.presenter.recommendastask.PersonSelectHandler;
import de.justsoftware.onx.container.presentation.client.presenter.recommendastask.ReceiverTypeSelected;
import de.justsoftware.onx.container.presentation.client.presenter.recommendastask.RecommendEntityAsTaskPresenter;
import de.justsoftware.onx.container.presentation.client.presenter.recommendastask.RecommendationSubmitHandler;
import de.justsoftware.onx.container.presentation.client.ui.recommendastask.EditablePager;
import de.justsoftware.onx.container.presentation.client.ui.recommendastask.RecommendEntityAsTaskView;
import de.justsoftware.onx.container.presentation.shared.model.EntityRecommendationPersonModel;
import de.justsoftware.onx.container.shared.i18n.EntityConstants;
import de.justsoftware.onx.container.shared.i18n.EntityMessages;
import de.justsoftware.onx.container.shared.model.EntityId;
import de.justsoftware.onx.container.shared.model.EntityInfo;
import de.justsoftware.onx.container.shared.model.EntityType;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.ParametersAreNonnullByDefault;

@ParametersAreNonnullByDefault
public class RecommendEntityAsTaskPresenter
implements RecommendEntityAsTaskView.Presenter {
    final List<PersonId> _receivers = new ArrayList();
    final Map<PersonId, EntityRecommendationPersonModel> _receiverModels = new HashMap();
    private final EntityRecommendationClientFactory _clientFactory;
    private final RecommendEntityAsTaskView _view;
    private final EntityConstants _i18n;
    private final ValueInput<String> _title;
    private final ValueInput<String> _description;

    public RecommendEntityAsTaskPresenter(EntityRecommendationClientFactory clientFactory, EntityMemberClientFactory memberClientFactory, EntityInfo entity, EntityConstants i18n, EntityMessages i18nMsg, BasicConstants basicI18n, ImmutableSet<EntityType> activeEntityTypes) {
        this._clientFactory = clientFactory;
        this._i18n = i18n;
        this._view = this._clientFactory.getRecommendAsTaskView(this._i18n, basicI18n);
        this._title = this._view.addInputField(this._i18n.recommendationTitleLabel(), i18nMsg.recommendationPrefilledTitle(entity.getName()));
        this._description = this._view.addTextarea(this._i18n.recommendationDescriptionLabel());
        ValueInput dropdown = this._view.addDropdown(new String[]{this._i18n.recommendPerson(), this._i18n.recommendToMembersOfEntity()});
        ValueInput memberSearch = this._view.addPersonSearchField();
        ValueInput entitySearch = this._view.addEntitySearchField(activeEntityTypes);
        EditablePager pager = this._view.addPager((EditablePager.PagerDataProvider)new PagerDataFetcher(this, (EntityId)entity.getId()));
        this._view.addFooter(this._i18n.recommend(), (RecommendEntityAsTaskView.SubmitHandler)new RecommendationSubmitHandler(this._view, this._receivers, dropdown, (EntityId)entity.getId(), this._title, this._description, this._i18n, clientFactory));
        memberSearch.addChangeHandler((ValueChangeHandler)new PersonSelectHandler(dropdown, this._receivers, pager));
        ReceiverTypeSelected receiverTypeSelected = new ReceiverTypeSelected(this._view, memberClientFactory, this._receivers, dropdown, memberSearch, entitySearch, pager);
        receiverTypeSelected.onSelect(Integer.valueOf(0));
        dropdown.addChangeHandler((ValueChangeHandler)receiverTypeSelected);
    }

    public void show() {
        this._view.show();
        this._title.setFocus(true);
    }
}

